DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-13
      0.00000000000000E+00  -3.52151091401099E-12   0.00000000000000E+00  -7.63373197563070E-10   1.48876255566079E-22
      4.28496253625711E-09   3.52158933869419E-09  -7.94952621556948E-19  -2.47846792153666E-01  -2.47846792161913E-01
      0.00000000000000E+00   0.00000000000000E+00   8.24663290357812E-09   0.00000000000000E+00   8.24663290357812E-09
      3.70485193211984E-18  -2.47846792153659E-01  -2.44139204126651E-01   0.00000000000000E+00   2.44091920924958E-11
     -9.75174680922506E-23  -1.17926314343698E-08  -1.17682222422774E-08  -2.90989931056289E-18
      1.17500000000000E-12
      0.00000000000000E+00  -3.54245151409431E-12   0.00000000000000E+00  -5.10456624958733E-11   1.43842033572689E-22
      3.59345855806146E-09   3.54241289556573E-09  -7.99779131575780E-19  -2.45758708979514E-01  -2.45758708987290E-01
      0.00000000000000E+00   0.00000000000000E+00   7.77521311474241E-09   0.00000000000000E+00   7.77521311474241E-09
      3.71010020097229E-18  -2.45758708979512E-01  -2.42193067398462E-01   0.00000000000000E+00   3.28865241616565E-11
     -9.80165057974224E-23  -1.13505125344658E-08  -1.13176260103042E-08  -2.91032106939651E-18
      1.63062500000000E-12
      0.00000000000000E+00  -3.55549346677778E-12   0.00000000000000E+00  -4.01579896293092E-12   1.39517960754570E-22
      3.55948600424157E-09   3.55547020527877E-09  -8.02853241040689E-19  -2.44452979472822E-01  -2.44452979480247E-01
      0.00000000000000E+00   0.00000000000000E+00   7.42462877088342E-09   0.00000000000000E+00   7.42462877088342E-09
      3.71348304745602E-18  -2.44452979472819E-01  -2.40993677520438E-01   0.00000000000000E+00   3.60857367442600E-11
     -9.81407334820063E-23  -1.10161847129081E-08  -1.09800989761639E-08  -2.91062980641533E-18
      2.24571875000000E-12
      0.00000000000000E+00  -3.57184183000072E-12   0.00000000000000E+00   6.59592509018906E-13   1.32658798333923E-22
      3.57118559782210E-09   3.57184519033125E-09  -8.06706042853599E-19  -2.42815955710234E-01  -2.42815955717172E-01
      0.00000000000000E+00   0.00000000000000E+00   6.93804596275631E-09   0.00000000000000E+00   6.93804596275631E-09
      3.71775059616493E-18  -2.42815955710230E-01  -2.39504795656912E-01   0.00000000000000E+00   3.69561031105326E-11
     -9.66511482378296E-23  -1.05468472561992E-08  -1.05098911530888E-08  -2.91104455331133E-18
      3.07609531250000E-12
      0.00000000000000E+00  -3.59195582744916E-12   0.00000000000000E+00   9.37089424198843E-13   1.23274452798304E-22
      3.59107293422964E-09   3.59201002365396E-09  -8.11436679895887E-19  -2.40800255159461E-01  -2.40800255165779E-01
      0.00000000000000E+00   0.00000000000000E+00   6.31788741014630E-09   0.00000000000000E+00   6.31788741014630E-09
      3.72299682179483E-18  -2.40800255159455E-01  -2.37678126630237E-01   0.00000000000000E+00   3.48666247853691E-11
     -9.74884154488775E-23  -9.94476405858484E-09  -9.90989743379957E-09  -2.91156014189894E-18
      4.19710367187500E-12
      0.00000000000000E+00  -3.61620283807195E-12   0.00000000000000E+00   8.68596513433908E-13   1.11820879753450E-22
      3.61537908724147E-09   3.61624768375501E-09  -8.17101668032632E-19  -2.38378189372847E-01  -2.38378189378435E-01
      0.00000000000000E+00   0.00000000000000E+00   5.58781989010705E-09   0.00000000000000E+00   5.58781989010705E-09
      3.72926081460232E-18  -2.38378189372836E-01  -2.35478438652251E-01   0.00000000000000E+00   3.04549794917192E-11
     -9.79307868374239E-23  -9.23452255335444E-09  -9.20406757386282E-09  -2.91215914656969E-18
      5.71046495703125E-12
      0.00000000000000E+00  -3.64449101713187E-12   0.00000000000000E+00   7.86260582421423E-13   9.90333458395281E-23
      3.64375710410945E-09   3.64454336469197E-09  -8.23686434897778E-19  -2.35551938020407E-01  -2.35551938025193E-01
      0.00000000000000E+00   0.00000000000000E+00   4.78528303512051E-09   0.00000000000000E+00   4.78528303512051E-09
      3.73650267668618E-18  -2.35551938020393E-01  -2.32896123079448E-01   0.00000000000000E+00   2.48734346586400E-11
     -9.78978035470196E-23  -8.45469983446991E-09  -8.42982639981137E-09  -2.91281624178841E-18
      7.75350269199219E-12
      0.00000000000000E+00  -3.67636114094288E-12   0.00000000000000E+00   7.21475767359731E-13   8.57148717522909E-23
      3.67574073684220E-09   3.67646221260965E-09  -8.31077810893705E-19  -2.32365739487356E-01  -2.32365739491310E-01
      0.00000000000000E+00   0.00000000000000E+00   3.95445176755027E-09   0.00000000000000E+00   3.95445176755027E-09
      3.74458177086837E-18  -2.32365739487358E-01  -2.29961640487155E-01   0.00000000000000E+00   1.91337702772839E-11
     -9.76714640777020E-23  -7.65004775043738E-09  -7.63091398016020E-09  -2.91350395997467E-18
      1.05116036341895E-11
      0.00000000000000E+00  -3.71080291739570E-12   0.00000000000000E+00   6.84831672851604E-13   7.25331287709203E-23
      3.71036804429034E-09   3.71105287596327E-09  -8.39045543359410E-19  -2.28915116591915E-01  -2.28915116595056E-01
      0.00000000000000E+00   0.00000000000000E+00   3.14087052243146E-09   0.00000000000000E+00   3.14087052243146E-09
      3.75324460881561E-18  -2.28915116591930E-01  -2.26756465907688E-01   0.00000000000000E+00   1.38931441927155E-11
     -9.74330703614306E-23  -6.86581654258729E-09  -6.85192339839467E-09  -2.91419906545620E-18
      1.42350399061558E-11
      0.00000000000000E+00  -3.74643867543222E-12   0.00000000000000E+00   6.77315209780858E-13   6.02451464301916E-23
      3.74614472029344E-09   3.74682203550328E-09  -8.47241695963142E-19  -2.25348878470411E-01  -2.25348878472797E-01
      0.00000000000000E+00   0.00000000000000E+00   2.38661385806769E-09   0.00000000000000E+00   2.38661385806769E-09
      3.76213101342192E-18  -2.25348878470455E-01  -2.23416621691355E-01   0.00000000000000E+00   9.49303895070018E-12
     -9.78414155662742E-23  -6.14292893252088E-09  -6.13343589357028E-09  -2.91488931745878E-18
      1.92616788733103E-11
      0.00000000000000E+00  -3.78143152030829E-12   0.00000000000000E+00   2.64572601678432E-13   4.94304323986143E-23
      3.78113982655607E-09   3.78140439915780E-09  -8.55226480720899E-19  -2.21859559985350E-01  -2.21859559987076E-01
      0.00000000000000E+00   0.00000000000000E+00   1.72578446150615E-09   0.00000000000000E+00   1.72578446150615E-09
      3.77080590884503E-18  -2.21859559985408E-01  -2.20124505178235E-01   0.00000000000000E+00   6.47413893249888E-12
     -9.79151374804629E-23  -5.51366299959634E-09  -5.50718886066393E-09  -2.91557942812414E-18
      2.60476414789689E-11
      0.00000000000000E+00  -3.81339348885651E-12   0.00000000000000E+00   1.79139219485654E-13   4.04449640158463E-23
      3.81321398403445E-09   3.81339312325397E-09  -8.62522110948451E-19  -2.18660687563358E-01  -2.18660687564539E-01
      0.00000000000000E+00   0.00000000000000E+00   1.18062220463356E-09   0.00000000000000E+00   1.18062220463356E-09
      3.77881756697709E-18  -2.18660687563427E-01  -2.17087308775635E-01   0.00000000000000E+00   4.05570452504824E-12
     -9.77710060046369E-23  -4.99807103241278E-09  -4.99401532788783E-09  -2.91629545602864E-18
      3.52086909966080E-11
      0.00000000000000E+00  -3.84048768633273E-12   0.00000000000000E+00   1.12461582880138E-13   3.34958314136889E-23
      3.84041500345850E-09   3.84052746504142E-09  -8.68701300031101E-19  -2.15947253417659E-01  -2.15947253418420E-01
      0.00000000000000E+00   0.00000000000000E+00   7.60671285368958E-10   0.00000000000000E+00   7.60671285368958E-10
      3.78578611428900E-18  -2.15947253417740E-01  -2.14497632068351E-01   0.00000000000000E+00   2.40587066570338E-12
     -9.77745612473479E-23  -4.60360462107611E-09  -4.60119875041050E-09  -2.91708481425790E-18
      4.75761078454208E-11
      0.00000000000000E+00  -3.86152013115325E-12   0.00000000000000E+00   6.46655408497025E-14   2.86485721263265E-23
      3.86145944734035E-09   3.86152411288123E-09  -8.73491195858793E-19  -2.13847588728133E-01  -2.13847588728595E-01
      0.00000000000000E+00   0.00000000000000E+00   4.62548650475045E-10   0.00000000000000E+00   4.62548650475045E-10
      3.79150664626228E-18  -2.13847588728201E-01  -2.12485276343871E-01   0.00000000000000E+00   1.35407327605303E-12
     -9.77376501629445E-23  -4.32542683663221E-09  -4.32407276335626E-09  -2.91801545040349E-18
      6.42721205913181E-11
      0.00000000000000E+00  -3.87621528910646E-12   0.00000000000000E+00   3.38159020652244E-14   2.57136263592928E-23
      3.87614690444243E-09   3.87618072034452E-09  -8.76860350079050E-19  -2.12381928031888E-01  -2.12381928032159E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71226427537304E-10   0.00000000000000E+00   2.71226427537304E-10
      3.79603504615347E-18  -2.12381928031962E-01  -2.11075274415426E-01   0.00000000000000E+00   7.34702206661148E-13
     -9.77174503105581E-23  -4.14814185008837E-09  -4.14740714788181E-09  -2.91917469607442E-18
      8.68117377982794E-11
      0.00000000000000E+00  -3.88549160756442E-12   0.00000000000000E+00   2.30063248082069E-13   2.42077726217046E-23
      3.88544492052529E-09   3.88567498377340E-09  -8.79032908742268E-19  -2.11453875673985E-01  -2.11453875674148E-01
      0.00000000000000E+00   0.00000000000000E+00   1.62755968101555E-10   0.00000000000000E+00   1.62755968101555E-10
      3.79970350337263E-18  -2.11453875673859E-01  -2.10178471973523E-01   0.00000000000000E+00   1.90759734652292E-13
     -9.76479411229981E-23  -4.04862171160954E-09  -4.04843095187499E-09  -2.92067059463036E-18
      1.17240221027677E-10
      0.00000000000000E+00  -3.89109413653408E-12   0.00000000000000E+00   9.91905578605698E-14   2.37830416691221E-23
      3.89111902215769E-09   3.89121821271557E-09  -8.80403680644985E-19  -2.10887313074130E-01  -2.10887313074240E-01
      0.00000000000000E+00   0.00000000000000E+00   1.09633952811375E-10   0.00000000000000E+00   1.09633952811375E-10
      3.80303949826712E-18  -2.10887313073418E-01  -2.09626860534897E-01   0.00000000000000E+00   1.57530232430635E-13
     -9.11053956602428E-23  -4.00100969575927E-09  -4.00085216552693E-09  -2.92263581762213E-18
      1.58318673387364E-10
      0.00000000000000E+00  -3.89504346023400E-12   0.00000000000000E+00   3.17049040247227E-14   2.45372102974141E-23
      3.89501836112392E-09   3.89505006602797E-09  -8.81377204723838E-19  -2.10497725542772E-01  -2.10497725542859E-01
      0.00000000000000E+00   0.00000000000000E+00   8.69674037799812E-11   0.00000000000000E+00   8.69674037799812E-11
      3.80661198462014E-18  -2.10497725540280E-01  -2.09243186658834E-01   0.00000000000000E+00   1.57325374396388E-13
     -9.39702969148076E-23  -3.98217479518223E-09  -3.98201746980793E-09  -2.92523477989630E-18
      2.08318673387364E-10
      0.00000000000000E+00  -3.89825802603627E-12   0.00000000000000E+00   7.51415163619195E-15   2.54994519147919E-23
      3.89825197704058E-09   3.89825949119224E-09  -8.82177614385984E-19  -2.10174481971391E-01  -2.10174481971469E-01
      0.00000000000000E+00   0.00000000000000E+00   7.80785498952380E-11   0.00000000000000E+00   7.80785498952380E-11
      3.81051591211490E-18  -2.10174481967398E-01  -2.08921725059224E-01   0.00000000000000E+00   1.56482617064578E-13
     -9.62483973155761E-23  -3.97649452370451E-09  -3.97633804108754E-09  -2.92833829772892E-18
      2.58318673387364E-10
      0.00000000000000E+00  -3.90101336815249E-12   0.00000000000000E+00   3.15220279287035E-15   2.65827870218601E-23
      3.90102617888426E-09   3.90102933108708E-09  -8.82834609319213E-19  -2.09897100647740E-01  -2.09897100647814E-01
      0.00000000000000E+00   0.00000000000000E+00   7.41388983749928E-11   0.00000000000000E+00   7.41388983749928E-11
      3.81422285703365E-18  -2.09897100643713E-01  -2.08644710946175E-01   0.00000000000000E+00   1.50978063268554E-13
     -9.75494215165834E-23  -3.97531920752518E-09  -3.97516822946201E-09  -2.93138824771444E-18
      3.08318673387364E-10
      0.00000000000000E+00  -3.90358502079430E-12   0.00000000000000E+00   2.94095909653090E-15   2.77325602105420E-23
      3.90361867554179E-09   3.90362161650092E-09  -8.83415174750059E-19  -2.09637868285728E-01  -2.09637868285799E-01
      0.00000000000000E+00   0.00000000000000E+00   7.15937692466410E-11   0.00000000000000E+00   7.15937692466410E-11
      3.81780254549598E-18  -2.09637868279840E-01  -2.08385463628354E-01   0.00000000000000E+00   1.45655512788046E-13
     -1.02059720253019E-22  -3.97536104126026E-09  -3.97521538574758E-09  -2.93438737074592E-18
      3.58318673387364E-10
      0.00000000000000E+00  -3.90606482869891E-12   0.00000000000000E+00   2.57879775882019E-15   2.86509427077539E-23
      3.90610589053367E-09   3.90610846933146E-09  -8.83940731036544E-19  -2.09389158828756E-01  -2.09389158828825E-01
      0.00000000000000E+00   0.00000000000000E+00   6.95105740085521E-11   0.00000000000000E+00   6.95105740085521E-11
      3.82127807419641E-18  -2.09389158824000E-01  -2.08136626837638E-01   0.00000000000000E+00   1.41940505951427E-13
     -9.87058084852630E-23  -3.97576098384588E-09  -3.97561904334003E-09  -2.93733734315987E-18
      4.08318673387364E-10
      0.00000000000000E+00  -3.90854463660351E-12   0.00000000000000E+00   1.70228247141314E-15   2.97926655830615E-23
      3.90851155752437E-09   3.90851325980687E-09  -8.84420463077347E-19  -2.09148600894482E-01  -2.09148600894550E-01
      0.00000000000000E+00   0.00000000000000E+00   6.76368210893770E-11   0.00000000000000E+00   6.76368210893770E-11
      3.82465991525088E-18  -2.09148600896316E-01  -2.07895901276869E-01   0.00000000000000E+00   1.39364288963845E-13
     -9.77243516749649E-23  -3.97628944518511E-09  -3.97615008089624E-09  -2.94023945217353E-18
      4.58318673387364E-10
      0.00000000000000E+00  -3.91084075503370E-12   0.00000000000000E+00   2.14151229005168E-15   3.07094158234081E-23
      3.91084541774365E-09   3.91084755925597E-09  -8.84860011686309E-19  -2.08915224039802E-01  -2.08915224039867E-01
      0.00000000000000E+00   0.00000000000000E+00   6.58978502082535E-11   0.00000000000000E+00   6.58978502082535E-11
      3.82795480776129E-18  -2.08915224053568E-01  -2.07662336959281E-01   0.00000000000000E+00   1.35843288485203E-13
     -9.72946534578082E-23  -3.97688125275261E-09  -3.97674540946422E-09  -2.94309479607498E-18
      5.08318673387364E-10
      0.00000000000000E+00  -3.91313687346389E-12   0.00000000000000E+00   1.73308957587343E-15   3.17790370244475E-23
      3.91311318978869E-09   3.91311492287829E-09  -8.85263768916552E-19  -2.08688454057920E-01  -2.08688454057984E-01
      0.00000000000000E+00   0.00000000000000E+00   6.42664155800906E-11   0.00000000000000E+00   6.42664155800906E-11
      3.83116812854030E-18  -2.08688454087267E-01  -2.07435366458804E-01   0.00000000000000E+00   1.33420704627722E-13
     -9.77347842654680E-23  -3.97751475916296E-09  -3.97738133845843E-09  -2.94590435962374E-18
      5.58318673387364E-10
      0.00000000000000E+00  -3.91534114715687E-12   0.00000000000000E+00   2.04175446049452E-15   3.26388405914718E-23
      3.91531931102677E-09   3.91532135278127E-09  -8.85635500145360E-19  -2.08467849653712E-01  -2.08467849653775E-01
      0.00000000000000E+00   0.00000000000000E+00   6.27283894322088E-11   0.00000000000000E+00   6.27283894322088E-11
      3.83430454801190E-18  -2.08467849696564E-01  -2.07214551528598E-01   0.00000000000000E+00   1.30479949199910E-13
     -9.13719579186730E-23  -3.97818022216256E-09  -3.97804974221345E-09  -2.94866904786655E-18
      6.08318673387364E-10
      0.00000000000000E+00  -3.91745357611264E-12   0.00000000000000E+00   1.78836116218085E-15   3.42322082720794E-23
      3.91746754439689E-09   3.91746933275808E-09  -8.85978534352460E-19  -2.08253032665973E-01  -2.08253032666034E-01
      0.00000000000000E+00   0.00000000000000E+00   6.12738958988300E-11   0.00000000000000E+00   6.12738958988300E-11
      3.83736824280685E-18  -2.08253032711085E-01  -2.06999515923642E-01   0.00000000000000E+00   1.28255412681097E-13
     -9.83251962183683E-23  -3.97887148406948E-09  -3.97874322865690E-09  -2.95138970845439E-18
      6.58318673387364E-10
      0.00000000000000E+00  -3.91947416033120E-12   0.00000000000000E+00  -1.49946062644634E-16   3.47759051988011E-23
      3.91956128763069E-09   3.91956113768466E-09  -8.86295844375786E-19  -2.08043664256469E-01  -2.08043664256529E-01
      0.00000000000000E+00   0.00000000000000E+00   5.98949226868145E-11   0.00000000000000E+00   5.98949226868145E-11
      3.84036298894119E-18  -2.08043664288633E-01  -2.06789922256243E-01   0.00000000000000E+00   1.27834516042361E-13
     -9.68971576311452E-23  -3.97958389488743E-09  -3.97945606037148E-09  -2.95406714456540E-18
      7.08318673387364E-10
      0.00000000000000E+00  -3.92158658928698E-12   0.00000000000000E+00   1.79310124659025E-15   3.56688361149973E-23
      3.92160360259737E-09   3.92160539569865E-09  -8.86590081954009E-19  -2.07839439960602E-01  -2.07839439960661E-01
      0.00000000000000E+00   0.00000000000000E+00   5.85843491838163E-11   0.00000000000000E+00   5.85843491838163E-11
      3.84329220640038E-18  -2.07839439949296E-01  -2.06585467325494E-01   0.00000000000000E+00   1.23660016599315E-13
     -9.74240106250173E-23  -3.98031340489895E-09  -3.98018974488244E-09  -2.95670212444637E-18
      7.58318673387364E-10
      0.00000000000000E+00  -3.92360717350554E-12   0.00000000000000E+00   5.83132264036819E-16   3.65994694599908E-23
      3.92359724122859E-09   3.92359782436089E-09  -8.86863627210274E-19  -2.07640081457385E-01  -2.07640081457442E-01
      0.00000000000000E+00   0.00000000000000E+00   5.73362283151574E-11   0.00000000000000E+00   5.73362283151574E-11
      3.84615901781614E-18  -2.07640081361903E-01  -2.06385873805221E-01   0.00000000000000E+00   1.22714507572022E-13
     -9.75881606892600E-23  -3.98105676718351E-09  -3.98093405267604E-09  -2.95929539060586E-18
      8.08318673387364E-10
      0.00000000000000E+00  -3.92553591298690E-12   0.00000000000000E+00   1.76748646889328E-15   3.75174388269426E-23
      3.92554474803521E-09   3.92554651552172E-09  -8.87118600350973E-19  -2.07445337024969E-01  -2.07445337025025E-01
      0.00000000000000E+00   0.00000000000000E+00   5.61448877020272E-11   0.00000000000000E+00   5.61448877020272E-11
      3.84896626220124E-18  -2.07445336824167E-01  -2.06190890980938E-01   0.00000000000000E+00   1.19467474144680E-13
     -9.71882309366960E-23  -3.98181087069782E-09  -3.98169140322378E-09  -2.96184766185027E-18
      8.58318673387364E-10
      0.00000000000000E+00  -3.92746465246826E-12   0.00000000000000E+00   1.01848951485301E-15   3.84410201654747E-23
      3.92744840321285E-09   3.92744942170241E-09  -8.87356902262692E-19  -2.07254976044743E-01  -2.07254976044798E-01
      0.00000000000000E+00   0.00000000000000E+00   5.50056025014785E-11   0.00000000000000E+00   5.50056025014785E-11
      3.85171654232631E-18  -2.07254975750638E-01  -2.06000289035501E-01   0.00000000000000E+00   1.18209393942135E-13
     -9.74811267902108E-23  -3.98257323359775E-09  -3.98245502420390E-09  -2.96435964006362E-18
      9.08318673387364E-10
      0.00000000000000E+00  -3.92930154721241E-12   0.00000000000000E+00   1.72371346919422E-15   3.93499033956441E-23
      3.92931031988870E-09   3.92931204360221E-09  -8.87580225959470E-19  -2.07068789044929E-01  -2.07068789044983E-01
      0.00000000000000E+00   0.00000000000000E+00   5.39138687948821E-11   0.00000000000000E+00   5.39138687948821E-11
      3.85441223576606E-18  -2.07068788728228E-01  -2.05813859310768E-01   0.00000000000000E+00   1.15570506332029E-13
     -9.69088613649566E-23  -3.98334148290332E-09  -3.98322591239708E-09  -2.96683200980659E-18
      9.58318673387365E-10
      0.00000000000000E+00  -3.93113844195656E-12   0.00000000000000E+00   1.26527084563978E-15   4.02548777106477E-23
      3.93113239645641E-09   3.93113366172729E-09  -8.87790087475562E-19  -2.06886583630983E-01  -2.06886583631035E-01
      0.00000000000000E+00   0.00000000000000E+00   5.28658951406347E-11   0.00000000000000E+00   5.28658951406347E-11
      3.85705553052309E-18  -2.06886583439200E-01  -2.05631410084029E-01   0.00000000000000E+00   1.14138225003647E-13
     -9.69433566101151E-23  -3.98411369509282E-09  -3.98399955686791E-09  -2.96926544304753E-18
      1.00831867338736E-09
      0.00000000000000E+00  -3.93288349196350E-12   0.00000000000000E+00   1.67054244164161E-15   4.11484422239537E-23
      3.93291640840718E-09   3.93291807894967E-09  -8.87987836644101E-19  -2.06708184434618E-01  -2.06708184434670E-01
      0.00000000000000E+00   0.00000000000000E+00   5.18580759785587E-11   0.00000000000000E+00   5.18580759785587E-11
      3.85964843432202E-18  -2.06708184576627E-01  -2.05452766626207E-01   0.00000000000000E+00   1.11903110462271E-13
     -9.65262191964717E-23  -3.98488805803859E-09  -3.98477615492822E-09  -2.97166059767792E-18
      1.05831867338736E-09
      0.00000000000000E+00  -3.93462854197045E-12   0.00000000000000E+00   1.39362474220718E-15   4.20361181794213E-23
      3.93466395255837E-09   3.93466534618316E-09  -8.88174681029909E-19  -2.06533429935502E-01  -2.06533429935553E-01
      0.00000000000000E+00   0.00000000000000E+00   5.08873540253488E-11   0.00000000000000E+00   5.08873540253488E-11
      3.86219280202329E-18  -2.06533430629263E-01  -2.05277767885134E-01   0.00000000000000E+00   1.10385034427145E-13
     -9.65431183988302E-23  -3.98566308524284E-09  -3.98555270020850E-09  -2.97401812099338E-18
      1.10831867338736E-09
      0.00000000000000E+00  -3.93637359197739E-12   0.00000000000000E+00   1.61339380660134E-15   4.29153641925212E-23
      3.93637654384204E-09   3.93637815723589E-09  -8.88351695468405E-19  -2.06362172411725E-01  -2.06362172411775E-01
      0.00000000000000E+00   0.00000000000000E+00   4.99508219513352E-11   0.00000000000000E+00   4.99508219513352E-11
      3.86469034312085E-18  -2.06362173777453E-01  -2.05106266480821E-01   0.00000000000000E+00   1.08422702262765E-13
     -9.64536887113753E-23  -3.98643740188940E-09  -3.98632897918723E-09  -2.97633864765245E-18
      1.15831867338736E-09
      0.00000000000000E+00  -3.93802679724712E-12   0.00000000000000E+00   1.44884261352187E-15   4.37871411725469E-23
      3.93805553850032E-09   3.93805698734298E-09  -8.88519840909072E-19  -2.06194275334337E-01  -2.06194275334386E-01
      0.00000000000000E+00   0.00000000000000E+00   4.90460070368845E-11   0.00000000000000E+00   4.90460070368845E-11
      3.86714264347270E-18  -2.06194277253081E-01  -2.04938125996084E-01   0.00000000000000E+00   1.06874239913254E-13
     -9.64724046228518E-23  -3.98720986861972E-09  -3.98710299437990E-09  -2.97862280256362E-18
      1.20831867338736E-09
      0.00000000000000E+00  -3.93968000251686E-12   0.00000000000000E+00   1.55548901792312E-15   4.46503264736334E-23
      3.93970224233637E-09   3.93970379782543E-09  -8.88679972481610E-19  -2.06029613379545E-01  -2.06029613379593E-01
      0.00000000000000E+00   0.00000000000000E+00   4.81705550199668E-11   0.00000000000000E+00   4.81705550199668E-11
      3.86955117122370E-18  -2.06029615338808E-01  -2.04773221044688E-01   0.00000000000000E+00   1.05101043069656E-13
     -9.63836936222478E-23  -3.98797945388836E-09  -3.98787435284539E-09  -2.98087119874208E-18
      1.25831867338736E-09
      0.00000000000000E+00  -3.94133320778660E-12   0.00000000000000E+00   1.45968526528238E-15   4.55062951017631E-23
      3.94131781035632E-09   3.94131927004163E-09  -8.88832854556266E-19  -2.05868070203355E-01  -2.05868070203403E-01
      0.00000000000000E+00   0.00000000000000E+00   4.73224673626696E-11   0.00000000000000E+00   4.73224673626696E-11
      3.87191729459183E-18  -2.05868071227521E-01  -2.04611435084614E-01   0.00000000000000E+00   1.03556177970454E-13
     -9.63822817143920E-23  -3.98874529358219E-09  -3.98864173740431E-09  -2.98308444003556E-18
      1.30831867338736E-09
      0.00000000000000E+00  -3.94298641305633E-12   0.00000000000000E+00   1.49861840619496E-15   4.63543198353598E-23
      3.94290333913456E-09   3.94290483775301E-09  -8.88979167733223E-19  -2.05709538356894E-01  -2.05709538356941E-01
      0.00000000000000E+00   0.00000000000000E+00   4.64998490230411E-11   0.00000000000000E+00   4.64998490230411E-11
      3.87424228704298E-18  -2.05709537103396E-01  -2.04452660552254E-01   0.00000000000000E+00   1.01918391307940E-13
     -9.63181460763321E-23  -3.98950660516722E-09  -3.98940468677601E-09  -2.98526311930976E-18
      1.35831867338736E-09
      0.00000000000000E+00  -3.94445592885165E-12   0.00000000000000E+00   1.44412677202472E-15   4.71952448949086E-23
      3.94445978185558E-09   3.94446122598240E-09  -8.89119520665684E-19  -2.05553917496189E-01  -2.05553917496235E-01
      0.00000000000000E+00   0.00000000000000E+00   4.57010978476924E-11   0.00000000000000E+00   4.57010978476924E-11
      3.87652734193537E-18  -2.05553912630026E-01  -2.04296797315112E-01   0.00000000000000E+00   1.00396894951918E-13
     -9.63222963951766E-23  -3.99026272072498E-09  -3.99016232383012E-09  -2.98740782126968E-18
      1.40831867338736E-09
      0.00000000000000E+00  -3.94601728938418E-12   0.00000000000000E+00   1.44353102816320E-15   4.80283366965773E-23
      3.94598801395799E-09   3.94598945748907E-09  -8.89254456103586E-19  -2.05401114196795E-01  -2.05401114196840E-01
      0.00000000000000E+00   0.00000000000000E+00   4.49247040046012E-11   0.00000000000000E+00   4.49247040046012E-11
      3.87877357713559E-18  -2.05401105091007E-01  -2.04143752857211E-01   0.00000000000000E+00   9.88591215188165E-14
     -9.62597112574507E-23  -3.99101302061507E-09  -3.99091416149364E-09  -2.98951912103201E-18
      1.45831867338736E-09
      0.00000000000000E+00  -3.94748680517950E-12   0.00000000000000E+00   1.41322310466568E-15   4.88544673347981E-23
      3.94748877351264E-09   3.94749018673579E-09  -8.89384460028332E-19  -2.05251040589229E-01  -2.05251040589273E-01
      0.00000000000000E+00   0.00000000000000E+00   4.41693929147768E-11   0.00000000000000E+00   4.41693929147768E-11
      3.88098204678133E-18  -2.05251028259513E-01  -2.03993441120281E-01   0.00000000000000E+00   9.73710080557634E-14
     -9.62563483263291E-23  -3.99175695065857E-09  -3.99165957965061E-09  -2.99159758675300E-18
      1.50831867338736E-09
      0.00000000000000E+00  -3.94904816571203E-12   0.00000000000000E+00   1.39037905687559E-15   4.96730248206774E-23
      3.94896275079421E-09   3.94896414117332E-09  -8.89509966144170E-19  -2.05103614429131E-01  -2.05103614429174E-01
      0.00000000000000E+00   0.00000000000000E+00   4.34339406701983E-11   0.00000000000000E+00   4.34339406701983E-11
      3.88315374381484E-18  -2.05103602440866E-01  -2.03845782578250E-01   0.00000000000000E+00   9.59091812885780E-14
     -9.61932987137799E-23  -3.99249399102467E-09  -3.99239808184347E-09  -2.99364377767067E-18
      1.55831867338736E-09
      0.00000000000000E+00  -3.95042583677014E-12   0.00000000000000E+00   1.37378398811785E-15   5.04846947709724E-23
      3.95041059744856E-09   3.95041197123260E-09  -8.89631362020930E-19  -2.04958758493281E-01  -2.04958758493324E-01
      0.00000000000000E+00   0.00000000000000E+00   4.27172680788480E-11   0.00000000000000E+00   4.27172680788480E-11
      3.88528960721879E-18  -2.04958753343325E-01  -2.03700703073636E-01   0.00000000000000E+00   9.44588459512141E-14
     -9.61800224547981E-23  -3.99322369815732E-09  -3.99312923931146E-09  -2.99565824519786E-18
      1.60831867338736E-09
      0.00000000000000E+00  -3.95189535256546E-12   0.00000000000000E+00   1.33942664328320E-15   5.12891425489193E-23
      3.95183305966369E-09   3.95183439909038E-09  -8.89748991539399E-19  -2.04816401218537E-01  -2.04816401218579E-01
      0.00000000000000E+00   0.00000000000000E+00   4.20182645043970E-11   0.00000000000000E+00   4.20182645043970E-11
      3.88739052044401E-18  -2.04816411478945E-01  -2.03558133233697E-01   0.00000000000000E+00   9.30579760887424E-14
     -9.61428516988518E-23  -3.99394572157077E-09  -3.99385266359477E-09  -2.99764152890461E-18
      1.65831867338736E-09
      0.00000000000000E+00  -3.95327302362357E-12   0.00000000000000E+00   1.33057517392768E-15   5.20866493440993E-23
      3.95323101808871E-09   3.95323234866394E-09  -8.89863158750239E-19  -2.04676476685429E-01  -2.04676476685471E-01
      0.00000000000000E+00   0.00000000000000E+00   4.13358725710392E-11   0.00000000000000E+00   4.13358725710392E-11
      3.88945731407256E-18  -2.04676510444873E-01  -2.03418006710811E-01   0.00000000000000E+00   9.16499821175640E-14
     -9.61220833337139E-23  -3.99465987121698E-09  -3.99456822123496E-09  -2.99959415532232E-18
      1.70831867338737E-09
      0.00000000000000E+00  -3.95465069468169E-12   0.00000000000000E+00   1.29186136409174E-15   5.28771802467952E-23
      3.95460560499305E-09   3.95460689685447E-09  -8.89974129367910E-19  -2.04538925384919E-01  -2.04538925384960E-01
      0.00000000000000E+00   0.00000000000000E+00   4.06689544558691E-11   0.00000000000000E+00   4.06689544558691E-11
      3.89149076179535E-18  -2.04538985602776E-01  -2.03280258868687E-01   0.00000000000000E+00   9.03054020757191E-14
     -9.60981538711337E-23  -3.99536615671236E-09  -3.99527585131038E-09  -3.00151663242744E-18
      1.75831867338737E-09
      0.00000000000000E+00  -3.95593652100259E-12   0.00000000000000E+00   1.28756724264512E-15   5.36608293280704E-23
      3.95595815235534E-09   3.95595943992264E-09  -8.90082134737640E-19  -2.04403693768072E-01  -2.04403693768112E-01
      0.00000000000000E+00   0.00000000000000E+00   4.00164386806497E-11   0.00000000000000E+00   4.00164386806497E-11
      3.89349158372938E-18  -2.04403772342531E-01  -2.03144825014695E-01   0.00000000000000E+00   8.89493233238178E-14
     -9.60767531413486E-23  -3.99606482792650E-09  -3.99597587860327E-09  -3.00340944899174E-18
      1.80831867338737E-09
      0.00000000000000E+00  -3.95731419206070E-12   0.00000000000000E+00   1.24939668747146E-15   5.44376501424032E-23
      3.95729005380147E-09   3.95729130319822E-09  -8.90187376691419E-19  -2.04270733152681E-01  -2.04270733152720E-01
      0.00000000000000E+00   0.00000000000000E+00   3.93773348478525E-11   0.00000000000000E+00   3.93773348478525E-11
      3.89546045047178E-18  -2.04270805488041E-01  -2.03011639846017E-01   0.00000000000000E+00   8.76646029904180E-14
     -9.60553483006415E-23  -3.99675630264896E-09  -3.99666863804606E-09  -3.00527307378036E-18
      1.85831867338737E-09
      0.00000000000000E+00  -3.95860001838161E-12   0.00000000000000E+00   1.24712852374739E-15   5.52077081350705E-23
      3.95860238786217E-09   3.95860363499075E-09  -8.90290036695832E-19  -2.04139996501202E-01  -2.04139996501240E-01
      0.00000000000000E+00   0.00000000000000E+00   3.87510054943346E-11   0.00000000000000E+00   3.87510054943346E-11
      3.89739800074649E-18  -2.04140019892916E-01  -2.02880638077056E-01   0.00000000000000E+00   8.63693152473309E-14
     -9.60344081940651E-23  -3.99744100980024E-09  -3.99735464048509E-09  -3.00710796405066E-18
      1.90831867338736E-09
      0.00000000000000E+00  -3.95988584470252E-12   0.00000000000000E+00   1.21088469097570E-15   5.59710434464521E-23
      3.95989542747864E-09   3.95989663836338E-09  -8.90390287388795E-19  -2.04011433885822E-01  -2.04011433885860E-01
      0.00000000000000E+00   0.00000000000000E+00   3.81373029753189E-11   0.00000000000000E+00   3.81373029753189E-11
      3.89930486589526E-18  -2.04011353855147E-01  -2.02751757966885E-01   0.00000000000000E+00   8.51405590621249E-14
     -9.60137341276168E-23  -3.99811908189768E-09  -3.99803394133871E-09  -3.00891457850647E-18
      1.95831867338736E-09
      0.00000000000000E+00  -3.96117167102342E-12   0.00000000000000E+00   1.20667726572761E-15   5.67276684545634E-23
      3.96116806176719E-09   3.96116926844451E-09  -8.90488306657759E-19  -2.03884986602893E-01  -2.03884986602931E-01
      0.00000000000000E+00   0.00000000000000E+00   3.75368168573376E-11   0.00000000000000E+00   3.75368168573376E-11
      3.90118170673812E-18  -2.03884754797098E-01  -2.02624947102226E-01   0.00000000000000E+00   8.38908849393199E-14
     -9.59933432771796E-23  -3.99878997618665E-09  -3.99870608530181E-09  -3.01069340008037E-18
      2.00831867338737E-09
      0.00000000000000E+00  -3.96245749734433E-12   0.00000000000000E+00   1.16805425605225E-15   5.74775483401132E-23
      3.96241747069118E-09   3.96241863874549E-09  -8.90584288576639E-19  -2.03760582621103E-01  -2.03760582621139E-01
      0.00000000000000E+00   0.00000000000000E+00   3.69507861120130E-11   0.00000000000000E+00   3.69507861120130E-11
      3.90302924604373E-18  -2.03760187015332E-01  -2.02500170278582E-01   0.00000000000000E+00   8.26808115910361E-14
     -9.59732516977934E-23  -3.99945210566904E-09  -3.99936942485754E-09  -3.01244495746709E-18
      2.05831867338737E-09
      0.00000000000000E+00  -3.96365147892802E-12   0.00000000000000E+00   1.15739911411709E-15   5.82206068604171E-23
      3.96363932833449E-09   3.96364048573367E-09  -8.90678446022454E-19  -2.03638135824644E-01  -2.03638135824681E-01
      0.00000000000000E+00   0.00000000000000E+00   3.63808207348189E-11   0.00000000000000E+00   3.63808207348189E-11
      3.90484828708047E-18  -2.03637638407933E-01  -2.02377416249887E-01   0.00000000000000E+00   8.14177786346275E-14
     -9.59534233635581E-23  -4.00010272424701E-09  -4.00002130646847E-09  -3.01416984105801E-18
      2.10831867338737E-09
      0.00000000000000E+00  -3.96475361577451E-12   0.00000000000000E+00   1.10971713216227E-15   5.89567450273302E-23
      3.96482901620810E-09   3.96483012592529E-09  -8.90770995606939E-19  -2.03517553576105E-01  -2.03517553576141E-01
      0.00000000000000E+00   0.00000000000000E+00   3.58280231358554E-11   0.00000000000000E+00   3.58280231358554E-11
      3.90663968823726E-18  -2.03517122458285E-01  -2.02256699607654E-01   0.00000000000000E+00   8.01608287828409E-14
     -9.59339021681500E-23  -4.00073830988983E-09  -4.00065814906114E-09  -3.01586869263032E-18
      2.15831867338737E-09
      0.00000000000000E+00  -3.96603944209542E-12   0.00000000000000E+00   1.09516535872080E-15   5.96858948815293E-23
      3.96598394501559E-09   3.96598504018101E-09  -8.90862120487541E-19  -2.03398754767066E-01  -2.03398754767101E-01
      0.00000000000000E+00   0.00000000000000E+00   3.52918230858072E-11   0.00000000000000E+00   3.52918230858072E-11
      3.90840427939155E-18  -2.03398669440251E-01  -2.02138051620274E-01   0.00000000000000E+00   7.88285234318199E-14
     -9.59146638676364E-23  -4.00135569179017E-09  -4.00127686326683E-09  -3.01754215890401E-18
      2.20831867338737E-09
      0.00000000000000E+00  -3.96704973420470E-12   0.00000000000000E+00   1.04409972222859E-15   6.04081012757425E-23
      3.96710692449220E-09   3.96710796859198E-09  -8.90951909821002E-19  -2.03281699118436E-01  -2.03281699118471E-01
      0.00000000000000E+00   0.00000000000000E+00   3.47684938507166E-11   0.00000000000000E+00   3.47684938507166E-11
      3.91014270408409E-18  -2.03282302811565E-01  -2.02021496033001E-01   0.00000000000000E+00   7.75283698377294E-14
     -9.58957397627250E-23  -4.00195399081239E-09  -4.00187646244265E-09  -3.01919079426309E-18
      2.25831867338737E-09
      0.00000000000000E+00  -3.96824371578840E-12   0.00000000000000E+00   1.04286840604754E-15   6.11236131559781E-23
      3.96820955353301E-09   3.96821059640147E-09  -8.91040288853867E-19  -2.03166421184599E-01  -2.03166421184634E-01
      0.00000000000000E+00   0.00000000000000E+00   3.42502223098109E-11   0.00000000000000E+00   3.42502223098109E-11
      3.91185521519958E-18  -2.03167999193344E-01  -2.01907008271196E-01   0.00000000000000E+00   7.62289597872865E-14
     -9.58770961802439E-23  -4.00253704767103E-09  -4.00246081871133E-09  -3.02081492634571E-18
      2.30831867338737E-09
      0.00000000000000E+00  -3.96934585263489E-12   0.00000000000000E+00   1.02458282680038E-15   6.18329562949581E-23
      3.96931410734169E-09   3.96931513192458E-09  -8.91126966285609E-19  -2.03053056549119E-01  -2.03053056549153E-01
      0.00000000000000E+00   0.00000000000000E+00   3.37253066562366E-11   0.00000000000000E+00   3.37253066562366E-11
      3.91354148053239E-18  -2.03055639207879E-01  -2.01794465622906E-01   0.00000000000000E+00   7.51118494886348E-14
     -9.58587255010012E-23  -4.00311555043017E-09  -4.00304043858078E-09  -3.02241451424678E-18
      2.35831867338737E-09
      0.00000000000000E+00  -3.97044798948138E-12   0.00000000000000E+00   1.06120684712420E-15   6.25369143768519E-23
      3.97045146401992E-09   3.97045252522683E-09  -8.91211443123049E-19  -2.02941839097682E-01  -2.02941839097715E-01
      0.00000000000000E+00   0.00000000000000E+00   3.31807184425538E-11   0.00000000000000E+00   3.31807184425538E-11
      3.91520051645451E-18  -2.02944965549456E-01  -2.01683605155754E-01   0.00000000000000E+00   7.42147800362470E-14
     -9.58405473747389E-23  -4.00370745844932E-09  -4.00363324366938E-09  -3.02398907333147E-18
      2.40831867338737E-09
      0.00000000000000E+00  -3.97164197106508E-12   0.00000000000000E+00   1.12107203117652E-15   6.32363656858561E-23
      3.97165285438921E-09   3.97165397546131E-09  -8.91293131247009E-19  -2.02833046234844E-01  -2.02833046234877E-01
      0.00000000000000E+00   0.00000000000000E+00   3.26074228083401E-11   0.00000000000000E+00   3.26074228083401E-11
      3.91683088759493E-18  -2.02835577057125E-01  -2.01574018715919E-01   0.00000000000000E+00   7.36678221348166E-14
     -9.58225071568386E-23  -4.00433506609171E-09  -4.00426139826967E-09  -3.02553775634793E-18
      2.45831867338737E-09
      0.00000000000000E+00  -3.97292779738598E-12   0.00000000000000E+00   1.19749631030846E-15   6.39319283437107E-23
      3.97293424394851E-09   3.97293544144489E-09  -8.91371616596556E-19  -2.02726874815178E-01  -2.02726874815210E-01
      0.00000000000000E+00   0.00000000000000E+00   3.20083955388196E-11   0.00000000000000E+00   3.20083955388196E-11
      3.91843130737188E-18  -2.02726992065110E-01  -2.01465218674451E-01   0.00000000000000E+00   7.34567488832089E-14
     -9.58045027004718E-23  -4.00501729373248E-09  -4.00494383698369E-09  -3.02705969077532E-18
      2.50831867338737E-09
      0.00000000000000E+00  -3.97430546844410E-12   0.00000000000000E+00   1.26383891265026E-15   6.46234056694226E-23
      3.97427511542104E-09   3.97427637926002E-09  -8.91447056167911E-19  -2.02623252148059E-01  -2.02623252148090E-01
      0.00000000000000E+00   0.00000000000000E+00   3.14072608007232E-11   0.00000000000000E+00   3.14072608007232E-11
      3.92000167041191E-18  -2.02618808698924E-01  -2.01356802189439E-01   0.00000000000000E+00   7.34117650331878E-14
     -9.57865152972740E-23  -4.00575705182567E-09  -4.00568364006073E-09  -3.02855461424400E-18
      2.55831867338737E-09
      0.00000000000000E+00  -3.97559129476500E-12   0.00000000000000E+00   1.24121981190896E-15   6.53092144564700E-23
      3.97559760489070E-09   3.97559884611058E-09  -8.91520620953843E-19  -2.02521622984651E-01  -2.02521622984682E-01
      0.00000000000000E+00   0.00000000000000E+00   3.08539039527264E-11   0.00000000000000E+00   3.08539039527264E-11
      3.92154436560955E-18  -2.02510963770781E-01  -2.01248714905556E-01   0.00000000000000E+00   7.31669403033476E-14
     -9.57685731513272E-23  -4.00652591700354E-09  -4.00645275006334E-09  -3.03002374465570E-18
      2.60831867338737E-09
      0.00000000000000E+00  -3.97678527634870E-12   0.00000000000000E+00   1.09212109123841E-15   6.59859621382348E-23
      3.97675727189562E-09   3.97675836401677E-09  -8.91594796226290E-19  -2.02420801589543E-01  -2.02420801589573E-01
      0.00000000000000E+00   0.00000000000000E+00   3.04212711246524E-11   0.00000000000000E+00   3.04212711246524E-11
      3.92306542916578E-18  -2.02404040233127E-01  -2.01141562320769E-01   0.00000000000000E+00   7.20919201659736E-14
     -9.57508834091570E-23  -4.00725172706148E-09  -4.00717963514141E-09  -3.03147063293949E-18
      2.65831867338737E-09
      0.00000000000000E+00  -3.97752003424636E-12   0.00000000000000E+00   8.51732850916422E-16   6.66486762217699E-23
      3.97755998753513E-09   3.97756083926805E-09  -8.91673262736968E-19  -2.02319020869890E-01  -2.02319020869920E-01
      0.00000000000000E+00   0.00000000000000E+00   3.01877316865447E-11   0.00000000000000E+00   3.01877316865447E-11
      3.92457481575011E-18  -2.02299510471457E-01  -2.01036853306959E-01   0.00000000000000E+00   6.94037762522774E-14
     -9.57337831222110E-23  -4.00781797473074E-09  -4.00774857095459E-09  -3.03290155301314E-18
      2.70831867338737E-09
      0.00000000000000E+00  -3.97779556845798E-12   0.00000000000000E+00   3.26238815083585E-16   6.72920029992291E-23
      3.97781915120606E-09   3.97781947744494E-09  -8.91760059924606E-19  -2.02214322577668E-01  -2.02214322577698E-01
      0.00000000000000E+00   0.00000000000000E+00   3.02012466792017E-11   0.00000000000000E+00   3.02012466792017E-11
      3.92608487808407E-18  -2.02199729232097E-01  -2.00936986287903E-01   0.00000000000000E+00   6.47964421426398E-14
     -9.57177597127052E-23  -4.00808552056621E-09  -4.00802072412417E-09  -3.03432481815946E-18
      2.75831867338737E-09
      0.00000000000000E+00  -3.97742818950915E-12   0.00000000000000E+00  -3.86279658862259E-16   6.57421663662306E-23
      3.97745870765582E-09   3.97745832137623E-09  -8.91857833169217E-19  -2.02105386572619E-01  -2.02105386572649E-01
      0.00000000000000E+00   0.00000000000000E+00   3.04281085052535E-11   0.00000000000000E+00   3.04281085052535E-11
      3.92760628350933E-18  -2.02107468500653E-01  -2.00844767796783E-01   0.00000000000000E+00   5.83796769247721E-14
     -9.61548063219608E-23  -4.00794480955827E-09  -4.00788642988144E-09  -3.03574845034011E-18
      2.80831867338737E-09
      0.00000000000000E+00  -3.97669343161149E-12   0.00000000000000E+00  -6.59043065549379E-16   6.82234565562058E-23
      3.97664763396200E-09   3.97664697491900E-09  -8.91965289672855E-19  -2.01992745516193E-01  -2.01992745516223E-01
      0.00000000000000E+00   0.00000000000000E+00   3.06998265862558E-11   0.00000000000000E+00   3.06998265862558E-11
      3.92914127483864E-18  -2.02024835301442E-01  -2.00762304628908E-01   0.00000000000000E+00   5.09198973706229E-14
     -9.57246037640820E-23  -4.00739772140255E-09  -4.00734680150528E-09  -3.03717598516579E-18
      2.85831867338737E-09
      0.00000000000000E+00  -3.97595867371383E-12   0.00000000000000E+00  -7.58137763236974E-16   6.71519659829970E-23
      3.97592504708149E-09   3.97592428894379E-09  -8.92074476896048E-19  -2.01880097878294E-01  -2.01880097878325E-01
      0.00000000000000E+00   0.00000000000000E+00   3.06830029508195E-11   0.00000000000000E+00   3.06830029508195E-11
      3.93067542498618E-18  -2.01951597496684E-01  -2.00689299719542E-01   0.00000000000000E+00   4.56730394158026E-14
     -9.60277253441956E-23  -4.00665296493394E-09  -4.00660729189462E-09  -3.03860094809013E-18
      2.88331867338737E-09
      0.00000000000000E+00  -3.97586682897663E-12   0.00000000000000E+00   2.21500411873341E-13   6.86916876538636E-23
      3.97583688231640E-09   3.97605838272834E-09  -8.92128367171142E-19  -2.01824345603921E-01  -2.01824345603952E-01
      0.00000000000000E+00   0.00000000000000E+00   3.05177922780685E-11   0.00000000000000E+00   3.05177922780685E-11
      3.93143836979313E-18  -2.01916323495335E-01  -2.00654105387612E-01   0.00000000000000E+00  -1.77825653769549E-13
     -9.92903207378290E-23  -4.00639834935247E-09  -4.00657617500634E-09  -3.03931000262199E-18
      2.89175617338737E-09
      0.00000000000000E+00  -3.97559129476500E-12   0.00000000000000E+00  -1.37699261342841E-15   6.96480342819632E-23
      3.97561715181902E-09   3.97561577482647E-09  -8.92146137867404E-19  -2.01805720767604E-01  -2.01805720767635E-01
      0.00000000000000E+00   0.00000000000000E+00   3.04898030131453E-11   0.00000000000000E+00   3.04898030131453E-11
      3.93169562750606E-18  -2.01904988184895E-01  -2.00642848438618E-01   0.00000000000000E+00   4.38568722107385E-14
     -9.73316483103477E-23  -4.00614943471177E-09  -4.00610557783965E-09  -3.03954948963865E-18
      2.90314679838737E-09
      0.00000000000000E+00  -3.97559129476500E-12   0.00000000000000E+00  -3.62216678102847E-16   6.92568699191531E-23
      3.97556030165930E-09   3.97555993944269E-09  -8.92169696716117E-19  -2.01780835798096E-01  -2.01780835798127E-01
      0.00000000000000E+00   0.00000000000000E+00   3.03751151469648E-11   0.00000000000000E+00   3.03751151469648E-11
      3.93204161905203E-18  -2.01890041146016E-01  -2.00627955109695E-01   0.00000000000000E+00   4.28336671282601E-14
     -1.08965778263466E-22  -4.00597788825675E-09  -4.00593505458973E-09  -3.03987192233591E-18
      2.91852414213737E-09
      0.00000000000000E+00  -3.97559129476500E-12   0.00000000000000E+00   6.02151080847685E-17   6.93505550688715E-23
      3.97560598637939E-09   3.97560604659457E-09  -8.92200066383148E-19  -2.01747995657205E-01  -2.01747995657235E-01
      0.00000000000000E+00   0.00000000000000E+00   3.01361351947376E-11   0.00000000000000E+00   3.01361351947376E-11
      3.93250503276221E-18  -2.01870372148831E-01  -2.00608346878365E-01   0.00000000000000E+00   4.28336451279876E-14
     -4.40467121120014E-23  -4.00578501543442E-09  -4.00574218178934E-09  -3.04030496637907E-18
      2.93928355619987E-09
      0.00000000000000E+00  -3.97595867371383E-12   0.00000000000000E+00   7.54064967696141E-16   5.11384840812482E-23
      3.97595510301826E-09   3.97595585708328E-09  -8.92236813648343E-19  -2.01705809373664E-01  -2.01705809373693E-01
      0.00000000000000E+00   0.00000000000000E+00   2.96255021861983E-11   0.00000000000000E+00   2.96255021861983E-11
      3.93312004082891E-18  -2.01844252865074E-01  -2.00582278253914E-01   0.00000000000000E+00   4.43298200531862E-14
     -4.94320611228284E-23  -4.00562568908940E-09  -4.00558135926940E-09  -3.04088322718057E-18
      2.96730876518424E-09
      0.00000000000000E+00  -3.97724450003474E-12   0.00000000000000E+00   2.27221288022412E-15   7.44001443221529E-23
      3.97720996135259E-09   3.97721223356555E-09  -8.92273788382121E-19  -2.01655097592575E-01  -2.01655097592603E-01
      0.00000000000000E+00   0.00000000000000E+00   2.84877211522047E-11   0.00000000000000E+00   2.84877211522047E-11
      3.93391841516769E-18  -2.01807866876298E-01  -2.00545854928435E-01   0.00000000000000E+00   4.97753160597982E-14
     -1.07610277185466E-22  -4.00574973003369E-09  -4.00569995471774E-09  -3.04164462678557E-18
      3.00514279731315E-09
      0.00000000000000E+00  -3.98101013426025E-12   0.00000000000000E+00   5.02727138231661E-15   7.01227112982646E-23
      3.98103396857576E-09   3.98103899584721E-09  -8.92286567561658E-19  -2.01604770601346E-01  -2.01604770601372E-01
      0.00000000000000E+00   0.00000000000000E+00   2.59034938340346E-11   0.00000000000000E+00   2.59034938340346E-11
      3.93489844878566E-18  -2.01749488983193E-01  -2.00487085537431E-01   0.00000000000000E+00   6.60265763803308E-14
     -6.02569926498021E-23  -4.00700851625756E-09  -4.00694248968124E-09  -3.04261188122400E-18
      3.05514279731315E-09
      0.00000000000000E+00  -3.99092936587866E-12   0.00000000000000E+00   1.01176572057809E-14   6.93835981334374E-23
      3.99091246122713E-09   3.99092257888441E-09  -8.92210753019869E-19  -2.01583477944710E-01  -2.01583477944730E-01
      0.00000000000000E+00   0.00000000000000E+00   2.06086098652055E-11   0.00000000000000E+00   2.06086098652055E-11
      3.93592887927892E-18  -2.01634043029044E-01  -2.00370193953518E-01   0.00000000000000E+00   1.03988093857510E-13
     -6.45028050317570E-23  -4.01163517684344E-09  -4.01153118874964E-09  -3.04371812625905E-18
      3.10514279731315E-09
      0.00000000000000E+00  -4.00516530014583E-12   0.00000000000000E+00   1.45740578452630E-14   7.25570316154396E-23
      4.00518586539107E-09   4.00520043944899E-09  -8.92037687624033E-19  -2.01610053463136E-01  -2.01610053463150E-01
      0.00000000000000E+00   0.00000000000000E+00   1.43178952822710E-11   0.00000000000000E+00   1.43178952822710E-11
      3.93664477404303E-18  -2.01459312253771E-01  -2.00192946769532E-01   0.00000000000000E+00   1.53372803812354E-13
     -9.03640368908663E-23  -4.01967170753496E-09  -4.01951833473124E-09  -3.04460708641900E-18
      3.15514279731315E-09
      0.00000000000000E+00  -4.02077890547111E-12   0.00000000000000E+00   1.57308408031538E-14   7.36348494723163E-23
      4.02078343562695E-09   4.02079916646783E-09  -8.91808351145857E-19  -2.01665580088912E-01  -2.01665580088921E-01
      0.00000000000000E+00   0.00000000000000E+00   9.18932969352084E-12   0.00000000000000E+00   9.18932969352084E-12
      3.93710424052770E-18  -2.01217273970367E-01  -1.99947609687830E-01   0.00000000000000E+00   1.98070110026814E-13
     -9.26391135941520E-23  -4.03018656627126E-09  -4.02998849616132E-09  -3.04529588938185E-18
      3.20514279731315E-09
      0.00000000000000E+00  -4.03124920551276E-12   0.00000000000000E+00   1.06703777095876E-14   7.45888799765128E-23
      4.03127755655492E-09   4.03128822693271E-09  -8.91627195577766E-19  -2.01700812853746E-01  -2.01700812853755E-01
      0.00000000000000E+00   0.00000000000000E+00   8.64999177624373E-12   0.00000000000000E+00   8.64999177624373E-12
      3.93753674011652E-18  -2.00928381329559E-01  -1.99655582240935E-01   0.00000000000000E+00   2.10229405098229E-13
     -9.45841162989199E-23  -4.04014844811398E-09  -4.03993821870898E-09  -3.04590954453875E-18
      3.25514279731315E-09
      0.00000000000000E+00  -4.02729988181284E-12   0.00000000000000E+00   9.94406078293396E-17   7.49391467203522E-23
      4.02727725196192E-09   4.02727735140260E-09  -8.91663421397517E-19  -2.01635204542967E-01  -2.01635204542984E-01
      0.00000000000000E+00   0.00000000000000E+00   1.67515031117761E-11   0.00000000000000E+00   1.67515031117761E-11
      3.93837431527211E-18  -2.00655910047912E-01  -1.99381823274421E-01   0.00000000000000E+00   1.51664617497071E-13
     -8.24266891504369E-23  -4.04418051913179E-09  -4.04402885451437E-09  -3.04671089387459E-18
      3.30514279731315E-09
      0.00000000000000E+00  -3.99864432380409E-12   0.00000000000000E+00  -1.85841987638124E-14   7.51119021693211E-23
      3.99872163565795E-09   3.99870305145926E-09  -8.92121517808486E-19  -2.01370466023053E-01  -2.01370466023090E-01
      0.00000000000000E+00   0.00000000000000E+00   3.66529525115143E-11   0.00000000000000E+00   3.66529525115143E-11
      3.94020696289768E-18  -2.00510180739400E-01  -1.99238828080028E-01   0.00000000000000E+00  -5.91743081510398E-15
     -9.60472012104441E-23  -4.03535008653990E-09  -4.03535600397081E-09  -3.04808544508920E-18
      3.35514279731315E-09
      0.00000000000000E+00  -3.93958815777965E-12   0.00000000000000E+00   3.56895201404625E-14   7.42197287006396E-23
      3.93962335698667E-09   3.93965904650689E-09  -8.93167671751916E-19  -2.00825204717674E-01  -2.00825204717742E-01
      0.00000000000000E+00   0.00000000000000E+00   6.81459774692517E-11   0.00000000000000E+00   6.81459774692517E-11
      3.94361426177115E-18  -2.00631115372004E-01  -1.99368469387726E-01   0.00000000000000E+00  -3.47544700730529E-13
     -9.46296961655210E-23  -4.00745747927530E-09  -4.00780502397613E-09  -3.05044659001923E-18
      3.40514279731315E-09
      0.00000000000000E+00  -3.85472362059990E-12   0.00000000000000E+00  -5.89478423221914E-14   7.25638433069270E-23
      3.85475532272394E-09   3.85469637488169E-09  -8.94812849739405E-19  -1.99990752620230E-01  -1.99990752620335E-01
      0.00000000000000E+00   0.00000000000000E+00   1.04797645553688E-10   0.00000000000000E+00   1.04797645553688E-10
      3.94885414404883E-18  -2.01138728131220E-01  -1.99891281078577E-01   0.00000000000000E+00  -5.98288854395682E-13
     -9.63158783883768E-23  -3.95889573158087E-09  -3.95949402043537E-09  -3.05404129430942E-18
      3.45514279731315E-09
      0.00000000000000E+00  -3.76618529393184E-12   0.00000000000000E+00  -8.92345974800743E-14   7.05489742999144E-23
      3.76629700904052E-09   3.76620777444311E-09  -8.96759772998783E-19  -1.99004927193423E-01  -1.99004927193554E-01
      0.00000000000000E+00   0.00000000000000E+00   1.31582669974688E-10   0.00000000000000E+00   1.31582669974688E-10
      3.95543327754756E-18  -2.02056360122853E-01  -2.00828344882483E-01   0.00000000000000E+00  -8.44713339892520E-13
     -9.67664021262866E-23  -3.89694573107780E-09  -3.89779044441779E-09  -3.05867350454878E-18
      3.50514279731315E-09
      0.00000000000000E+00  -3.71658913583978E-12   0.00000000000000E+00  -4.57709393420489E-14   6.91343031520869E-23
      3.71658986679655E-09   3.71654409585728E-09  -8.98285944283013E-19  -1.98209797117432E-01  -1.98209797117558E-01
      0.00000000000000E+00   0.00000000000000E+00   1.25826258914854E-10   0.00000000000000E+00   1.25826258914854E-10
      3.96172459049331E-18  -2.03222558069061E-01  -2.02012005137574E-01   0.00000000000000E+00  -8.89952745985385E-13
     -9.70487860431239E-23  -3.84148040202605E-09  -3.84237035477213E-09  -3.06343864621029E-18
      3.55514279731315E-09
      0.00000000000000E+00  -3.76306257286679E-12   0.00000000000000E+00   4.58911446861529E-14   7.02777084784625E-23
      3.76302427802360E-09   3.76307016916835E-09  -8.98266007047886E-19  -1.98143026494048E-01  -1.98143026494112E-01
      0.00000000000000E+00   0.00000000000000E+00   6.32032422376790E-11   0.00000000000000E+00   6.32032422376790E-11
      3.96488475260519E-18  -2.04225686839085E-01  -2.03020204563296E-01   0.00000000000000E+00  -4.70402446612950E-13
     -9.70249439409630E-23  -3.82580300895930E-09  -3.82627341140601E-09  -3.06661874555730E-18
      3.60514279731315E-09
      0.00000000000000E+00  -3.96300856576757E-12   0.00000000000000E+00   2.00004392748064E-13   7.53942898503077E-23
      3.96278850072402E-09   3.96298850511684E-09  -8.95472750553376E-19  -1.99394789188208E-01  -1.99394789188138E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.03390035003329E-11   0.00000000000000E+00  -7.03390035003329E-11
      3.96136780243017E-18  -2.04391180679326E-01  -2.03164787267742E-01   0.00000000000000E+00   5.52957143410556E-13
     -9.69000932326508E-23  -3.89320245875985E-09  -3.89264950161653E-09  -3.06589505187679E-18
      3.65514279731315E-09
      0.00000000000000E+00  -4.34756248045549E-12   0.00000000000000E+00   3.85633633626088E-13   8.56239808861174E-23
      4.34716418104948E-09   4.34754981468319E-09  -8.89198312280918E-19  -2.02311417973712E-01  -2.02311417973447E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.64447348870500E-10   0.00000000000000E+00  -2.64447348870500E-10
      3.94814543498665E-18  -2.02847953673405E-01  -2.01561557897642E-01   0.00000000000000E+00   2.12846475733836E-12
     -9.64157897505517E-23  -4.08523093056991E-09  -4.08310246581267E-09  -3.05894712270573E-18
      3.70514279731315E-09
      0.00000000000000E+00  -4.88751769049854E-12   0.00000000000000E+00   5.41671139541883E-13   1.01326209178660E-22
      4.88695690015333E-09   4.88749857129297E-09  -8.79948585601855E-19  -2.06668632771631E-01  -2.06668632771154E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.76360398094797E-10   0.00000000000000E+00  -4.76360398094797E-10
      3.92432741508191E-18  -1.98739877042744E-01  -1.97350131714712E-01   0.00000000000000E+00   3.89950247932996E-12
     -9.54918446309936E-23  -4.41503767567741E-09  -4.41113817319817E-09  -3.04437882948005E-18
      3.75514279731315E-09
      0.00000000000000E+00  -5.45318942695969E-12   0.00000000000000E+00   5.67745328439977E-13   1.19348679650325E-22
      5.45266187227906E-09   5.45322961760762E-09  -8.69797115392195E-19  -2.11511095541391E-01  -2.11511095540760E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.31889443602996E-10   0.00000000000000E+00  -6.31889443602996E-10
      3.89273294290176E-18  -1.91695855909180E-01  -1.90176872174470E-01   0.00000000000000E+00   5.24869904208267E-12
     -9.42594522867986E-23  -4.82658887304661E-09  -4.82134017400463E-09  -3.02293582750956E-18
      3.80514279731315E-09
      0.00000000000000E+00  -5.78125882826498E-12   0.00000000000000E+00   3.30636885075628E-13   1.32019469254458E-22
      5.78092126790893E-09   5.78125190479414E-09  -8.62350981338253E-19  -2.15162142272702E-01  -2.15162142272080E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.22169923182602E-10   0.00000000000000E+00  -6.22169923182602E-10
      3.86162444674263E-18  -1.82640207131726E-01  -1.81014811825027E-01   0.00000000000000E+00   5.38570785057523E-12
     -9.28982596283759E-23  -5.16446768946204E-09  -5.15908198161156E-09  -2.99927346540437E-18
      3.85514279731315E-09
      0.00000000000000E+00  -5.48772304814972E-12   0.00000000000000E+00  -2.90022342873723E-13   1.28598699059061E-22
      5.48799233545638E-09   5.48770231311363E-09  -8.62767308186936E-19  -2.15176526850146E-01  -2.15176526849851E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.94272672518754E-10   0.00000000000000E+00  -2.94272672518754E-10
      3.84691081311669E-18  -1.74672489855187E-01  -1.73036267947414E-01   0.00000000000000E+00   3.38953583429582E-12
     -9.20343356600949E-23  -5.19681917642908E-09  -5.19342964059487E-09  -2.98414350492976E-18
      3.90514279731315E-09
      0.00000000000000E+00  -4.26683095645007E-12   0.00000000000000E+00  -1.21389558910967E-12   9.97429769093728E-23
      4.26800689405330E-09   4.26679299846429E-09  -8.77379464942589E-19  -2.08458956164960E-01  -2.08458956165434E-01
      0.00000000000000E+00   0.00000000000000E+00   4.74300295995106E-10   0.00000000000000E+00   4.74300295995106E-10
      3.87062582791645E-18  -1.72641517274971E-01  -1.71147803645782E-01   0.00000000000000E+00  -1.56882032682642E-12
     -9.24320636313345E-23  -4.73952447413247E-09  -4.74109329445939E-09  -2.99324636297386E-18
      3.95514279731315E-09
      0.00000000000000E+00  -2.30750717760190E-12   0.00000000000000E+00  -1.96709691306366E-12   4.94079585699256E-23
      2.30944325959725E-09   2.30747616268424E-09  -9.11562517454716E-19  -1.92226912208637E-01  -1.92226912210201E-01
      0.00000000000000E+00   0.00000000000000E+00   1.56358222578096E-09   0.00000000000000E+00   1.56358222578096E-09
      3.94880493920549E-18  -1.79793818975074E-01  -1.78574210383555E-01   0.00000000000000E+00  -9.71867580742666E-12
     -9.48347228912224E-23  -3.86133971265769E-09  -3.87105838846521E-09  -3.03724242175078E-18
      4.00514279731315E-09
      0.00000000000000E+00  -3.54979909307091E-13   0.00000000000000E+00  -1.97628613989850E-12  -2.89712523187192E-24
      3.56915556815410E-10   3.54939270675509E-10  -9.66901779215927E-19  -1.65286079155283E-01  -1.65286079157871E-01
      0.00000000000000E+00   0.00000000000000E+00   2.58850440115263E-09   0.00000000000000E+00   2.58850440115263E-09
      4.07823015926312E-18  -1.94087409269095E-01  -1.93160051182450E-01   0.00000000000000E+00  -2.03154695780667E-11
     -9.92574900470505E-23  -2.92312820224998E-09  -2.94344367182814E-09  -3.11132838004720E-18
      4.05514279731315E-09
      0.00000000000000E+00   8.98149685152404E-13   0.00000000000000E+00  -1.33915690626300E-12  -3.39140406147600E-23
     -8.96856963525651E-10  -8.98196120431948E-10  -1.03828458000713E-18  -1.29399443870242E-01  -1.29399443873429E-01
      0.00000000000000E+00   0.00000000000000E+00   3.18699595053951E-09   0.00000000000000E+00   3.18699595053951E-09
      4.23757995679010E-18  -2.09890283950419E-01  -2.09169165348077E-01   0.00000000000000E+00  -3.10530329766366E-11
     -1.04756646448778E-22  -2.25774679713082E-09  -2.28879983010756E-09  -3.19929537678297E-18
      4.10514279731314E-09
      0.00000000000000E+00   1.31585954997224E-12   0.00000000000000E+00  -5.43754036949460E-13  -4.37031251005056E-23
     -1.31532622470572E-09  -1.31586997874271E-09  -1.11190878864700E-18  -9.08633861585475E-02  -9.08633861617263E-02
      0.00000000000000E+00   0.00000000000000E+00   3.17886194704342E-09   0.00000000000000E+00   3.17886194704342E-09
      4.39652305414227E-18  -2.23733082831727E-01  -2.23146115538556E-01   0.00000000000000E+00  -3.83196438763170E-11
     -1.11076481873504E-22  -1.82467232442427E-09  -1.86299196830070E-09  -3.28461426549527E-18
      4.15514279731314E-09
      0.00000000000000E+00   1.10048364122059E-12   0.00000000000000E+00   8.95888458154154E-14  -4.59024199071085E-23
     -1.10053619774512E-09  -1.10044660889935E-09  -1.16914833337580E-18  -5.97660167961647E-02  -5.97660167986868E-02
      0.00000000000000E+00   0.00000000000000E+00   2.52209318968914E-09   0.00000000000000E+00   2.52209318968914E-09
      4.52262771362673E-18  -2.35724866565674E-01  -2.35276950621039E-01   0.00000000000000E+00  -3.71899080640906E-11
     -1.16316674081392E-22  -1.38445667272559E-09  -1.42164658078979E-09  -3.35347938025092E-18
      4.20514279731314E-09
      0.00000000000000E+00   5.75774657553985E-13   0.00000000000000E+00   4.48642405609673E-13  -4.64309843009841E-23
     -5.76252351091578E-10  -5.75803708686015E-10  -1.19872990592242E-18  -4.34314578475210E-02  -4.34314578490070E-02
      0.00000000000000E+00   0.00000000000000E+00   1.48596019088743E-09   0.00000000000000E+00   1.48596019088743E-09
      4.59692572317110E-18  -2.46683084946614E-01  -2.46396323749257E-01   0.00000000000000E+00  -2.61345875268645E-11
     -1.19820907070206E-22  -8.84021894674404E-10  -9.10156482201388E-10  -3.39819581724868E-18
      4.25514279731314E-09
      0.00000000000000E+00   7.54963739845870E-14   0.00000000000000E+00   4.87610453718500E-13  -4.64313414018634E-23
     -7.60196831072979E-11  -7.55320726536259E-11  -1.20326033236896E-18  -4.11770312441435E-02  -4.11770312446944E-02
      0.00000000000000E+00   0.00000000000000E+00   5.50884982381420E-10   0.00000000000000E+00   5.50884982381420E-10
      4.62446997229017E-18  -2.56796532641466E-01  -2.56646766261993E-01   0.00000000000000E+00  -1.19221320641535E-11
     -1.21389001456862E-22  -4.63430777663530E-10  -4.75352909727805E-10  -3.42120963992120E-18
      4.30514279731314E-09
      0.00000000000000E+00  -4.36538035947375E-13   0.00000000000000E+00   5.62483377299287E-13  -4.59414294329848E-23
      4.35934185033745E-10   4.36496668410998E-10  -1.18342272621051E-18  -5.25612011733028E-02  -5.25612011730133E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.89475911113018E-10   0.00000000000000E+00  -2.89475911113018E-10
      4.60999617673452E-18  -2.68091675381164E-01  -2.68045359631476E-01   0.00000000000000E+00   1.36140761465177E-12
     -1.21165800648212E-22  -1.48382164912542E-10  -1.47020757298011E-10  -3.42657345052401E-18
      4.35514279731314E-09
      0.00000000000000E+00  -1.03536572254045E-12   0.00000000000000E+00   6.97703241737090E-13  -4.41973530272606E-23
      1.03468194970171E-09   1.03537965294340E-09  -1.13819363958572E-18  -7.73695680820687E-02  -7.73695680810032E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.06547029032890E-09   0.00000000000000E+00  -1.06547029032890E-09
      4.55672266221808E-18  -2.83322592880395E-01  -2.83332083453911E-01   0.00000000000000E+00   1.11662596397420E-11
     -1.19720128205133E-22   1.89243777459074E-11   3.00906373855298E-11  -3.41852902263236E-18
      4.40514279731314E-09
      0.00000000000000E+00  -1.58496462999029E-12   0.00000000000000E+00   6.59132863341231E-13  -3.73934321395397E-23
      1.58426748699481E-09   1.58492661985811E-09  -1.07894912302462E-18  -1.08445737062237E-01  -1.08445737060730E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.50738414749460E-09   0.00000000000000E+00  -1.50738414749460E-09
      4.48135345484335E-18  -2.99518040584567E-01  -2.99493628362938E-01   0.00000000000000E+00   1.56855652168562E-11
     -1.17597854773250E-22  -9.32280375802640E-11  -7.75424723635254E-11  -3.40240433181873E-18
      4.45514279731314E-09
      0.00000000000000E+00  -2.34507167511978E-12   0.00000000000000E+00   8.51124904498431E-13  -1.42474429499211E-23
      2.34421121662455E-09   2.34506234152903E-09  -1.01608198519579E-18  -1.39960653128542E-01  -1.39960653126806E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.73577452168967E-09   0.00000000000000E+00  -1.73577452168967E-09
      4.39456472875886E-18  -3.11738495214868E-01  -3.11546566413583E-01   0.00000000000000E+00   1.85500319813109E-11
     -1.14997021837151E-22  -6.27837851820548E-10  -6.09287819839352E-10  -3.37848274356308E-18
      4.50514279731314E-09
      0.00000000000000E+00  -3.83433408893983E-12   0.00000000000000E+00   1.54873712310855E-12   4.22957132832412E-23
      3.83271514112410E-09   3.83426387824725E-09  -9.54176271101899E-19  -1.69759028756805E-01  -1.69759028754814E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.99086280741524E-09   0.00000000000000E+00  -1.99086280741524E-09
      4.29502158838810E-18  -3.14889945757157E-01  -3.14309223539317E-01   0.00000000000000E+00   2.29149859139125E-11
     -1.11569863317074E-22  -1.86631605674583E-09  -1.84340107083203E-09  -3.34084531728620E-18
      4.55514279731314E-09
      0.00000000000000E+00  -6.41103819129699E-12   0.00000000000000E+00   2.60229545707928E-12   1.37120169452754E-22
      6.40841463328771E-09   6.41101692874493E-09  -8.96899906093938E-19  -1.96556863946793E-01  -1.96556863944414E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.37881722697550E-09   0.00000000000000E+00  -2.37881722697550E-09
      4.17608072703933E-18  -3.02598444674724E-01  -3.01328151072883E-01   0.00000000000000E+00   2.90413099223306E-11
     -1.07068904880449E-22  -4.06124101169163E-09  -4.03219970176940E-09  -3.27918082094539E-18
      4.60514279731314E-09
      0.00000000000000E+00  -9.43475062964319E-12   0.00000000000000E+00   3.02809981097181E-12   2.50326799087834E-22
      9.43176367288535E-09   9.43479177269658E-09  -8.50980699215766E-19  -2.17951553243289E-01  -2.17951553240548E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.74105085531136E-09   0.00000000000000E+00  -2.74105085531136E-09
      4.03902818427376E-18  -2.70980454126368E-01  -2.68871626250221E-01   0.00000000000000E+00   3.25997560745076E-11
     -1.01390287880413E-22  -6.72634067345964E-09  -6.69374091738523E-09  -3.18804748505799E-18
      4.65514279731314E-09
      0.00000000000000E+00  -1.17577795678332E-11   0.00000000000000E+00   2.31824515451846E-12   3.40168157354030E-22
      1.17554929357324E-08   1.17578111808872E-08  -8.18534668282645E-19  -2.33538583595427E-01  -2.33538583592476E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.95118976086180E-09   0.00000000000000E+00  -2.95118976086180E-09
      3.89146869623067E-18  -2.24650658194396E-01  -2.21876120700763E-01   0.00000000000000E+00   3.02935286851387E-11
     -9.50813450705024E-23  -8.83691494871046E-09  -8.80662142002542E-09  -3.07293402794802E-18
      4.70514279731314E-09
      0.00000000000000E+00  -1.29400968699057E-11   0.00000000000000E+00   1.18334409836445E-12   3.88230706709271E-22
      1.29389221390268E-08   1.29401054831255E-08  -7.96467170676672E-19  -2.44889178826833E-01  -2.44889178823788E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.04414562577393E-09   0.00000000000000E+00  -3.04414562577393E-09
      3.73926141494197E-18  -1.71436831895958E-01  -1.68319048388558E-01   0.00000000000000E+00   2.46680587688610E-11
     -8.86601558230133E-23  -9.92062791612037E-09  -9.89595985735159E-09  -2.94279424426530E-18
      4.75514279731314E-09
      0.00000000000000E+00  -1.31534521944387E-11   0.00000000000000E+00   2.24467087923697E-13   3.97290452858148E-22
      1.31532276532336E-08   1.31534521203219E-08  -7.81081051809700E-19  -2.53630501343238E-01  -2.53630501340165E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.07279934976943E-09   0.00000000000000E+00  -3.07279934976943E-09
      3.58562144745350E-18  -1.18073835068113E-01  -1.14897828241192E-01   0.00000000000000E+00   1.84890181622702E-11
     -7.98588626605082E-23  -1.00991417887147E-08  -1.00806527705525E-08  -2.80454039564380E-18
      4.80514279731314E-09
      0.00000000000000E+00  -1.27439165112304E-11   0.00000000000000E+00  -3.95425045988405E-13   3.81072406798243E-22
      1.27443532393144E-08   1.27439578142687E-08  -7.68282566220500E-19  -2.61417703955950E-01  -2.61417703952903E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.04657751447932E-09   0.00000000000000E+00  -3.04657751447932E-09
      3.43329257172953E-18  -7.17802363188349E-02  -6.87249581909904E-02   0.00000000000000E+00   1.24976796151921E-11
     -2.65767114871842E-23  -9.70987797940460E-09  -9.69738029978943E-09  -2.66501000550903E-18
      4.85514279731314E-09
      0.00000000000000E+00  -1.17345428493197E-11   0.00000000000000E+00  -9.68334406920900E-13   3.65422523920286E-22
      1.17355346935336E-08   1.17345663591270E-08  -7.50934003028251E-19  -2.70935688006716E-01  -2.70935688003793E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.92277289311979E-09   0.00000000000000E+00  -2.92277289311979E-09
      3.28715392707354E-18  -4.01682394296976E-02  -3.73919673888769E-02   0.00000000000000E+00   7.69490922014581E-12
      1.25497382600247E-22  -8.81948837522750E-09  -8.81179346600723E-09  -2.53621992404529E-18
      4.90514279731314E-09
      0.00000000000000E+00  -1.05260497971430E-11   0.00000000000000E+00  -1.17543258130177E-12   3.69373784058565E-22
      1.05272229839297E-08   1.05260475513487E-08  -7.25167541771447E-19  -2.83564417298375E-01  -2.83564417295638E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.73692797183046E-09   0.00000000000000E+00  -2.73692797183046E-09
      3.15030752848202E-18  -2.39059201367197E-02  -2.14518434597498E-02   0.00000000000000E+00   4.65552218389517E-12
      2.91317538936590E-22  -7.79377510170248E-09  -7.78911957951829E-09  -2.42513998671057E-18
      4.93014279731314E-09
      0.00000000000000E+00  -9.94880562379371E-12   0.00000000000000E+00  -1.12038402669258E-12   3.74823704599492E-22
      9.94996180253330E-09   9.94884141850699E-09  -7.10309481168620E-19  -2.90580294168977E-01  -2.90580294166322E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.65431846829910E-09   0.00000000000000E+00  -2.65431846829910E-09
      3.08394956677454E-18  -1.90079772755915E-02  -1.67097280562492E-02   0.00000000000000E+00   3.54447859122490E-12
      3.64312088195198E-22  -7.29806742879941E-09  -7.29452295020782E-09  -2.37364008560592E-18
      4.96389279731314E-09
      0.00000000000000E+00  -9.53522877214822E-12   0.00000000000000E+00  -5.86203946880092E-13   3.81507535119516E-22
      9.53581388896900E-09   9.53522768502251E-09  -6.88963900319659E-19  -3.00562653355996E-01  -3.00562653353384E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.61184847913417E-09   0.00000000000000E+00  -2.61184847913417E-09
      2.99579968060376E-18  -1.50488324774254E-02  -1.28675154398311E-02   0.00000000000000E+00   2.58827376786468E-12
      4.37227574133599E-22  -6.92596747965662E-09  -6.92337920588832E-09  -2.30683578028411E-18
      5.00945529731314E-09
      0.00000000000000E+00  -9.34547754507747E-12   0.00000000000000E+00  -1.86749308348354E-13   3.84558824416957E-22
      9.34559881059397E-09   9.34541206128600E-09  -6.58365723423137E-19  -3.14873072160881E-01  -3.14873072158189E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.69273782240587E-09   0.00000000000000E+00  -2.69273782240587E-09
      2.87311181357040E-18  -1.17832426197250E-02  -9.68721313761167E-03   0.00000000000000E+00   2.13158774558351E-12
      5.01363077469853E-22  -6.65480582662627E-09  -6.65267423888019E-09  -2.21474609014726E-18
      5.03445529731314E-09
      0.00000000000000E+00  -9.33280297134283E-12   0.00000000000000E+00  -6.01641041576738E-15   3.83687515696548E-22
      9.33282692067860E-09   9.33282090426857E-09  -6.40679369636785E-19  -3.23111953288758E-01  -3.23111953285956E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.80269430250821E-09   0.00000000000000E+00  -2.80269430250821E-09
      2.80304445600769E-18  -1.04693203139639E-02  -8.41190031330196E-03   0.00000000000000E+00   2.02147665555998E-12
      5.25356175956792E-22  -6.53214807841650E-09  -6.53012660176041E-09  -2.16236508637091E-18
      5.06820529731314E-09
      0.00000000000000E+00  -9.29551400803657E-12   0.00000000000000E+00  -3.61752890923244E-14   3.72716966114889E-22
      9.29555261839213E-09   9.29551644310341E-09  -6.16969142237067E-19  -3.34242308974736E-01  -3.34242308971893E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.84308562518652E-09   0.00000000000000E+00  -2.84308562518652E-09
      2.70709031615764E-18  -9.13395324839929E-03  -7.10101108420444E-03   0.00000000000000E+00   1.80925234996497E-12
      5.35836473499317E-22  -6.45424007026742E-09  -6.45243081791692E-09  -2.09012117392058E-18
      5.11376779731314E-09
      0.00000000000000E+00  -9.08776121247315E-12   0.00000000000000E+00  -2.09084686133219E-13   3.39694820119266E-22
      9.08793109784825E-09   9.08772201316245E-09  -5.88183060148495E-19  -3.47995464429547E-01  -3.47995464426849E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.69848715689077E-09   0.00000000000000E+00  -2.69848715689077E-09
      2.58414049507181E-18  -7.85786460742104E-03  -5.84483153160470E-03   0.00000000000000E+00   1.52494953194360E-12
      5.09428937615878E-22  -6.39075980580412E-09  -6.38923485627167E-09  -1.99595743492332E-18
      5.16376779731314E-09
      0.00000000000000E+00  -8.58417651836428E-12   0.00000000000000E+00  -4.85147993478711E-13   2.85329584547681E-22
      8.58462678894029E-09   8.58414164094709E-09  -5.64376194647690E-19  -3.59761345723561E-01  -3.59761345721326E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.23559072582167E-09   0.00000000000000E+00  -2.23559072582167E-09
      2.47236095878073E-18  -6.94580869397587E-03  -4.94559206615977E-03   0.00000000000000E+00   1.08527259915898E-12
      4.39552363718819E-22  -6.34963618772501E-09  -6.34855091512542E-09  -1.90798476413304E-18
      5.21376779731314E-09
      0.00000000000000E+00  -7.50784804302927E-12   0.00000000000000E+00  -1.05758317571528E-12   2.18152700461512E-22
      7.50891452699439E-09   7.50785694381889E-09  -5.57542750504204E-19  -3.64233687964224E-01  -3.64233687963080E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14318673333952E-09   0.00000000000000E+00  -1.14318673333952E-09
      2.41520162211375E-18  -6.47307623703392E-03  -4.46777968518640E-03   0.00000000000000E+00   2.54097418358913E-13
      3.39083203515278E-22  -6.36492430789808E-09  -6.36467021047939E-09  -1.85765887160955E-18
      5.26376779731314E-09
      0.00000000000000E+00  -5.41452279259532E-12   0.00000000000000E+00  -2.07597938906386E-12   1.38352021088208E-22
      5.41664394758419E-09   5.41456796819526E-09  -5.85621634267904E-19  -3.53935687914565E-01  -3.53935687915558E-01
      0.00000000000000E+00   0.00000000000000E+00   9.93425890759148E-10   0.00000000000000E+00   9.93425890759148E-10
      2.46487291665171E-18  -6.59215338767257E-03  -4.57320653094652E-03   0.00000000000000E+00  -1.39341761221798E-12
      2.09844248799862E-22  -6.40660044134243E-09  -6.40799385895444E-09  -1.87925128238380E-18
      5.31376779731314E-09
      0.00000000000000E+00  -2.69325507387351E-12   0.00000000000000E+00  -2.72338448718426E-12   5.06792376845053E-23
      2.69594932893916E-09   2.69322594445203E-09  -6.62783650425870E-19  -3.22731109960247E-01  -3.22731109963893E-01
      0.00000000000000E+00   0.00000000000000E+00   3.64583426652462E-09   0.00000000000000E+00   3.64583426652462E-09
      2.64716462997794E-18  -8.27472146841020E-03  -6.27749436038485E-03   0.00000000000000E+00  -4.28099175981465E-12
      5.85898891417097E-23  -6.33477921921687E-09  -6.33906021097663E-09  -1.98438097955207E-18
      5.36376779731314E-09
      0.00000000000000E+00  -4.58948151826011E-13   0.00000000000000E+00  -2.28305453876500E-12  -1.62992448705563E-23
      4.61141288649295E-10   4.58858234110514E-10  -7.77830306444394E-19  -2.73395550302984E-01  -2.73395550308438E-01
      0.00000000000000E+00   0.00000000000000E+00   5.45418090063601E-09   0.00000000000000E+00   5.45418090063601E-09
      2.91987367500974E-18  -1.60509828835155E-02  -1.41879832789925E-02   0.00000000000000E+00  -9.13774122940723E-12
     -5.80832012149944E-23  -5.90390139351705E-09  -5.91303913474652E-09  -2.14204336856535E-18
      5.41376779731314E-09
      0.00000000000000E+00   1.28876535249602E-12   0.00000000000000E+00  -1.83956346586764E-12  -3.93596952659552E-23
     -1.28696951513203E-09  -1.28880907859793E-09  -9.00269683044084E-19  -2.16399682930380E-01  -2.16399682936487E-01
      0.00000000000000E+00   0.00000000000000E+00   6.10629074156693E-09   0.00000000000000E+00   6.10629074156693E-09
      3.22518821208809E-18  -3.85756443919188E-02  -3.70578190464873E-02   0.00000000000000E+00  -1.77002142984749E-11
     -8.35501262709704E-23  -4.79978144867045E-09  -4.81748166296900E-09  -2.32491852904400E-18
      5.46376779731314E-09
      0.00000000000000E+00   2.05410754764634E-12   0.00000000000000E+00  -9.11640121984155E-13  -4.38498161862818E-23
     -2.05316860355414E-09  -2.05408024367616E-09  -1.01545976294115E-18  -1.58505516591380E-01  -1.58505516597289E-01
      0.00000000000000E+00   0.00000000000000E+00   5.90921966942971E-09   0.00000000000000E+00   5.90921966942971E-09
      3.52064919555957E-18  -7.07120657490708E-02  -6.94974385362098E-02   0.00000000000000E+00  -3.05845022767781E-11
     -9.19867447768178E-23  -3.82455492347670E-09  -3.85513942575357E-09  -2.50518943261842E-18
      5.51376779731314E-09
      0.00000000000000E+00   2.01488984485872E-12   0.00000000000000E+00  -1.49350018641563E-13  -4.53616297923593E-23
     -2.01471585171916E-09  -2.01486520173785E-09  -1.11668832983659E-18  -1.04140005732826E-01  -1.04140005738056E-01
      0.00000000000000E+00   0.00000000000000E+00   5.22944624962906E-09   0.00000000000000E+00   5.22944624962906E-09
      3.78212150804102E-18  -1.05530088218021E-01  -1.04517277160904E-01   0.00000000000000E+00  -4.50846942514360E-11
     -1.01725831781532E-22  -3.16949635363963E-09  -3.21458104789116E-09  -2.66543317820443E-18
      5.56376779731314E-09
      0.00000000000000E+00   1.60627260902244E-12   0.00000000000000E+00   2.16062620056254E-13  -4.65956531031977E-23
     -1.60649027924038E-09  -1.60627421662037E-09  -1.19487988083109E-18  -5.96791390483375E-02  -5.96791390525769E-02
      0.00000000000000E+00   0.00000000000000E+00   4.23939922821651E-09   0.00000000000000E+00   4.23939922821651E-09
      3.99409146945185E-18  -1.40794680356589E-01  -1.39965065515654E-01   0.00000000000000E+00  -5.58026142473224E-11
     -1.10918260137206E-22  -2.57732239734874E-09  -2.63312501159617E-09  -2.79921158862076E-18
      5.61376779731314E-09
      0.00000000000000E+00   9.62808380146503E-13   0.00000000000000E+00   5.08418934043684E-13  -4.73290237950865E-23
     -9.63348342830542E-10  -9.62839923896546E-10  -1.24043151692124E-18  -3.27013887464929E-02  -3.27013887494187E-02
      0.00000000000000E+00   0.00000000000000E+00   2.92577137814699E-09   0.00000000000000E+00   2.92577137814699E-09
      4.14038003835920E-18  -1.75397630955130E-01  -1.74779171770226E-01   0.00000000000000E+00  -5.54630521242120E-11
     -1.18670735865356E-22  -1.90746840212606E-09  -1.96293145425039E-09  -2.89994852143796E-18
      5.66376779731314E-09
      0.00000000000000E+00   4.69418451867669E-13   0.00000000000000E+00   4.29693137179153E-13  -4.76311081506760E-23
     -4.69817348950834E-10  -4.69387655813702E-10  -1.26127231094133E-18  -2.01254383900290E-02  -2.01254383918513E-02
      0.00000000000000E+00   0.00000000000000E+00   1.82234897070778E-09   0.00000000000000E+00   1.82234897070778E-09
      4.23149748689459E-18  -2.05310259754818E-01  -2.04883983221142E-01   0.00000000000000E+00  -4.55491786590174E-11
     -1.24387339377078E-22  -1.30741213623498E-09  -1.35296131489412E-09  -2.97022517595326E-18
      5.71376779731314E-09
      0.00000000000000E+00   2.48899237832398E-13   0.00000000000000E+00   1.94823396726373E-13  -4.77501471559749E-23
     -2.49071102733690E-10  -2.48876279337011E-10  -1.27112075337595E-18  -1.42720803932966E-02  -1.42720803944588E-02
      0.00000000000000E+00   0.00000000000000E+00   1.16217127822035E-09   0.00000000000000E+00   1.16217127822035E-09
      4.28960605080561E-18  -2.27336414116111E-01  -2.27048663798006E-01   0.00000000000000E+00  -3.29633285165555E-11
     -1.28241393129570E-22  -8.80331670366603E-10  -9.13294998883287E-10  -3.01848529742965E-18
      5.76376779731314E-09
      0.00000000000000E+00   1.64218390127058E-13   0.00000000000000E+00   7.42291321113678E-14  -4.78018972648980E-23
     -1.64324793382323E-10  -1.64250564250259E-10  -1.27677909630926E-18  -1.10939767383056E-02  -1.10939767391002E-02
      0.00000000000000E+00   0.00000000000000E+00   7.94562924013381E-10   0.00000000000000E+00   7.94562924013381E-10
      4.32933419700628E-18  -2.42314314928232E-01  -2.42115725180356E-01   0.00000000000000E+00  -2.22274004004566E-11
     -1.30702492213479E-22  -6.08084959362558E-10  -6.30312359763146E-10  -3.05255510069701E-18
      5.81376779731313E-09
      0.00000000000000E+00   1.27113116295217E-13   0.00000000000000E+00   3.29635924411979E-14  -4.78244648973232E-23
     -1.27123967775129E-10  -1.27091004182735E-10  -1.28062063586265E-18  -9.08858807882893E-03  -9.08858807943484E-03
      0.00000000000000E+00   0.00000000000000E+00   6.05913854782434E-10   0.00000000000000E+00   6.05913854782434E-10
      4.35962988974540E-18  -2.53190847688385E-01  -2.53039988656641E-01   0.00000000000000E+00  -1.57687021431534E-11
     -1.32438903742660E-22  -4.63054148456434E-10  -4.78822850599720E-10  -3.07900925388274E-18
      5.86376779731313E-09
      0.00000000000000E+00   1.06172516211901E-13   0.00000000000000E+00   1.98276875500305E-14  -4.78309003720281E-23
     -1.06212486921523E-10  -1.06192659234021E-10  -1.28345823893127E-18  -7.71803957390202E-03  -7.71803957440489E-03
      0.00000000000000E+00   0.00000000000000E+00   5.02867073171242E-10   0.00000000000000E+00   5.02867073171242E-10
      4.38477324340396E-18  -2.61825006664872E-01  -2.61700030735640E-01   0.00000000000000E+00  -1.20653957034973E-11
     -1.33714218349070E-22  -3.84609018233585E-10  -3.96674413937216E-10  -3.10131500447268E-18
      5.91376779731313E-09
      0.00000000000000E+00   9.10181345726590E-14   0.00000000000000E+00   1.61468749962374E-14  -4.78259468725097E-23
     -9.10589040799720E-11  -9.10427572050235E-11  -1.28558046711553E-18  -6.77751765217248E-03  -6.77751765261871E-03
      0.00000000000000E+00   0.00000000000000E+00   4.46234343320048E-10   0.00000000000000E+00   4.46234343320048E-10
      4.40708496056996E-18  -2.69446057939181E-01  -2.69334152333959E-01   0.00000000000000E+00  -1.02312833913495E-11
     -1.34769209035812E-22  -3.44960302723526E-10  -3.55191586115010E-10  -3.12150449345443E-18
      5.96376779731313E-09
      0.00000000000000E+00   7.74251134659451E-14   0.00000000000000E+00   1.63838885731983E-14  -4.78108604893135E-23
     -7.74543224624448E-11  -7.74379385739194E-11  -1.28706929280985E-18  -6.16927533676769E-03  -6.16927533721183E-03
      0.00000000000000E+00   0.00000000000000E+00   4.44140314622020E-10   0.00000000000000E+00   4.44140314622020E-10
      4.42929197630106E-18  -2.77886011908865E-01  -2.77770479493830E-01   0.00000000000000E+00  -1.13404669897987E-11
     -1.35925293673871E-22  -3.55361909058192E-10  -3.66702376048127E-10  -3.14222268349121E-18
      6.01376779731313E-09
      0.00000000000000E+00   6.12604397174203E-14   0.00000000000000E+00   2.11145591029457E-14  -4.77833140052946E-23
     -6.12582415913346E-11  -6.12371270322795E-11  -1.28780614984345E-18  -5.89184365018308E-03  -5.89184365069500E-03
      0.00000000000000E+00   0.00000000000000E+00   5.11919293731263E-10   0.00000000000000E+00   5.11919293731263E-10
      4.45488794098762E-18  -2.89825493776999E-01  -2.89683501110083E-01   0.00000000000000E+00  -1.69515450259697E-11
     -1.37602318219805E-22  -4.33730621672878E-10  -4.50682166698986E-10  -3.16708179114418E-18
      6.06376779731313E-09
      0.00000000000000E+00   4.05953738457268E-14   0.00000000000000E+00   2.83733055125944E-14  -4.77396212599237E-23
     -4.06194494165989E-11  -4.05910761111340E-11  -1.28757996464025E-18  -6.10631987126724E-03  -6.10631987180499E-03
      0.00000000000000E+00   0.00000000000000E+00   5.37747999463944E-10   0.00000000000000E+00   5.37747999463944E-10
      4.48177534096082E-18  -3.04029016445858E-01  -3.03872380635484E-01   0.00000000000000E+00  -2.06111119474551E-11
     -1.39587732431419E-22  -4.76545811405184E-10  -4.97156923352779E-10  -3.19419537632057E-18
      6.11376779731313E-09
      0.00000000000000E+00  -1.97466184996183E-14   0.00000000000000E+00   7.67026135204814E-14  -4.76435897351061E-23
      1.96367144324929E-11   1.97134170459657E-11  -1.28443324787964E-18  -8.03405145028612E-03  -8.03405145072350E-03
      0.00000000000000E+00   0.00000000000000E+00   4.37386080384330E-10   0.00000000000000E+00   4.37386080384330E-10
      4.50364464498004E-18  -3.18417237238993E-01  -3.18273222894367E-01   0.00000000000000E+00  -1.87283188740298E-11
     -1.41356112791982E-22  -4.38371178556170E-10  -4.57099497430341E-10  -3.21921139710040E-18
      6.16376779731313E-09
      0.00000000000000E+00  -2.65155756318130E-13   0.00000000000000E+00   2.96617391831719E-13  -4.73291091459526E-23
      2.64889068546422E-10   2.65185685938206E-10  -1.26924858967584E-18  -1.70294824042128E-02  -1.70294824042306E-02
      0.00000000000000E+00   0.00000000000000E+00   1.77958762601745E-11   0.00000000000000E+00   1.77958762601745E-11
      4.50453443879305E-18  -3.32941109097675E-01  -3.32851956434746E-01   0.00000000000000E+00  -7.00551410814415E-12
     -1.42026814015564E-22  -2.75976048090071E-10  -2.82981562198357E-10  -3.23528584911721E-18
      6.21376779731313E-09
      0.00000000000000E+00  -8.23388069065477E-13   0.00000000000000E+00   6.77755590447091E-13  -4.65488155461546E-23
      8.22734608244763E-10   8.23412363835164E-10  -1.22708312043706E-18  -4.13521390498571E-02  -4.13521390489697E-02
      0.00000000000000E+00   0.00000000000000E+00  -8.87333714757787E-10   0.00000000000000E+00  -8.87333714757787E-10
      4.46016775305516E-18  -3.48508628718141E-01  -3.48528780150827E-01   0.00000000000000E+00   1.76523145991562E-11
     -1.40435027303850E-22   4.62690363236100E-11   6.39213509226258E-11  -3.23308463261810E-18
      6.26376779731313E-09
      0.00000000000000E+00  -1.23127054700410E-12   0.00000000000000E+00   5.55650537526893E-13  -4.55484646529852E-23
      1.23073955818143E-09   1.23129520871891E-09  -1.16762614056844E-18  -7.43020256194981E-02  -7.43020256180265E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.47154014742087E-09   0.00000000000000E+00  -1.47154014742087E-09
      4.38659074568411E-18  -3.63769174314112E-01  -3.63844886192849E-01   0.00000000000000E+00   3.11481309702830E-11
     -1.37480907443006E-22   2.09096807731832E-10   2.40244938701977E-10  -3.21896460511567E-18
      6.31376779731313E-09
      0.00000000000000E+00  -1.55722751935362E-12   0.00000000000000E+00   4.53761783496024E-13  -4.41710730427487E-23
      1.55674371783242E-09   1.55719747961588E-09  -1.10120534501339E-18  -1.09409585946667E-01  -1.09409585944940E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.72662107949018E-09   0.00000000000000E+00  -1.72662107949018E-09
      4.30025969170961E-18  -3.77352397682936E-01  -3.77405802488297E-01   0.00000000000000E+00   3.45294757409463E-11
     -1.33969470521651E-22   1.34894124133489E-10   1.69423599874302E-10  -3.19905434669621E-18
      6.36376779731313E-09
      0.00000000000000E+00  -2.17855716656253E-12   0.00000000000000E+00   7.28812033012349E-13  -3.98311791984409E-23
      2.17786419810189E-09   2.17859301013486E-09  -1.03066125081211E-18  -1.44891429833036E-01  -1.44891429831101E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.93543933931243E-09   0.00000000000000E+00  -1.93543933931243E-09
      4.20348772474399E-18  -3.87533435204820E-01  -3.87456874034149E-01   0.00000000000000E+00   3.67163297492865E-11
     -1.29956980777655E-22  -2.79870000571585E-10  -2.43153670822428E-10  -3.17282647393188E-18
      6.41376779731313E-09
      0.00000000000000E+00  -3.70106737525171E-12   0.00000000000000E+00   1.59862714283034E-12  -2.28603347662592E-23
      3.69952611216478E-09   3.70112473930759E-09  -9.56859627832174E-19  -1.80192170525424E-01  -1.80192170523162E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.26230421579863E-09   0.00000000000000E+00  -2.26230421579863E-09
      4.09037251395405E-18  -3.89854677344621E-01  -3.89401453787086E-01   0.00000000000000E+00   4.23029010872804E-11
     -1.24874694549075E-22  -1.48112342459612E-09  -1.43882052350896E-09  -3.13351288612188E-18
      6.46376779731313E-09
      0.00000000000000E+00  -6.48120757052354E-12   0.00000000000000E+00   2.81181777442635E-12   1.92388870814719E-23
      6.47841603264575E-09   6.48122785042019E-09  -8.89586205992135E-19  -2.10996131831589E-01  -2.10996131829035E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.55383544495682E-09   0.00000000000000E+00  -2.55383544495682E-09
      3.96268074170621E-18  -3.76183086111651E-01  -3.74945874589057E-01   0.00000000000000E+00   4.86090524467220E-11
     -1.18408893417847E-22  -3.97600145790996E-09  -3.92739240546336E-09  -3.07309453571408E-18
      6.51376779731313E-09
      0.00000000000000E+00  -9.72764349659799E-12   0.00000000000000E+00   3.24555070306093E-12   7.14267886270829E-23
      9.72439663927261E-09   9.72764218997574E-09  -8.38823973897216E-19  -2.33786127420371E-01  -2.33786127417619E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.75159030125302E-09   0.00000000000000E+00  -2.75159030125302E-09
      3.82510122664356E-18  -3.41044649408570E-01  -3.38846957661103E-01   0.00000000000000E+00   5.18106713711116E-11
     -1.10977748793282E-22  -7.02786256009373E-09  -6.97605188872273E-09  -2.98627725274634E-18
      6.56376779731313E-09
      0.00000000000000E+00  -1.19947389898286E-11   0.00000000000000E+00   2.26999143145760E-12   1.09807419060356E-22
      1.19924928339097E-08   1.19947628253413E-08  -8.05524855268137E-19  -2.49067683064202E-01  -2.49067683061319E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.88387009166028E-09   0.00000000000000E+00  -2.88387009166028E-09
      3.68090772206055E-18  -2.87985966958613E-01  -2.85115646900411E-01   0.00000000000000E+00   4.79837267722359E-11
     -1.03429814809836E-22  -9.15887646045316E-09  -9.11089273368103E-09  -2.87538286679241E-18
      6.61376779731313E-09
      0.00000000000000E+00  -1.30449835597966E-11   0.00000000000000E+00   1.05199695228007E-12   1.27751874005556E-22
      1.30439505646023E-08   1.30450025615547E-08  -7.83336504085148E-19  -2.59864760625536E-01  -2.59864760622603E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.93269250803503E-09   0.00000000000000E+00  -2.93269250803503E-09
      3.53427309665879E-18  -2.28307909913557E-01  -2.25122024886285E-01   0.00000000000000E+00   3.74221639404967E-11
     -9.56791986216670E-23  -1.01497322174601E-08  -1.01123100535197E-08  -2.75093659257365E-18
      6.66376779731313E-09
      0.00000000000000E+00  -1.33252018530168E-11   0.00000000000000E+00   2.87206981427511E-13   1.31251941667875E-22
      1.33249513652232E-08   1.33252385722047E-08  -7.66938818558343E-19  -2.68443579432760E-01  -2.68443579429835E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.92491667176945E-09   0.00000000000000E+00  -2.92491667176945E-09
      3.38802726307032E-18  -1.69081193120215E-01  -1.65804514713121E-01   0.00000000000000E+00   2.72790322969869E-11
     -8.90227034971028E-23  -1.04276009327322E-08  -1.04003219004353E-08  -2.62108844451198E-18
      6.71376779731313E-09
      0.00000000000000E+00  -1.31879858156288E-11   0.00000000000000E+00  -1.27213813383252E-13   1.27631968761500E-22
      1.31881402838883E-08   1.31880130700751E-08  -7.53694750307259E-19  -2.75884647633374E-01  -2.75884647630482E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.89249926481849E-09   0.00000000000000E+00  -2.89249926481849E-09
      3.24340229982940E-18  -1.12944754596967E-01  -1.09701057861195E-01   0.00000000000000E+00   1.99750486006897E-11
     -8.29548504343157E-23  -1.03154888538572E-08  -1.02955138052566E-08  -2.48970754952214E-18
      6.73876779731313E-09
      0.00000000000000E+00  -1.29220953014130E-11   0.00000000000000E+00  -5.17059234305491E-13   1.24062670790695E-22
      1.29226006984495E-08   1.29220836392153E-08  -7.47693827957543E-19  -2.79385387240275E-01  -2.79385387237401E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.87463089443988E-09   0.00000000000000E+00  -2.87463089443988E-09
      3.17153652746840E-18  -8.65797319673682E-02  -8.34141733590164E-02   0.00000000000000E+00   1.58445381278667E-11
     -7.68111245798777E-23  -1.00632972829032E-08  -1.00474527447754E-08  -2.42384269951086E-18
      6.77251779731313E-09
      0.00000000000000E+00  -1.24345834363154E-11   0.00000000000000E+00  -7.01741475654902E-13   1.21527870438560E-22
      1.24352866655750E-08   1.24345849240995E-08  -7.37753592493982E-19  -2.84824728457227E-01  -2.84824728454429E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.79735812549926E-09   0.00000000000000E+00  -2.79735812549926E-09
      3.07712569073280E-18  -5.66269940491613E-02  -5.35906664053415E-02   0.00000000000000E+00   1.22333990946872E-11
     -5.03807054052956E-23  -9.64946019769482E-09  -9.63722679860018E-09  -2.33937209823882E-18
      6.81808029731313E-09
      0.00000000000000E+00  -1.13175677423975E-11   0.00000000000000E+00  -1.19415655968652E-12   1.30038198228442E-22
      1.13187855788231E-08   1.13175914222636E-08  -7.16391603532023E-19  -2.95066704187813E-01  -2.95066704185197E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.61571672797950E-09   0.00000000000000E+00  -2.61571672797950E-09
      2.95794709731423E-18  -3.12662408321537E-02  -2.85245940644676E-02   0.00000000000000E+00   8.11524214128413E-12
      3.28962963121149E-23  -8.70998993642545E-09  -8.70187469428413E-09  -2.24155549378221E-18
      6.86808029731313E-09
      0.00000000000000E+00  -1.01186265428904E-11   0.00000000000000E+00  -1.16384983931010E-12   1.50045132377798E-22
      1.01198198117018E-08   1.01186559618627E-08  -6.84959582823864E-19  -3.09112674890706E-01  -3.09112674888298E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40759731798908E-09   0.00000000000000E+00  -2.40759731798908E-09
      2.83756723141478E-18  -1.85123871805700E-02  -1.60829030909744E-02   0.00000000000000E+00   4.92224950993581E-12
      1.28025024755032E-22  -7.71598089338369E-09  -7.71105864387362E-09  -2.15260764859092E-18
      6.91808029731313E-09
      0.00000000000000E+00  -9.35907056618418E-12   0.00000000000000E+00  -7.31083516183795E-13   1.69510176511564E-22
      9.35980321239668E-09   9.35907212888066E-09  -6.51915789744721E-19  -3.23639821704990E-01  -3.23639821702721E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.26858434805422E-09   0.00000000000000E+00  -2.26858434805422E-09
      2.72413801401207E-18  -1.28307815119383E-02  -1.05968131019850E-02   0.00000000000000E+00   3.14058848603541E-12
      1.99551402766508E-22  -7.09362836931266E-09  -7.09048778082642E-09  -2.07222222426735E-18
      6.96808029731313E-09
      0.00000000000000E+00  -8.94181992505039E-12   0.00000000000000E+00  -3.94956537266291E-13   1.80510846720755E-22
      8.94223338525208E-09   8.94183842871500E-09  -6.19709408786261E-19  -3.37850960290258E-01  -3.37850960288043E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.21493247818434E-09   0.00000000000000E+00  -2.21493247818434E-09
      2.61339139010285E-18  -9.88614806274958E-03  -7.76672885918343E-03   0.00000000000000E+00   2.28558183947706E-12
      2.43756091478733E-22  -6.72919153237037E-09  -6.72690595053065E-09  -1.99368198131659E-18
      7.01808029731313E-09
      0.00000000000000E+00  -8.87165054582384E-12   0.00000000000000E+00  -5.29967693567400E-14   1.83548136913462E-22
      8.87169179922904E-09   8.87163880245987E-09  -5.86123564722120E-19  -3.52716470103617E-01  -3.52716470101275E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.34214173315032E-09   0.00000000000000E+00  -2.34214173315032E-09
      2.49628430344534E-18  -8.10737322077615E-03  -6.05014863684370E-03   0.00000000000000E+00   1.94046989083984E-12
      2.66817404911126E-22  -6.53143753920065E-09  -6.52949706930954E-09  -1.91016073872322E-18
      7.06808029731313E-09
      0.00000000000000E+00  -8.93529894870866E-12   0.00000000000000E+00   7.88480309762865E-14   1.76361216459864E-22
      8.93525320650561E-09   8.93533205453676E-09  -5.51027768282940E-19  -3.68240957589923E-01  -3.68240957587426E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.49772161649362E-09   0.00000000000000E+00  -2.49772161649362E-09
      2.37139822262066E-18  -6.91168642384582E-03  -4.88341019883056E-03   0.00000000000000E+00   1.74132817742844E-12
      2.67858341554981E-22  -6.43935176622089E-09  -6.43761043804319E-09  -1.82037045433772E-18
      7.11808029731313E-09
      0.00000000000000E+00  -8.80735922977857E-12   0.00000000000000E+00  -1.11869041910905E-13   1.55620416369546E-22
      8.80751184767024E-09   8.80739997862848E-09  -5.18214499302982E-19  -3.82774482844626E-01  -3.82774482842207E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.41921790187576E-09   0.00000000000000E+00  -2.41921790187576E-09
      2.25043732752687E-18  -6.06073250933877E-03  -4.04802761626904E-03   0.00000000000000E+00   1.47038523128920E-12
      2.42443864417101E-22  -6.38965246198421E-09  -6.38818207675268E-09  -1.73222282822389E-18
      7.14308029731313E-09
      0.00000000000000E+00  -8.67675601346947E-12   0.00000000000000E+00  -2.44885874412434E-13   1.40891496414759E-22
      8.67699049185887E-09   8.67674560598460E-09  -5.02873581987289E-19  -3.89565737838933E-01  -3.89565737836620E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.31310811434500E-09   0.00000000000000E+00  -2.31310811434500E-09
      2.19260962466824E-18  -5.71891857035002E-03  -3.71394596577108E-03   0.00000000000000E+00   1.30423971747582E-12
      2.21155252723644E-22  -6.36494173135729E-09  -6.36363749163959E-09  -1.68973604268095E-18
      7.17683029731313E-09
      0.00000000000000E+00  -8.39525189392840E-12   0.00000000000000E+00  -4.00542889893088E-13   1.18690921398873E-22
      8.39568915615694E-09   8.39528861326717E-09  -4.85159963359935E-19  -3.97430105607360E-01  -3.97430105605334E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.02564537547127E-09   0.00000000000000E+00  -2.02564537547127E-09
      2.12424409324609E-18  -5.36236669661624E-03  -3.35550080719938E-03   0.00000000000000E+00   1.02932607800082E-12
      1.87335313457673E-22  -6.37067256387414E-09  -6.36964323779595E-09  -1.63908412988615E-18
      7.22239279731313E-09
      0.00000000000000E+00  -7.67610760159346E-12   0.00000000000000E+00  -7.72220290960454E-13   8.77492509842859E-23
      7.67685942036175E-09   7.67608720007088E-09  -4.71892414526679E-19  -4.03530258669934E-01  -4.03530258668683E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25108722526281E-09   0.00000000000000E+00  -1.25108722526281E-09
      2.06724143154505E-18  -5.04267567760132E-03  -3.01836751133077E-03   0.00000000000000E+00   5.04536256686656E-13
      1.38199412623193E-22  -6.42550451106487E-09  -6.42499997480804E-09  -1.59534901701837E-18
      7.27239279731313E-09
      0.00000000000000E+00  -5.91672981564608E-12   0.00000000000000E+00  -1.73906141285184E-12   5.42780429130058E-23
      5.91846066398195E-09   5.91672160256916E-09  -4.86215704945292E-19  -3.98312541972029E-01  -3.98312541972613E-01
      0.00000000000000E+00   0.00000000000000E+00   5.83630163218973E-10   0.00000000000000E+00   5.83630163218973E-10
      2.09642293970600E-18  -4.87907049717345E-03  -2.83102073658105E-03   0.00000000000000E+00  -5.90932201173522E-13
      8.32698604938439E-23  -6.49976083358706E-09  -6.50035176578815E-09  -1.61020723476071E-18
      7.32239279731313E-09
      0.00000000000000E+00  -3.15128477832745E-12   0.00000000000000E+00  -2.75051802569690E-12   1.90234546124030E-23
      3.15399536704116E-09   3.15124484901548E-09  -5.49030371887262E-19  -3.73444944214683E-01  -3.73444944218031E-01
      0.00000000000000E+00   0.00000000000000E+00   3.34791384452239E-09   0.00000000000000E+00   3.34791384452239E-09
      2.26381863193212E-18  -5.11410376003894E-03  -3.06643054105741E-03   0.00000000000000E+00  -2.56672423169244E-12
      2.23269707882786E-23  -6.49659196930615E-09  -6.49915869353782E-09  -1.71478826004486E-18
      7.37239279731313E-09
      0.00000000000000E+00  -7.19603516020972E-13   0.00000000000000E+00  -2.45325317589572E-12  -1.81412102944597E-23
      7.22045612326749E-10   7.19592359150835E-10  -6.62506652806381E-19  -3.27446163750496E-01  -3.27446163756138E-01
      0.00000000000000E+00   0.00000000000000E+00   5.64215113987132E-09   0.00000000000000E+00   5.64215113987132E-09
      2.54592618892568E-18  -7.14809102782206E-03  -5.14371561133451E-03   0.00000000000000E+00  -5.89953001314917E-12
     -4.49768999863374E-23  -6.35584396900899E-09  -6.36174349902219E-09  -1.88341953611930E-18
      7.42239279731313E-09
      0.00000000000000E+00   7.14092831788520E-13   0.00000000000000E+00  -1.51325557705977E-12  -3.77404746086791E-23
     -7.12572080369679E-10  -7.14085335946776E-10  -7.99502086808722E-19  -2.68248271160837E-01  -2.68248271167341E-01
      0.00000000000000E+00   0.00000000000000E+00   6.50388874512605E-09   0.00000000000000E+00   6.50388874512605E-09
      2.87112062618199E-18  -1.71861196145160E-02  -1.53619461678642E-02   0.00000000000000E+00  -1.14129691160654E-11
     -7.65886433995021E-23  -5.77839044006309E-09  -5.78980340917924E-09  -2.07161853937327E-18
      7.47239279731313E-09
      0.00000000000000E+00   1.84635475208291E-12   0.00000000000000E+00  -1.25120414077563E-12  -4.24968604799170E-23
     -1.84510823992915E-09  -1.84635944406997E-09  -9.28195688169058E-19  -2.07293499414042E-01  -2.07293499420493E-01
      0.00000000000000E+00   0.00000000000000E+00   6.45107884437179E-09   0.00000000000000E+00   6.45107884437179E-09
      3.19367456840058E-18  -4.29660096671731E-02  -4.15152163090237E-02   0.00000000000000E+00  -2.09288763286652E-11
     -8.50218919190885E-23  -4.58379052397310E-09  -4.60471940030185E-09  -2.26547888023152E-18
      7.52239279731313E-09
      0.00000000000000E+00   2.17791425340208E-12   0.00000000000000E+00  -4.97024308660456E-13  -4.42273648891033E-23
     -2.17741368179129E-09  -2.17791070609999E-09  -1.04302373283039E-18  -1.48509351156174E-01  -1.48509351162082E-01
      0.00000000000000E+00   0.00000000000000E+00   5.90768412771804E-09   0.00000000000000E+00   5.90768412771804E-09
      3.48905877478648E-18  -7.65509988574043E-02  -7.53758693215962E-02   0.00000000000000E+00  -3.45665281211520E-11
     -9.45294744961606E-23  -3.69520689349678E-09  -3.72977342161802E-09  -2.44603504195609E-18
      7.54739279731313E-09
      0.00000000000000E+00   2.09709088465946E-12   0.00000000000000E+00  -3.95820024935803E-14  -4.50377640913223E-23
     -2.09702355033975E-09  -2.09706313234229E-09  -1.09589113419420E-18  -1.20014172979503E-01  -1.20014172984952E-01
      0.00000000000000E+00   0.00000000000000E+00   5.44836804694574E-09   0.00000000000000E+00   5.44836804694574E-09
      3.62526797596012E-18  -9.43707486186974E-02  -9.33148568311787E-02   0.00000000000000E+00  -4.66858558065938E-11
     -9.94718181495954E-23  -3.30461905879681E-09  -3.35130491460351E-09  -2.52937684176592E-18
      7.58114279731313E-09
      0.00000000000000E+00   1.90412509178644E-12   0.00000000000000E+00   7.52298559453208E-14  -4.60717387953471E-23
     -1.90421772644861E-09  -1.90414249659271E-09  -1.15883415502033E-18  -8.48132342266113E-02  -8.48132342315049E-02
      0.00000000000000E+00   0.00000000000000E+00   4.89362987555285E-09   0.00000000000000E+00   4.89362987555285E-09
      3.79042798426003E-18  -1.18712037921113E-01  -1.17770143106899E-01   0.00000000000000E+00  -5.49449131500249E-11
     -1.06052275080201E-22  -2.93454246580998E-09  -2.98948737896012E-09  -2.63159382923969E-18
      7.62670529731313E-09
      0.00000000000000E+00   1.45518801631605E-12   0.00000000000000E+00   3.01908314806902E-13  -4.71284402932834E-23
     -1.45545228541025E-09  -1.45515037709549E-09  -1.22240434793290E-18  -4.77781145389933E-02  -4.77781145429278E-02
      0.00000000000000E+00   0.00000000000000E+00   3.93449828906102E-09   0.00000000000000E+00   3.93449828906102E-09
      3.96969356255538E-18  -1.51639444923482E-01  -1.50858279364000E-01   0.00000000000000E+00  -6.07332035166333E-11
     -1.14416835420789E-22  -2.41861470844880E-09  -2.47934791196555E-09  -2.74728921462248E-18
      7.67670529731313E-09
      0.00000000000000E+00   7.96844940012502E-13   0.00000000000000E+00   5.42363058666116E-13  -4.76945043630593E-23
     -7.97378284986867E-10  -7.96835921928249E-10  -1.25912090311960E-18  -2.56424025201000E-02  -2.56424025227143E-02
      0.00000000000000E+00   0.00000000000000E+00   2.61434841287400E-09   0.00000000000000E+00   2.61434841287400E-09
      4.10041098319907E-18  -1.86970813847321E-01  -1.86398171401546E-01   0.00000000000000E+00  -5.68584245603403E-11
     -1.21945919647374E-22  -1.76065406638526E-09  -1.81751249094572E-09  -2.84129008007948E-18
      7.72670529731313E-09
      0.00000000000000E+00   3.75920509390407E-13   0.00000000000000E+00   3.73052074987438E-13  -4.78982772442980E-23
     -3.76305343506407E-10  -3.75932291431468E-10  -1.27483933381213E-18  -1.60214578225403E-02  -1.60214578241782E-02
      0.00000000000000E+00   0.00000000000000E+00   1.63795428742525E-09   0.00000000000000E+00   1.63795428742525E-09
      4.18230869757034E-18  -2.16995822738684E-01  -2.16598198494497E-01   0.00000000000000E+00  -4.59680587973699E-11
     -1.27453441691939E-22  -1.21605393719630E-09  -1.26202199599380E-09  -2.90746936375821E-18
      7.77670529731313E-09
      0.00000000000000E+00   2.09314156095953E-13   0.00000000000000E+00   1.49376921039700E-13  -4.79707043156021E-23
     -2.09506710288104E-10  -2.09357333367112E-10  -1.28229115489435E-18  -1.15648653150323E-02  -1.15648653161085E-02
      0.00000000000000E+00   0.00000000000000E+00   1.07626554696166E-09   0.00000000000000E+00   1.07626554696166E-09
      4.23612197491842E-18  -2.38831851669336E-01  -2.38558716846476E-01   0.00000000000000E+00  -3.31961904227858E-11
     -1.31171128056566E-22  -8.33712023171628E-10  -8.66908213594545E-10  -2.95383082002407E-18
      7.82670529731313E-09
      0.00000000000000E+00   1.47043424269250E-13   0.00000000000000E+00   5.64257438990078E-14  -4.79966183933311E-23
     -1.47120397246024E-10  -1.47063971502173E-10  -1.28668308262460E-18  -9.12579593075401E-03  -9.12579593149981E-03
      0.00000000000000E+00   0.00000000000000E+00   7.45798306695605E-10   0.00000000000000E+00   7.45798306695605E-10
      4.27341189025320E-18  -2.53312759216052E-01  -2.53124119402351E-01   0.00000000000000E+00  -2.18060811227126E-11
     -1.33515234318974E-22  -5.76928254070574E-10  -5.98734335193420E-10  -2.98672880762861E-18
      7.87670529731313E-09
      0.00000000000000E+00   1.18755245209332E-13   0.00000000000000E+00   2.70770331704541E-14  -4.80020367974335E-23
     -1.18760658177987E-10  -1.18733581144865E-10  -1.28970766128515E-18  -7.59615994400952E-03  -7.59615994458095E-03
      0.00000000000000E+00   0.00000000000000E+00   5.71430126370260E-10   0.00000000000000E+00   5.71430126370260E-10
      4.30198339657171E-18  -2.63538696912603E-01  -2.63396070287415E-01   0.00000000000000E+00  -1.48897808755613E-11
     -1.35073102376221E-22  -4.37806764349734E-10  -4.52696545225431E-10  -3.01227573528656E-18
      7.92670529731313E-09
      0.00000000000000E+00   1.02774260935222E-13   0.00000000000000E+00   1.69133657252740E-14  -4.79966145660278E-23
     -1.02827892174330E-10  -1.02810978808653E-10  -1.29198301158235E-18  -6.54048408193129E-03  -6.54048408241806E-03
      0.00000000000000E+00   0.00000000000000E+00   4.86775796301483E-10   0.00000000000000E+00   4.86775796301483E-10
      4.32632218638679E-18  -2.71815735930485E-01  -2.71694765173165E-01   0.00000000000000E+00  -1.15808258195327E-11
     -1.36257513422618E-22  -3.72383991673129E-10  -3.83964817492798E-10  -3.03433917480444E-18
      7.97670529731313E-09
      0.00000000000000E+00   9.19365819447343E-14   0.00000000000000E+00   1.31988445904051E-14  -4.79842939228375E-23
     -9.19527750671566E-11  -9.19395762226142E-11  -1.29376082087065E-18  -5.78405705574546E-03  -5.78405705618396E-03
      0.00000000000000E+00   0.00000000000000E+00   4.38500234120442E-10   0.00000000000000E+00   4.38500234120442E-10
      4.34824719809281E-18  -2.79080625391277E-01  -2.78971439897034E-01   0.00000000000000E+00  -9.79313553955188E-12
     -1.37239728490423E-22  -3.36767522358110E-10  -3.46560657897799E-10  -3.05448637722216E-18
      8.02670529731313E-09
      0.00000000000000E+00   8.25684187495665E-14   0.00000000000000E+00   1.28148224926505E-14  -4.79660565991763E-23
     -8.25458389231755E-11  -8.25330241007308E-11  -1.29511559708795E-18  -5.25598314801316E-03  -5.25598314843573E-03
      0.00000000000000E+00   0.00000000000000E+00   4.22571634769626E-10   0.00000000000000E+00   4.22571634769626E-10
      4.36937577983129E-18  -2.86392074625782E-01  -2.86284944090203E-01   0.00000000000000E+00  -9.77086151137703E-12
     -1.38200135246848E-22  -3.30267749157414E-10  -3.40038610668929E-10  -3.07426018274334E-18
      8.07670529731313E-09
      0.00000000000000E+00   7.15470502846633E-14   0.00000000000000E+00   1.57316803963477E-14  -4.79402842999369E-23
     -7.15438491757633E-11  -7.15281174954149E-11  -1.29597459142442E-18  -4.92903859905104E-03  -4.92903859952847E-03
      0.00000000000000E+00   0.00000000000000E+00   4.77432877226951E-10   0.00000000000000E+00   4.77432877226951E-10
      4.39324742369264E-18  -2.96427366580464E-01  -2.96299482946550E-01   0.00000000000000E+00  -1.44070814022495E-11
     -1.39580544223477E-22  -3.91497678329140E-10  -4.05904759731529E-10  -3.09727283226822E-18
      8.12670529731313E-09
      0.00000000000000E+00   6.07093712941752E-14   0.00000000000000E+00   1.68201303606951E-14  -4.79073244462878E-23
     -6.07495933107242E-11  -6.07327731804115E-11  -1.29635718945665E-18  -4.77179388518784E-03  -4.77179388574191E-03
      0.00000000000000E+00   0.00000000000000E+00   5.54067587468470E-10   0.00000000000000E+00   5.54067587468470E-10
      4.42095080306606E-18  -3.09975658104880E-01  -3.09820227059662E-01   0.00000000000000E+00  -2.08266304930827E-11
     -1.41525762720396E-22  -4.72508183794856E-10  -4.93334814288080E-10  -3.12459361360941E-18
      8.17670529731313E-09
      0.00000000000000E+00   4.54631449177257E-14   0.00000000000000E+00   2.33316237492110E-14  -4.78630154389852E-23
     -4.54476683661676E-11  -4.54243367424663E-11  -1.29604353268388E-18  -4.98644155663429E-03  -4.98644155718837E-03
      0.00000000000000E+00   0.00000000000000E+00   5.54082068637408E-10   0.00000000000000E+00   5.54082068637408E-10
      4.44865490649794E-18  -3.24522176544581E-01  -3.24361917685001E-01   0.00000000000000E+00  -2.27587688002561E-11
     -1.43598038201934E-22  -4.85898963094541E-10  -5.08657731894941E-10  -3.15261137381405E-18
      8.22670529731313E-09
      0.00000000000000E+00  -1.44196237415817E-14   0.00000000000000E+00   7.66444536515767E-14  -4.77664226865794E-23
      1.43811007122496E-11   1.44577451658535E-11  -1.29282418111365E-18  -6.92898091406928E-03  -6.92898091450944E-03
      0.00000000000000E+00   0.00000000000000E+00   4.40165630275844E-10   0.00000000000000E+00   4.40165630275844E-10
      4.47066318801173E-18  -3.38721051230044E-01  -3.38577817785387E-01   0.00000000000000E+00  -1.96716667329985E-11
     -1.45349604039046E-22  -4.34951708708521E-10  -4.54623375441665E-10  -3.17783900689807E-18
      8.27670529731313E-09
      0.00000000000000E+00  -2.83157324810805E-13   0.00000000000000E+00   3.23912244815009E-13  -4.74290705650299E-23
      2.82839868017502E-10   2.83163780262269E-10  -1.27638582579328E-18  -1.66627825492930E-02  -1.66627825492742E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.87787617995723E-11   0.00000000000000E+00  -1.87787617995723E-11
      4.46972424992174E-18  -3.53048165865466E-01  -3.52964873540159E-01   0.00000000000000E+00  -5.59554904491316E-12
     -1.45859036050212E-22  -2.58789469417649E-10  -2.64385018462708E-10  -3.19333842412846E-18
      8.32670529731313E-09
      0.00000000000000E+00  -8.56544019197394E-13   0.00000000000000E+00   7.00213821064457E-13  -4.66031819153446E-23
      8.55890585879936E-10   8.56590799700954E-10  -1.23213945269797E-18  -4.22061975349743E-02  -4.22061975340270E-02
      0.00000000000000E+00   0.00000000000000E+00  -9.47253287278097E-10   0.00000000000000E+00  -9.47253287278097E-10
      4.42236158555784E-18  -3.68442062154264E-01  -3.68470640789048E-01   0.00000000000000E+00   2.16967507521056E-11
     -1.43996652437813E-22   6.89657368251920E-11   9.06624875771536E-11  -3.19022213285987E-18
      8.37670529731313E-09
      0.00000000000000E+00  -1.24155715757135E-12   0.00000000000000E+00   5.38834902990660E-13  -4.55619493604698E-23
      1.24098963275033E-09   1.24152846765328E-09  -1.17155797104317E-18  -7.57808579477500E-02  -7.57808579462527E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.49725228353981E-09   0.00000000000000E+00  -1.49725228353981E-09
      4.34749897138085E-18  -3.83438248832033E-01  -3.83518840113077E-01   0.00000000000000E+00   3.50168636977653E-11
     -1.40854430246561E-22   2.20706952188907E-10   2.55723815886531E-10  -3.17594100033769E-18
      8.40170529731313E-09
      0.00000000000000E+00  -1.42901226621191E-12   0.00000000000000E+00   5.15714458273625E-13  -4.50118439972035E-23
      1.42851388208031E-09   1.42902959653854E-09  -1.13823010904344E-18  -9.36221173716748E-02  -9.36221173699748E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.69999582882533E-09   0.00000000000000E+00  -1.69999582882533E-09
      4.30499907566022E-18  -3.90587119156316E-01  -3.90672514655127E-01   0.00000000000000E+00   3.76969006863041E-11
     -1.39092569380024E-22   2.33269331600579E-10   2.70966232286744E-10  -3.16676896661678E-18
      8.41858029731313E-09
      0.00000000000000E+00  -1.55245159301882E-12   0.00000000000000E+00   4.99332158855547E-13  -4.45957626060254E-23
      1.55194501649834E-09   1.55244434865715E-09  -1.11484884000464E-18  -1.05881264604339E-01  -1.05881264602546E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.79291510011505E-09   0.00000000000000E+00  -1.79291510011505E-09
      4.27474363334578E-18  -3.95197233777748E-01  -3.95273024445594E-01   0.00000000000000E+00   3.83738480363279E-11
     -1.37846730742417E-22   2.02096903421663E-10   2.40470751457853E-10  -3.15989479334113E-18
      8.44136154731313E-09
      0.00000000000000E+00  -1.73513077532460E-12   0.00000000000000E+00   5.25524918156484E-13  -4.38493078442969E-23
      1.73460662202592E-09   1.73513214694403E-09  -1.08250839990702E-18  -1.22496383230093E-01  -1.22496383228223E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.86970820245522E-09   0.00000000000000E+00  -1.86970820245522E-09
      4.23214934335859E-18  -4.00907734945224E-01  -4.00950168576029E-01   0.00000000000000E+00   3.89025194781621E-11
     -1.36085944754126E-22   9.56735360331224E-11   1.34576055511148E-10  -3.14964094345157E-18
      8.47211623481313E-09
      0.00000000000000E+00  -2.14237034010277E-12   0.00000000000000E+00   7.71617423119157E-13  -4.18882895900656E-23
      2.14156933499107E-09   2.14234095241414E-09  -1.03745240782007E-18  -1.45010401152725E-01  -1.45010401150731E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.99469171047077E-09   0.00000000000000E+00  -1.99469171047077E-09
      4.17080322314422E-18  -4.07231980658799E-01  -4.07185510598777E-01   0.00000000000000E+00   4.03961122218016E-11
     -1.33498873671187E-22  -1.88045354165071E-10  -1.47649241943403E-10  -3.13335081532415E-18
      8.51363506293813E-09
      0.00000000000000E+00  -3.23835358920019E-12   0.00000000000000E+00   1.40522461063468E-12  -3.42120433433620E-23
      3.23688331847824E-09   3.23828854308884E-09  -9.74515428033939E-19  -1.75268629418643E-01  -1.75268629416412E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.23079403302203E-09   0.00000000000000E+00  -2.23079403302203E-09
      4.07818326910491E-18  -4.11030533996748E-01  -4.10713197476526E-01   0.00000000000000E+00   4.47657408423929E-11
     -1.29339870364025E-22  -1.05226025090910E-09  -1.00749451006684E-09  -3.10366784107097E-18
      8.56363506293813E-09
      0.00000000000000E+00  -5.71007915692915E-12   0.00000000000000E+00   2.51480212571459E-12  -8.69727403901755E-24
      5.70757928859502E-09   5.71009409072073E-09  -9.03607223516719E-19  -2.07844357745821E-01  -2.07844357743335E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.48667432671488E-09   0.00000000000000E+00  -2.48667432671488E-09
      3.95384955276916E-18  -4.01810942325844E-01  -4.00795523263897E-01   0.00000000000000E+00   5.11942109852128E-11
     -1.22981881775402E-22  -3.27461397499090E-09  -3.22341976400581E-09  -3.05024232925244E-18
      8.61363506293813E-09
      0.00000000000000E+00  -9.02264329379301E-12   0.00000000000000E+00   3.31622779984497E-12   3.21275325904101E-23
      9.01929005184007E-09   9.02260627963994E-09  -8.47622207921317E-19  -2.32777858357813E-01  -2.32777858355135E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.67769511247466E-09   0.00000000000000E+00  -2.67769511247466E-09
      3.81996479714543E-18  -3.72012646301666E-01  -3.70013819934864E-01   0.00000000000000E+00   5.55999479686964E-11
     -1.15314578063839E-22  -6.40051111513387E-09  -6.34491116716529E-09  -2.97234258922411E-18
      8.66363506293813E-09
      0.00000000000000E+00  -1.16787012490975E-11   0.00000000000000E+00   2.64920737247372E-12   6.65451353416310E-23
      1.16760557129147E-08   1.16787049202872E-08  -8.09906155476294E-19  -2.49682743459048E-01  -2.49682743456228E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.82023891957726E-09   0.00000000000000E+00  -2.82023891957726E-09
      3.67895285116657E-18  -3.21977936832587E-01  -3.19187176952189E-01   0.00000000000000E+00   5.40894252817348E-11
     -1.07359821968342E-22  -8.91255542599157E-09  -8.85846600070994E-09  -2.86904669569027E-18
      8.71363506293814E-09
      0.00000000000000E+00  -1.29303613277617E-11   0.00000000000000E+00   1.25202602686726E-12   8.37854264000322E-23
      1.29291320145971E-08   1.29303840406240E-08  -7.85931779354585E-19  -2.61008907921691E-01  -2.61008907918792E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.89856974180847E-09   0.00000000000000E+00  -2.89856974180847E-09
      3.53402436407614E-18  -2.61039802618722E-01  -2.57879310672769E-01   0.00000000000000E+00   4.44984606155987E-11
     -9.93841773126353E-23  -1.00763127594311E-08  -1.00318142988156E-08  -2.74809258472156E-18
      8.76363506293814E-09
      0.00000000000000E+00  -1.33335597241027E-11   0.00000000000000E+00   4.09088280039307E-13   8.82529887284884E-23
      1.33331580918765E-08   1.33335671801566E-08  -7.68543570781045E-19  -2.69804465769167E-01  -2.69804465766268E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.89925549148987E-09   0.00000000000000E+00  -2.89925549148987E-09
      3.38906158950165E-18  -1.99945082609003E-01  -1.96657719822001E-01   0.00000000000000E+00   3.20979526514523E-11
     -9.16788430611037E-23  -1.04664096413181E-08  -1.04343116886668E-08  -2.62051801872061E-18
      8.81363506293814E-09
      0.00000000000000E+00  -1.32791876396758E-11   0.00000000000000E+00  -4.52093433321784E-14   8.59969318431854E-23
      1.32792438499425E-08   1.32791986405993E-08  -7.54713069821402E-19  -2.77312625054819E-01  -2.77312625051949E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.87038476381278E-09   0.00000000000000E+00  -2.87038476381278E-09
      3.24554235131101E-18  -1.41567754115478E-01  -1.38288378584003E-01   0.00000000000000E+00   2.32556612758219E-11
     -8.59788760304174E-23  -1.04320695380623E-08  -1.04088138767865E-08  -2.49082928148961E-18
      8.83863506293814E-09
      0.00000000000000E+00  -1.30751086336007E-11   0.00000000000000E+00  -3.95402563705145E-13   8.32499951653580E-23
      1.30754933613981E-08   1.30750979588345E-08  -7.48778273634052E-19  -2.80714584732474E-01  -2.80714584729613E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86070641172807E-09   0.00000000000000E+00  -2.86070641172807E-09
      3.17402469101781E-18  -1.13449132907938E-01  -1.10230993190588E-01   0.00000000000000E+00   1.86593760999694E-11
     -8.31464734288128E-23  -1.02330509232063E-08  -1.02143915471064E-08  -2.42524641738376E-18
      8.87238506293814E-09
      0.00000000000000E+00  -1.27940637377457E-11   0.00000000000000E+00  -3.99008327602722E-13   8.02684048106470E-23
      1.27944122923248E-08   1.27940132839973E-08  -7.40380908032091E-19  -2.85495616285488E-01  -2.85495616282678E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.81066380844607E-09   0.00000000000000E+00  -2.81066380844607E-09
      3.07916478748276E-18  -7.90872291496433E-02  -7.59418636343835E-02   0.00000000000000E+00   1.49261116795389E-11
     -7.60430911639063E-23  -9.99827558723067E-09  -9.98334947555121E-09  -2.33878387945066E-18
      8.91794756293814E-09
      0.00000000000000E+00  -1.20156795899119E-11   0.00000000000000E+00  -8.31596877778610E-13   8.08413627819989E-23
      1.20164616468271E-08   1.20156300499494E-08  -7.24531392857548E-19  -2.93631446439517E-01  -2.93631446436831E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.68550734099261E-09   0.00000000000000E+00  -2.68550734099261E-09
      2.95680635925878E-18  -4.41056081901183E-02  -4.11660299919523E-02   0.00000000000000E+00   1.04717401590536E-11
     -4.02023505869876E-23  -9.34059444911576E-09  -9.33012270895675E-09  -2.23227496640123E-18
      8.96794756293814E-09
      0.00000000000000E+00  -1.07004629531001E-11   0.00000000000000E+00  -1.27996459798234E-12   9.33301876568266E-23
      1.07017689479875E-08   1.07004889833896E-08  -6.96718733307044E-19  -3.06272161604834E-01  -3.06272161602368E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.46594144023493E-09   0.00000000000000E+00  -2.46594144023493E-09
      2.83350928724703E-18  -2.39546847467697E-02  -2.13602711639803E-02   0.00000000000000E+00   6.46497868735210E-12
      3.67411477939633E-23  -8.24101252184207E-09  -8.23454754315468E-09  -2.13679055393999E-18
      9.01794756293814E-09
      0.00000000000000E+00  -9.68870132802200E-12   0.00000000000000E+00  -9.79107649258083E-13   1.11775599398921E-22
      9.68970012590298E-09   9.68872101825383E-09  -6.63460886932676E-19  -3.20733837201844E-01  -3.20733837199564E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.28006590419963E-09   0.00000000000000E+00  -2.28006590419963E-09
      2.71950599203705E-18  -1.52101831183789E-02  -1.28759729849542E-02   0.00000000000000E+00   3.96389186561142E-12
      1.06659176570516E-22  -7.41261900591993E-09  -7.40865511405421E-09  -2.05604510510437E-18
      9.06794756293814E-09
      0.00000000000000E+00  -9.08776121247315E-12   0.00000000000000E+00  -5.75203919870134E-13   1.26822256965508E-22
      9.08837361283693E-09   9.08779840891718E-09  -6.30193397994672E-19  -3.35087736640048E-01  -3.35087736637884E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.16417256305705E-09   0.00000000000000E+00  -2.16417256305705E-09
      2.61129736388420E-18  -1.10783770657062E-02  -8.89697921788423E-03   0.00000000000000E+00   2.68151821477867E-12
      1.56509419664487E-22  -6.92630736407505E-09  -6.92362584586012E-09  -1.98110396588953E-18
      9.11794756293814E-09
      0.00000000000000E+00  -8.77512172701873E-12   0.00000000000000E+00  -2.92254081996834E-13   1.34782323154892E-22
      8.77546913997326E-09   8.77517688589140E-09  -5.97665259653867E-19  -3.49168762706941E-01  -3.49168762704800E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.14148494949161E-09   0.00000000000000E+00  -2.14148494949161E-09
      2.50422311640962E-18  -8.78097833818572E-03  -6.69092621920071E-03   0.00000000000000E+00   2.07824055393145E-12
      1.86623569682974E-22  -6.63577017695392E-09  -6.63369193639980E-09  -1.90655785675575E-18
      9.16794756293814E-09
      0.00000000000000E+00  -8.79927689290431E-12   0.00000000000000E+00   3.97931687436384E-14   1.36598064530354E-22
      8.79926826474246E-09   8.79930805791135E-09  -5.62941492015646E-19  -3.64197400925855E-01  -3.64197400923540E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.31464914026150E-09   0.00000000000000E+00  -2.31464914026150E-09
      2.38849065939654E-18  -7.33195640296633E-03  -5.28885747193225E-03   0.00000000000000E+00   1.84609852507878E-12
      2.01496202253449E-22  -6.48650501617511E-09  -6.48465891764983E-09  -1.82554916738089E-18
      9.21794756293814E-09
      0.00000000000000E+00  -8.84216838518022E-12   0.00000000000000E+00   5.78181390881980E-14   1.28822839194559E-22
      8.84215301629530E-09   8.84221083443451E-09  -5.27467676683981E-19  -3.79526121979730E-01  -3.79526121977304E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.42598095927353E-09   0.00000000000000E+00  -2.42598095927353E-09
      2.26719161143287E-18  -6.33030606535527E-03  -4.30876486892530E-03   0.00000000000000E+00   1.64841932060899E-12
      1.97105939670694E-22  -6.41787829448180E-09  -6.41622987516099E-09  -1.73972393474889E-18
      9.23044756293814E-09
      0.00000000000000E+00  -8.82747322722702E-12   0.00000000000000E+00  -4.29650933163904E-14   1.25002778384864E-22
      8.82754732338524E-09   8.82750435829204E-09  -5.18696677191138E-19  -3.83308986386117E-01  -3.83308986383671E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.44552921111219E-09   0.00000000000000E+00  -2.44552921111219E-09
      2.23662249629396E-18  -6.11019540589848E-03  -4.09944624836615E-03   0.00000000000000E+00   1.61314768204759E-12
      1.92420773437390E-22  -6.38358829486200E-09  -6.38197514717976E-09  -1.71792581910282E-18
      9.24732256293814E-09
      0.00000000000000E+00  -8.78412251126507E-12   0.00000000000000E+00  -1.12587244635203E-13   1.18791027431235E-22
      8.78422000829504E-09   8.78410742105052E-09  -5.07137847256023E-19  -3.88295046977859E-01  -3.88295046975448E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.41048553792624E-09   0.00000000000000E+00  -2.41048553792624E-09
      2.19594555284146E-18  -5.85904486920520E-03  -3.85092688316506E-03   0.00000000000000E+00   1.43378658033291E-12
      1.84107612118424E-22  -6.37505566970486E-09  -6.37362188312434E-09  -1.68880770558543E-18
      9.27010381293814E-09
      0.00000000000000E+00  -8.68823660562041E-12   0.00000000000000E+00  -1.94366281274101E-13   1.08773164336640E-22
      8.68842746468979E-09   8.68823309840863E-09  -4.92321537976906E-19  -3.94687505212397E-01  -3.94687505210078E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.31948888800423E-09   0.00000000000000E+00  -2.31948888800423E-09
      2.14310469661161E-18  -5.56475430189033E-03  -3.55817229983443E-03   0.00000000000000E+00   1.31157040199882E-12
      1.69678293069129E-22  -6.37005578080657E-09  -6.36874421040440E-09  -1.65078315863471E-18
      9.30085850043814E-09
      0.00000000000000E+00  -8.48424944428249E-12   0.00000000000000E+00  -3.15634303000481E-13   9.32747798941739E-23
      8.48452592548683E-09   8.48421029118392E-09  -4.74375651745697E-19  -4.02430159743223E-01  -4.02430159741107E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.11655955965469E-09   0.00000000000000E+00  -2.11655955965469E-09
      2.07801056877929E-18  -5.23597511420249E-03  -3.22973663244929E-03   0.00000000000000E+00   1.12927943278884E-12
      1.46118733869540E-22  -6.36878001096217E-09  -6.36765073152924E-09  -1.60363491703360E-18
      9.34237732856314E-09
      0.00000000000000E+00  -8.01556575031248E-12   0.00000000000000E+00  -5.48201468256412E-13   7.13571774009403E-23
      8.01612629448415E-09   8.01557809301596E-09  -4.56502906808674E-19  -4.10183915030911E-01  -4.10183915029293E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.61770417584889E-09   0.00000000000000E+00  -1.61770417584889E-09
      2.01084538714513E-18  -4.91238005303736E-03  -2.89661807065779E-03   0.00000000000000E+00   7.67325630125094E-13
      1.11446317068868E-22  -6.39864124279732E-09  -6.39787391716708E-09  -1.55434248033645E-18
      9.39237732856314E-09
      0.00000000000000E+00  -6.76454858480876E-12   0.00000000000000E+00  -1.23244582221424E-12   4.61393111558055E-23
      6.76574889017046E-09   6.76451644434829E-09  -4.55519844010230E-19  -4.11024685844275E-01  -4.11024685843991E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.83892565164085E-10   0.00000000000000E+00  -2.83892565164085E-10
      1.99665075888692E-18  -4.68241484030355E-03  -2.64058006753677E-03   0.00000000000000E+00  -2.74702532134809E-14
      7.03376818517314E-23  -6.48059640893106E-09  -6.48062387918420E-09  -1.54113091487669E-18
      9.44237732856314E-09
      0.00000000000000E+00  -4.32653003563496E-12   0.00000000000000E+00  -2.43018380818772E-12   2.13295779306900E-23
      4.32888630077041E-09   4.32645611696224E-09  -4.95209679144650E-19  -3.95376851298367E-01  -3.95376851300562E-01
      0.00000000000000E+00   0.00000000000000E+00   2.19509971858083E-09   0.00000000000000E+00   2.19509971858083E-09
      2.10640574481597E-18  -4.63105632550289E-03  -2.57632102771160E-03   0.00000000000000E+00  -1.47934654388422E-12
      2.83899671668909E-23  -6.52007648899920E-09  -6.52155583554306E-09  -1.61119606567131E-18
      9.49237732856314E-09
      0.00000000000000E+00  -1.54537954825385E-12   0.00000000000000E+00  -2.78168688715657E-12  -7.73323612032436E-24
      1.54812782284453E-09   1.54534613595736E-09  -5.88203246822587E-19  -3.58268776841975E-01  -3.58268776846899E-01
      0.00000000000000E+00   0.00000000000000E+00   4.92344722087378E-09   0.00000000000000E+00   4.92344722087378E-09
      2.35257810585965E-18  -5.31485096246969E-03  -3.27674485959108E-03   0.00000000000000E+00  -4.01593980182122E-12
     -2.39567717938659E-23  -6.46477741702929E-09  -6.46879335683113E-09  -1.76437485903707E-18
      9.54237732856314E-09
      0.00000000000000E+00   2.19876300874819E-13   0.00000000000000E+00  -1.81932269800924E-12  -3.24137277578815E-23
     -2.18125686609972E-10  -2.19945009308013E-10  -7.21574443199094E-19  -3.03088467753081E-01  -3.03088467759506E-01
      0.00000000000000E+00   0.00000000000000E+00   6.42498074083246E-09   0.00000000000000E+00   6.42498074083246E-09
      2.67382714290128E-18  -9.55798608901064E-03  -7.60298456341768E-03   0.00000000000000E+00  -8.16971306732908E-12
     -6.74109222298716E-23  -6.19686601845706E-09  -6.20503573152445E-09  -1.95225269970218E-18
      9.59237732856314E-09
      0.00000000000000E+00   1.36435357121781E-12   0.00000000000000E+00  -1.24617034806249E-12  -4.10514326780200E-23
     -1.36310310891193E-09  -1.36434927926004E-09  -8.59120259717466E-19  -2.41206670400380E-01  -2.41206670407029E-01
      0.00000000000000E+00   0.00000000000000E+00   6.64910856242950E-09   0.00000000000000E+00   6.64910856242950E-09
      3.00628257102275E-18  -2.67248956681069E-02  -2.50598450666952E-02   0.00000000000000E+00  -1.52239820307858E-11
     -8.06506068898619E-23  -5.26953530113861E-09  -5.28475928316948E-09  -2.14716231130529E-18
      9.64237732856314E-09
      0.00000000000000E+00   2.10884701102202E-12   0.00000000000000E+00  -8.85206687495204E-13  -4.33395576747180E-23
     -2.10796196281256E-09  -2.10884716950010E-09  -9.81984726863752E-19  -1.80797265801520E-01  -1.80797265807791E-01
      0.00000000000000E+00   0.00000000000000E+00   6.27025684951399E-09   0.00000000000000E+00   6.27025684951399E-09
      3.31979541349845E-18  -5.72543584401615E-02  -5.59432359895925E-02   0.00000000000000E+00  -2.67252090343376E-11
     -8.92252899079571E-23  -4.13468447097944E-09  -4.16140968001387E-09  -2.33781068663470E-18
      9.65487732856314E-09
      0.00000000000000E+00   2.13437984796571E-12   0.00000000000000E+00  -2.81705417378820E-13  -4.37614405521231E-23
     -2.13406741140451E-09  -2.13434911682193E-09  -1.01143254547609E-18  -1.65631536674055E-01  -1.65631536680053E-01
      0.00000000000000E+00   0.00000000000000E+00   5.99763499062257E-09   0.00000000000000E+00   5.99763499062257E-09
      3.39476585088124E-18  -6.56165680564028E-02  -6.43993688143337E-02   0.00000000000000E+00  -3.58820937273369E-11
     -9.16651111953527E-23  -3.82740378007343E-09  -3.86328587380086E-09  -2.38333330540515E-18
      9.67175232856314E-09
      0.00000000000000E+00   2.13401246901688E-12   0.00000000000000E+00  -1.86328045693904E-13  -4.43141919025867E-23
     -2.13378563272254E-09  -2.13397196076828E-09  -1.04916888411092E-18  -1.45774393359574E-01  -1.45774393365320E-01
      0.00000000000000E+00   0.00000000000000E+00   5.74621028333864E-09   0.00000000000000E+00   5.74621028333864E-09
      3.49173314941257E-18  -7.74568819406348E-02  -7.63187786398841E-02   0.00000000000000E+00  -4.09567105308344E-11
     -9.49987850813635E-23  -3.57128161203941E-09  -3.61223832257034E-09  -2.44256426530166E-18
      9.68314295356314E-09
      0.00000000000000E+00   2.10131574257100E-12   0.00000000000000E+00  -5.62214021374784E-14  -4.46900214373864E-23
     -2.10125683176814E-09  -2.10131305317033E-09  -1.07367789813178E-18  -1.32623924177346E-01  -1.32623924182895E-01
      0.00000000000000E+00   0.00000000000000E+00   5.54907323241841E-09   0.00000000000000E+00   5.54907323241841E-09
      3.55494056170059E-18  -8.56411724175050E-02  -8.45548891122815E-02   0.00000000000000E+00  -4.56775882003356E-11
     -9.72627823077972E-23  -3.40208259104768E-09  -3.44776017924812E-09  -2.48126266356881E-18
      9.69852029731314E-09
      0.00000000000000E+00   2.03977976864196E-12   0.00000000000000E+00  -5.94353375213835E-15  -4.51916025552279E-23
     -2.03979013329172E-09  -2.03979607682552E-09  -1.10510430037341E-18  -1.15458696695259E-01  -1.15458696700566E-01
      0.00000000000000E+00   0.00000000000000E+00   5.30745648087596E-09   0.00000000000000E+00   5.30745648087596E-09
      3.63655514444518E-18  -9.68420053835854E-02  -9.58124653435471E-02   0.00000000000000E+00  -4.98786302955701E-11
     -1.00308410529487E-22  -3.21778177375477E-09  -3.26766040405044E-09  -2.53145084407178E-18
      9.71927971137564E-09
      0.00000000000000E+00   1.92515753660697E-12   0.00000000000000E+00   6.38205721864539E-14  -4.58397092809766E-23
     -1.92519091859553E-09  -1.92512709802339E-09  -1.14440704975441E-18  -9.35026445383568E-02  -9.35026445433295E-02
      0.00000000000000E+00   0.00000000000000E+00   4.97267707077145E-09   0.00000000000000E+00   4.97267707077145E-09
      3.73978500675643E-18  -1.12040385847884E-01  -1.11080195460078E-01   0.00000000000000E+00  -5.49945183632972E-11
     -1.04396883318187E-22  -2.99255545438468E-09  -3.04754997274808E-09  -2.59537795700201E-18
      9.74730492036001E-09
      0.00000000000000E+00   1.70105637782060E-12   0.00000000000000E+00   1.89432097928459E-13  -4.66115409887450E-23
     -1.70124775777339E-09  -1.70105832567551E-09  -1.19056804850429E-18  -6.70012371559698E-02  -6.70012371604229E-02
      0.00000000000000E+00   0.00000000000000E+00   4.45314418316511E-09   0.00000000000000E+00   4.45314418316511E-09
      3.86458530312719E-18  -1.32550982528954E-01  -1.31683883811763E-01   0.00000000000000E+00  -6.03125825637899E-11
     -1.09821124689668E-22  -2.69177327492571E-09  -2.75208585748961E-09  -2.67401725462290E-18
      9.78513895248892E-09
      0.00000000000000E+00   1.24605754969452E-12   0.00000000000000E+00   4.27893488295075E-13  -4.73431862898899E-23
     -1.24642798320073E-09  -1.24600008971248E-09  -1.23533856956050E-18  -4.05179511097723E-02  -4.05179511133075E-02
      0.00000000000000E+00   0.00000000000000E+00   3.53519303307682E-09   0.00000000000000E+00   3.53519303307682E-09
      3.99833590992250E-18  -1.60358861785416E-01  -1.59637606756181E-01   0.00000000000000E+00  -6.19337222330764E-11
     -1.16549445165522E-22  -2.22725922113111E-09  -2.28919294336431E-09  -2.76299734036200E-18
      9.83513895248892E-09
      0.00000000000000E+00   6.56506181559401E-13   0.00000000000000E+00   4.95190057571295E-13  -4.77851320939058E-23
     -6.56983512636782E-10  -6.56488322579258E-10  -1.26499072777756E-18  -2.25087182416795E-02  -2.25087182440037E-02
      0.00000000000000E+00   0.00000000000000E+00   2.32426519485005E-09   0.00000000000000E+00   2.32426519485005E-09
      4.11454916966500E-18  -1.95136382417522E-01  -1.94610916985092E-01   0.00000000000000E+00  -5.48747088866419E-11
     -1.23603980180834E-22  -1.61290216338406E-09  -1.66777687227083E-09  -2.84955844188744E-18
      9.88513895248892E-09
      0.00000000000000E+00   3.20721822328683E-13   0.00000000000000E+00   2.98015609496250E-13  -4.79431514019099E-23
     -3.20966455148643E-10  -3.20668439539194E-10  -1.27791143422894E-18  -1.45967944377477E-02  -1.45967944392311E-02
      0.00000000000000E+00   0.00000000000000E+00   1.48331831948563E-09   0.00000000000000E+00   1.48331831948563E-09
      4.18871508563929E-18  -2.23578921155136E-01  -2.23212606134125E-01   0.00000000000000E+00  -4.35039250399535E-11
     -1.28703090543566E-22  -1.11914595490634E-09  -1.16264987994642E-09  -2.91080365141034E-18
      9.93513895248892E-09
      0.00000000000000E+00   1.90669674442826E-13   0.00000000000000E+00   1.16514322461856E-13  -4.80001674827757E-23
     -1.90750129326953E-10  -1.90633615004539E-10  -1.28439309082048E-18  -1.07622169243188E-02  -1.07622169253100E-02
      0.00000000000000E+00   0.00000000000000E+00   9.91168938804190E-10   0.00000000000000E+00   9.91168938804190E-10
      4.23827353257949E-18  -2.43737514517687E-01  -2.43485292136424E-01   0.00000000000000E+00  -3.07988967294420E-11
     -1.32098413725148E-22  -7.69736427070076E-10  -8.00535323799650E-10  -2.95388044175902E-18
      9.98513895248892E-09
      0.00000000000000E+00   1.39695845292648E-13   0.00000000000000E+00   4.64801224335338E-14  -4.80195141908924E-23
     -1.39767678267245E-10  -1.39721198144859E-10  -1.28838308849058E-18  -8.59007239582829E-03  -8.59007239652519E-03
      0.00000000000000E+00   0.00000000000000E+00   6.96906935414391E-10   0.00000000000000E+00   6.96906935414391E-10
      4.27311887935021E-18  -2.56998802588103E-01  -2.56823253845021E-01   0.00000000000000E+00  -1.99647316988649E-11
     -1.34220438909513E-22  -5.37221005570523E-10  -5.57185737269522E-10  -2.98473579085964E-18
      1.00351389524889E-08
      0.00000000000000E+00   1.14897766246616E-13   0.00000000000000E+00   2.42705631110117E-14  -4.80211672407541E-23
     -1.14959489663089E-10  -1.14935219100026E-10  -1.29118272793881E-18  -7.20452187008413E-03  -7.20452187063047E-03
      0.00000000000000E+00   0.00000000000000E+00   5.46341912745420E-10   0.00000000000000E+00   5.46341912745420E-10
      4.30043597498748E-18  -2.66589511323102E-01  -2.66453592743701E-01   0.00000000000000E+00  -1.38811957669237E-11
     -1.35658939496692E-22  -4.17525497878319E-10  -4.31406693645378E-10  -3.00925324704868E-18
      1.00601389524889E-08
      0.00000000000000E+00   1.04794845153788E-13   0.00000000000000E+00   2.12374216913653E-14  -4.80182915886659E-23
     -1.04814112557011E-10  -1.04792875135368E-10  -1.29234073452837E-18  -6.67007537745387E-03  -6.67007537793967E-03
      0.00000000000000E+00   0.00000000000000E+00   4.85807642329465E-10   0.00000000000000E+00   4.85807642329465E-10
      4.31258116604572E-18  -2.70643145304503E-01  -2.70523104095464E-01   0.00000000000000E+00  -1.13424709090048E-11
     -1.36238552650064E-22  -3.69672296284972E-10  -3.81014767194113E-10  -3.02024043151735E-18
      1.00938889524889E-08
      0.00000000000000E+00   9.70798872283558E-14   0.00000000000000E+00   1.33320343947210E-14  -4.80114065061684E-23
     -9.71360670278152E-11  -9.71227349934685E-11  -1.29366639584478E-18  -6.08797973660721E-03  -6.08797973706269E-03
      0.00000000000000E+00   0.00000000000000E+00   4.55482912456323E-10   0.00000000000000E+00   4.55482912456323E-10
      4.32795371434112E-18  -2.75731935876146E-01  -2.75619032651805E-01   0.00000000000000E+00  -1.03245898889082E-11
     -1.36940440582061E-22  -3.48035587573761E-10  -3.58360177462806E-10  -3.03428731849634E-18
      1.01052795774889E-08
      0.00000000000000E+00   9.47837687981676E-14   0.00000000000000E+00   1.25431972440402E-14  -4.80087576946104E-23
     -9.47871998887825E-11  -9.47746566915864E-11  -1.29408942085923E-18  -5.90859424586854E-03  -5.90859424630226E-03
      0.00000000000000E+00   0.00000000000000E+00   4.33716905348583E-10   0.00000000000000E+00   4.33716905348583E-10
      4.33289402096611E-18  -2.77302949926373E-01  -2.77196164892886E-01   0.00000000000000E+00  -9.23253640564358E-12
     -1.37151572462750E-22  -3.29709712251369E-10  -3.38942248657150E-10  -3.03880460010688E-18
      1.01206569212389E-08
      0.00000000000000E+00   9.08344450982440E-14   0.00000000000000E+00   1.54463483561832E-14  -4.80043061455337E-23
     -9.08632829695622E-11  -9.08478366212540E-11  -1.29460447101261E-18  -5.69753124227671E-03  -5.69753124270310E-03
      0.00000000000000E+00   0.00000000000000E+00   4.26391036889861E-10   0.00000000000000E+00   4.26391036889861E-10
      4.33945078251228E-18  -2.79428436827931E-01  -2.79322722738033E-01   0.00000000000000E+00  -9.20021156396644E-12
     -1.37432960940254E-22  -3.26342988704531E-10  -3.35543200268635E-10  -3.04484631149967E-18
      1.01414163353014E-08
      0.00000000000000E+00   8.72525003471504E-14   0.00000000000000E+00   1.17258833793737E-14  -4.79975229979738E-23
     -8.72879774940617E-11  -8.72762516107303E-11  -1.29523365550059E-18  -5.44699170281094E-03  -5.44699170323209E-03
      0.00000000000000E+00   0.00000000000000E+00   4.21155320566767E-10   0.00000000000000E+00   4.21155320566767E-10
      4.34819372019655E-18  -2.82316108642766E-01  -2.82210918887108E-01   0.00000000000000E+00  -9.23562367242646E-12
     -1.37811256476324E-22  -3.24643445283388E-10  -3.33879068955953E-10  -3.05296006469597E-18
      1.01694415442858E-08
      0.00000000000000E+00   8.27521082239816E-14   0.00000000000000E+00   1.16473675018013E-14  -4.79868928346353E-23
     -8.27676662472674E-11  -8.27560188798136E-11  -1.29597131728404E-18  -5.16350899953145E-03  -5.16350899995238E-03
      0.00000000000000E+00   0.00000000000000E+00   4.20930464914648E-10   0.00000000000000E+00   4.20930464914648E-10
      4.35999038444367E-18  -2.86375578793710E-01  -2.86269035653836E-01   0.00000000000000E+00  -9.68581440564547E-12
     -1.38341104727043E-22  -3.28488631629068E-10  -3.38174446034852E-10  -3.06401906715964E-18
      1.02072755764147E-08
      0.00000000000000E+00   7.55882187217945E-14   0.00000000000000E+00   1.39058876677361E-14  -4.79689798702297E-23
     -7.55665126086180E-11  -7.55526067209982E-11  -1.29672432649399E-18  -4.87943320029025E-03  -4.87943320074361E-03
      0.00000000000000E+00   0.00000000000000E+00   4.53362145552262E-10   0.00000000000000E+00   4.53362145552262E-10
      4.37714290242453E-18  -2.93108154259177E-01  -2.92989122893903E-01   0.00000000000000E+00  -1.24953383143835E-11
     -1.39248480710977E-22  -3.65314200516711E-10  -3.77809538831234E-10  -3.08041857593054E-18
      1.02572755764147E-08
      0.00000000000000E+00   6.53934528917590E-14   0.00000000000000E+00   1.57170356666482E-14  -4.79386298456387E-23
     -6.54263000247531E-11  -6.54105829891344E-11  -1.29727295216689E-18  -4.65383656600966E-03  -4.65383656654284E-03
      0.00000000000000E+00   0.00000000000000E+00   5.33176592126752E-10   0.00000000000000E+00   5.33176592126752E-10
      4.40380173203086E-18  -3.05582874864602E-01  -3.05435500079886E-01   0.00000000000000E+00  -1.88840369271256E-11
     -1.41021138979262E-22  -4.48881972210356E-10  -4.67766009137623E-10  -3.10652877986398E-18
      1.03072755764147E-08
      0.00000000000000E+00   5.57497554849687E-14   0.00000000000000E+00   1.63633514107942E-14  -4.79021146098241E-23
     -5.57593900103542E-11  -5.57430266589913E-11  -1.29740446203321E-18  -4.60714374246361E-03  -4.60714374303237E-03
      0.00000000000000E+00   0.00000000000000E+00   5.68759117095963E-10   0.00000000000000E+00   5.68759117095963E-10
      4.43223968788567E-18  -3.20001401950994E-01  -3.19839769862624E-01   0.00000000000000E+00  -2.27863331204546E-11
     -1.43106517826921E-22  -4.90229757316384E-10  -5.13016090436982E-10  -3.13483522585246E-18
      1.03572755764147E-08
      0.00000000000000E+00   2.82881790599182E-14   0.00000000000000E+00   3.79438547553626E-14  -4.78429357700922E-23
     -2.83636056701855E-11  -2.83256618154780E-11  -1.29623908322193E-18  -5.32172129094144E-03  -5.32172129146086E-03
      0.00000000000000E+00   0.00000000000000E+00   5.19422230728873E-10   0.00000000000000E+00   5.19422230728873E-10
      4.45821079942211E-18  -3.34381884804164E-01  -3.34227159305270E-01   0.00000000000000E+00  -2.21399250366277E-11
     -1.45082795686363E-22  -4.68956643876607E-10  -4.91096568913380E-10  -3.16197171620019E-18
      1.04072755764147E-08
      0.00000000000000E+00  -9.83657135492612E-14   0.00000000000000E+00   1.55939955542265E-13  -4.76707953001948E-23
      9.81938351784678E-11   9.83497751339624E-11  -1.28886014726231E-18  -9.72859421693115E-03  -9.72859421722164E-03
      0.00000000000000E+00   0.00000000000000E+00   2.90496442675835E-10   0.00000000000000E+00   2.90496442675835E-10
      4.47273562155590E-18  -3.48413022155528E-01  -3.48290514192865E-01   0.00000000000000E+00  -1.51030321402234E-11
     -1.46409948153350E-22  -3.73743185669426E-10  -3.88846217809795E-10  -3.18387547429360E-18
      1.04572755764147E-08
      0.00000000000000E+00  -5.59242604856630E-13   0.00000000000000E+00   5.53619162414288E-13  -4.70897910523287E-23
      5.58699254581435E-10   5.59252873743802E-10  -1.25885785584168E-18  -2.73124092759157E-02  -2.73124092754433E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.72442603187935E-10   0.00000000000000E+00  -4.72442603187935E-10
      4.44911349139651E-18  -3.63271349105370E-01  -3.63244008387593E-01   0.00000000000000E+00   8.24437643632268E-12
     -1.45728324825612E-22  -9.50546469920687E-11  -8.68102705558918E-11  -3.19025563555483E-18
      1.04822755764147E-08
      0.00000000000000E+00  -9.00996872005837E-13   0.00000000000000E+00   8.11936149764824E-13  -4.66543510566762E-23
      9.00099164315455E-10   9.00911100465174E-10  -1.23557013555683E-18  -4.06901909268918E-02  -4.06901909258718E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.02002625079573E-09   0.00000000000000E+00  -1.02002625079573E-09
      4.42361283512661E-18  -3.71002549556538E-01  -3.71040093252307E-01   0.00000000000000E+00   2.40158092013461E-11
     -1.44702786965228E-22   9.50993411293576E-11   1.19115150330559E-10  -3.18804269956978E-18
      1.05160255764147E-08
      0.00000000000000E+00  -1.17423496519823E-12   0.00000000000000E+00   5.56096878977298E-13  -4.59574821047978E-23
      1.17371118838997E-09   1.17426728526890E-09  -1.19591159591865E-18  -6.28986106442714E-02  -6.28986106428428E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.42859117436497E-09   0.00000000000000E+00  -1.42859117436497E-09
      4.37539788299179E-18  -3.81363470377437E-01  -3.81443617570132E-01   0.00000000000000E+00   3.42458301726348E-11
     -1.42673297555907E-22   2.20078058923609E-10   2.54323889096101E-10  -3.17948628707314E-18
      1.05388068264147E-08
      0.00000000000000E+00  -1.33165684477193E-12   0.00000000000000E+00   4.94488771924295E-13  -4.54644498242936E-23
      1.33119671393756E-09   1.33169120270944E-09  -1.16643682647742E-18  -7.89779453365846E-02  -7.89779453349576E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.62700666302365E-09   0.00000000000000E+00  -1.62700666302365E-09
      4.33833263744979E-18  -3.88142928535441E-01  -3.88235993234065E-01   0.00000000000000E+00   3.77263041386376E-11
     -1.41120463124795E-22   2.57589156175600E-10   2.95315460314097E-10  -3.17189581097237E-18
      1.05541841701647E-08
      0.00000000000000E+00  -1.43213498727696E-12   0.00000000000000E+00   4.70441430265607E-13  -4.51230999188350E-23
      1.43167614967817E-09   1.43214659110839E-09  -1.14561769563989E-18  -9.01247335938705E-02  -9.01247335921417E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.72878928241001E-09   0.00000000000000E+00  -1.72878928241001E-09
      4.31174845038285E-18  -3.92580611839717E-01  -3.92674096701389E-01   0.00000000000000E+00   3.88768392883474E-11
     -1.40015166795796E-22   2.57765852013420E-10   2.96642691301627E-10  -3.16613075474296E-18
      1.05749435842272E-08
      0.00000000000000E+00  -1.55401295355135E-12   0.00000000000000E+00   4.30465058713352E-13  -4.46246403247653E-23
      1.55354237528794E-09   1.55397284034661E-09  -1.11668827535716E-18  -1.05329509798228E-01  -1.05329509796423E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.80566030621898E-09   0.00000000000000E+00  -1.80566030621898E-09
      4.27426400042983E-18  -3.98249771081593E-01  -3.98329096016698E-01   0.00000000000000E+00   3.94479453537874E-11
     -1.38460388431022E-22   2.12239520518664E-10   2.51687465872313E-10  -3.15757572507267E-18
      1.06029687932116E-08
      0.00000000000000E+00  -1.78068576497953E-12   0.00000000000000E+00   5.28731084106052E-13  -4.36925592388255E-23
      1.78019388397272E-09   1.78072261505678E-09  -1.07662187947638E-18  -1.25867903898781E-01  -1.25867903896889E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.89167653477848E-09   0.00000000000000E+00  -1.89167653477848E-09
      4.22124937021183E-18  -4.05093415042633E-01  -4.05128408389339E-01   0.00000000000000E+00   3.99286932849162E-11
     -1.36250852771518E-22   7.10252264369615E-11   1.10953919721741E-10  -3.14462749073545E-18
      1.06408028253405E-08
      0.00000000000000E+00  -2.36803285942166E-12   0.00000000000000E+00   8.81291018431753E-13  -4.07419087244805E-23
      2.36716630179765E-09   2.36804759281604E-09  -1.02043081262868E-18  -1.53696008447995E-01  -1.53696008445938E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.05680551952000E-09   0.00000000000000E+00  -2.05680551952000E-09
      4.14343212410340E-18  -4.11933248278680E-01  -4.11835245203946E-01   0.00000000000000E+00   4.21723222184520E-11
     -1.32907833150294E-22  -3.53414395514368E-10  -3.11242073296049E-10  -3.12300131147472E-18
      1.06908028253405E-08
      0.00000000000000E+00  -4.04851601610778E-12   0.00000000000000E+00   1.75179065334518E-12  -2.74894227812277E-23
      4.04672186521476E-09   4.04847365586808E-09  -9.45329236262773E-19  -1.89191488070989E-01  -1.89191488068656E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.33384257322208E-09   0.00000000000000E+00  -2.33384257322208E-09
      4.02673999544229E-18  -4.12047085294637E-01  -4.11506984027812E-01   0.00000000000000E+00   4.79896432631434E-11
     -1.27389690363466E-22  -1.76262072590900E-09  -1.71463108264598E-09  -3.08141075917952E-18
      1.07408028253405E-08
      0.00000000000000E+00  -6.99195615413460E-12   0.00000000000000E+00   2.96834428895188E-12   4.90613388837918E-24
      6.98896936784768E-09   6.99193771213663E-09  -8.79215280654430E-19  -2.19075686371322E-01  -2.19075686368753E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.56895367809579E-09   0.00000000000000E+00  -2.56895367809579E-09
      3.89829231153750E-18  -3.95230215797053E-01  -3.93836889281515E-01   0.00000000000000E+00   5.38423018797419E-11
     -1.20426683957044E-22  -4.47682633592044E-09  -4.42298403404082E-09  -3.01907703088307E-18
      1.07908028253405E-08
      0.00000000000000E+00  -1.02437190749671E-11   0.00000000000000E+00   3.24758569605465E-12   4.44983423896921E-23
      1.02404564659407E-08   1.02437040516368E-08  -8.30393481066587E-19  -2.40729596148076E-01  -2.40729596145339E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.73650694556872E-09   0.00000000000000E+00  -2.73650694556872E-09
      3.76146696425907E-18  -3.56899427600122E-01  -3.54534417096179E-01   0.00000000000000E+00   5.64662504986179E-11
     -1.12434189932421E-22  -7.56366335656661E-09  -7.50719710606811E-09  -2.93107348319248E-18
      1.08408028253405E-08
      0.00000000000000E+00  -1.23398915122545E-11   0.00000000000000E+00   2.09144568844335E-12   7.17079446373475E-23
      1.23378517400449E-08   1.23399431857334E-08  -7.98951406123700E-19  -2.55027284663517E-01  -2.55027284660659E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.85793659252365E-09   0.00000000000000E+00  -2.85793659252365E-09
      3.61857013463288E-18  -3.00909593589734E-01  -2.97922363848463E-01   0.00000000000000E+00   5.17523448045588E-11
     -1.04512694483769E-22  -9.53375893801419E-09  -9.48200659320973E-09  -2.81961872850918E-18
      1.08908028253405E-08
      0.00000000000000E+00  -1.31743927945221E-11   0.00000000000000E+00   8.37539960295639E-13   8.26792991662802E-23
      1.31735900923828E-08   1.31744276323431E-08  -7.78277726108679E-19  -2.65050680129509E-01  -2.65050680126606E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90309752596490E-09   0.00000000000000E+00  -2.90309752596490E-09
      3.47341525833464E-18  -2.38837160375099E-01  -2.35601183838267E-01   0.00000000000000E+00   3.98920966275893E-11
     -9.63757172111157E-23  -1.03112222030058E-08  -1.02713301063783E-08  -2.69513753222596E-18
      1.09158028253405E-08
      0.00000000000000E+00  -1.32597165553878E-11   0.00000000000000E+00   1.79156160849986E-13   8.39263625032169E-23
      1.32595281463151E-08   1.32597073024760E-08  -7.70076330948264E-19  -2.69242687275394E-01  -2.69242687272476E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.91713060138019E-09   0.00000000000000E+00  -2.91713060138019E-09
      3.40048699330013E-18  -2.07729321042212E-01  -2.04470865498971E-01   0.00000000000000E+00   3.15344105709976E-11
     -9.24186748806672E-23  -1.03741111116667E-08  -1.03425767010958E-08  -2.63041066235187E-18
      1.09495528253405E-08
      0.00000000000000E+00  -1.32790957949386E-11   0.00000000000000E+00   3.68696439674194E-14   8.28956449798134E-23
      1.32790454281540E-08   1.32790822977980E-08  -7.60290693067964E-19  -2.74454408812617E-01  -2.74454408809726E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.89059463984927E-09   0.00000000000000E+00  -2.89059463984927E-09
      3.30292942420522E-18  -1.67374208865467E-01  -1.64101254979436E-01   0.00000000000000E+00   2.54343448734377E-11
     -8.82657047208453E-23  -1.04139220028220E-08  -1.03884876579487E-08  -2.54263873113725E-18
      1.09723340753405E-08
      0.00000000000000E+00  -1.31750357076825E-11   0.00000000000000E+00  -2.17614412061607E-13   8.09510544256258E-23
      1.31752167018790E-08   1.31749990874670E-08  -7.54450355254667E-19  -2.77698911989498E-01  -2.77698911986620E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.87873453421324E-09   0.00000000000000E+00  -2.87873453421324E-09
      3.23734825309767E-18  -1.40825100824814E-01  -1.37581183346653E-01   0.00000000000000E+00   2.14522797835010E-11
     -8.59269039709147E-23  -1.03177168330372E-08  -1.02962645532538E-08  -2.48289789784301E-18
      1.09877114190905E-08
      0.00000000000000E+00  -1.30714348441124E-11   0.00000000000000E+00  -3.25153103864432E-13   7.93437594760213E-23
      1.30717513268559E-08   1.30714261737521E-08  -7.50739971622550E-19  -2.79811036057368E-01  -2.79811036054500E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86746683459842E-09   0.00000000000000E+00  -2.86746683459842E-09
      3.19325422989033E-18  -1.23364422567866E-01  -1.20149575264294E-01   0.00000000000000E+00   1.90843906651906E-11
     -8.42792324935722E-23  -1.02230437298187E-08  -1.02039593391536E-08  -2.44251425826778E-18
      1.10084708331530E-08
      0.00000000000000E+00  -1.29373415277894E-11   0.00000000000000E+00  -3.11719299892203E-13   7.74480821369768E-23
      1.29376424558367E-08   1.29373307365369E-08  -7.45705535121590E-19  -2.82691029006299E-01  -2.82691029003459E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.84007137157745E-09   0.00000000000000E+00  -2.84007137157745E-09
      3.13429601232070E-18  -1.00931984782411E-01  -9.77507410987147E-02   0.00000000000000E+00   1.67907165003606E-11
     -8.15594625535895E-23  -1.01140500814597E-08  -1.00972593649594E-08  -2.38859047719911E-18
      1.10364960421374E-08
      0.00000000000000E+00  -1.26741145109527E-11   0.00000000000000E+00  -4.55488222014314E-13   7.54883115997564E-23
      1.26745211972139E-08   1.26740657089919E-08  -7.38458943918528E-19  -2.86769140988241E-01  -2.86769140985447E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.79360058249343E-09   0.00000000000000E+00  -2.79360058249343E-09
      3.05600477217745E-18  -7.34196221120864E-02  -7.03066667625002E-02   0.00000000000000E+00   1.39575784782723E-11
     -7.40041059310367E-23  -9.89442270497672E-09  -9.88046512649852E-09  -2.31754582825892E-18
      1.10743300742663E-08
      0.00000000000000E+00  -1.19831665529404E-11   0.00000000000000E+00  -8.89213361814466E-13   7.64116040787834E-23
      1.19841175430736E-08   1.19832283297119E-08  -7.25054325041506E-19  -2.93613825581259E-01  -2.93613825578577E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.68241224292639E-09   0.00000000000000E+00  -2.68241224292639E-09
      2.95451830119560E-18  -4.47207173145228E-02  -4.17903726834753E-02   0.00000000000000E+00   1.03258351507715E-11
     -4.33649094630814E-23  -9.31114192193621E-09  -9.30081608678548E-09  -2.22946397615410E-18
      1.11243300742663E-08
      0.00000000000000E+00  -1.07245262742485E-11   0.00000000000000E+00  -1.22440497981435E-12   8.86750969168236E-23
      1.07257355152099E-08   1.07245111102302E-08  -6.97320406437263E-19  -3.06229104876515E-01  -3.06229104874049E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.46638898702351E-09   0.00000000000000E+00  -2.46638898702351E-09
      2.83119885184443E-18  -2.43481693215241E-02  -2.17463283726825E-02   0.00000000000000E+00   6.46991439787776E-12
      3.05050722958145E-23  -8.26459203760462E-09  -8.25812212320671E-09  -2.13387844540716E-18
      1.11743300742663E-08
      0.00000000000000E+00  -9.71349940706803E-12   0.00000000000000E+00  -9.78320802724332E-13   1.06733371325223E-22
      9.71447239109498E-09   9.71349407029237E-09  -6.64091931314373E-19  -3.20673772415303E-01  -3.20673772413024E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.27978670924937E-09   0.00000000000000E+00  -2.27978670924937E-09
      2.71720951638196E-18  -1.54074992999294E-02  -1.30653961557146E-02   0.00000000000000E+00   3.99615872429646E-12
      9.91794062178558E-23  -7.43770351976739E-09  -7.43370736104299E-09  -2.05311758506758E-18
      1.12243300742663E-08
      0.00000000000000E+00  -9.10273190463798E-12   0.00000000000000E+00  -5.84850699906819E-13   1.21715722374724E-22
      9.10330341169364E-09   9.10271856099385E-09  -6.30769072477101E-19  -3.35030931284441E-01  -3.35030931282280E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.16015757707173E-09   0.00000000000000E+00  -2.16015757707173E-09
      2.60920163752837E-18  -1.11802962794091E-02  -8.99293267537045E-03   0.00000000000000E+00   2.70374652573391E-12
      1.48608329973195E-22  -6.94526473044802E-09  -6.94256098392214E-09  -1.97843256505127E-18
      1.12743300742663E-08
      0.00000000000000E+00  -8.77089686910718E-12   0.00000000000000E+00  -3.11147050507533E-13   1.29802924794870E-22
      8.77126385737540E-09   8.77095271032502E-09  -5.98323833099433E-19  -3.49049017748326E-01  -3.49049017746200E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.12558039764768E-09   0.00000000000000E+00  -2.12558039764768E-09
      2.50292261764599E-18  -8.83775739075947E-03  -6.74402522112496E-03   0.00000000000000E+00   2.08634875993415E-12
      1.78708880960724E-22  -6.64745866143741E-09  -6.64537231267730E-09  -1.90459878454656E-18
      1.13243300742663E-08
      0.00000000000000E+00  -8.77328483227458E-12   0.00000000000000E+00   1.82173864327831E-14   1.31912544925445E-22
      8.77329838245620E-09   8.77331659984277E-09  -5.63884828264703E-19  -3.63927486434087E-01  -3.63927486431803E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.28416282456893E-09   0.00000000000000E+00  -2.28416282456893E-09
      2.38871447641754E-18  -7.36683928980015E-03  -5.32232422036519E-03   0.00000000000000E+00   1.84342206356539E-12
      1.93885739925828E-22  -6.49099719733759E-09  -6.48915377527383E-09  -1.82482964815284E-18
      1.13493300742663E-08
      0.00000000000000E+00  -8.83831090621751E-12   0.00000000000000E+00   1.44028238604034E-13   1.30047370893078E-22
      8.83820734829074E-09   8.83835137652947E-09  -5.45931389424471E-19  -3.71657015694062E-01  -3.71657015691652E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.41030569595704E-09   0.00000000000000E+00  -2.41030569595704E-09
      2.32845683401861E-18  -6.80844734762612E-03  -4.78318440450677E-03   0.00000000000000E+00   1.75311646904375E-12
      1.95291760988646E-22  -6.42979879704167E-09  -6.42804568057243E-09  -1.78252544459415E-18
      1.13830800742663E-08
      0.00000000000000E+00  -8.83858644042913E-12   0.00000000000000E+00   1.57223011512445E-14   1.23104189188675E-22
      8.83856325920253E-09   8.83857898150381E-09  -5.21921495421909E-19  -3.81996654493135E-01  -3.81996654490697E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.43757912999339E-09   0.00000000000000E+00  -2.43757912999339E-09
      2.24618853838134E-18  -6.19917282916586E-03  -4.18242979548603E-03   0.00000000000000E+00   1.58051999465667E-12
      1.88776130623554E-22  -6.40258037150533E-09  -6.40099985151048E-09  -1.72426704295943E-18
      1.14058613242663E-08
      0.00000000000000E+00  -8.78761261127895E-12   0.00000000000000E+00  -9.60141602133250E-14   1.15436011592897E-22
      8.78767055852896E-09   8.78757454436886E-09  -5.06219936775430E-19  -3.88755676389893E-01  -3.88755676387485E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40826046053611E-09   0.00000000000000E+00  -2.40826046053611E-09
      2.19132535476475E-18  -5.84904540418017E-03  -3.83913397402397E-03   0.00000000000000E+00   1.47193624179405E-12
      1.78726857453469E-22  -6.38078602007475E-09  -6.37931408383278E-09  -1.68510541798932E-18
      1.14212386680163E-08
      0.00000000000000E+00  -8.73186285579398E-12   0.00000000000000E+00  -1.64989952603068E-13   1.09033044455980E-22
      8.73205287359500E-09   8.73188788364251E-09  -4.95946141041098E-19  -3.93176990207577E-01  -3.93176990205214E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.36351881605356E-09   0.00000000000000E+00  -2.36351881605356E-09
      2.15498071347070E-18  -5.64016962352790E-03  -3.63370603882702E-03   0.00000000000000E+00   1.37569991293438E-12
      1.69597782454485E-22  -6.36974476750188E-09  -6.36836906758878E-09  -1.65903457242960E-18
      1.14419980820788E-08
      0.00000000000000E+00  -8.62513927115884E-12   0.00000000000000E+00  -2.41042822001743E-13   9.92951855239550E-23
      8.62537601714088E-09   8.62513497431897E-09  -4.82832544824657E-19  -3.98818862342326E-01  -3.98818862340066E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.25942500917124E-09   0.00000000000000E+00  -2.25942500917124E-09
      2.10807637416215E-18  -5.39593240324432E-03  -3.39030589428787E-03   0.00000000000000E+00   1.24209894972505E-12
      1.55103122458579E-22  -6.36695206409761E-09  -6.36570996514773E-09  -1.62524382933749E-18
      1.14700232910631E-08
      0.00000000000000E+00  -8.41573327032568E-12   0.00000000000000E+00  -3.57425712011023E-13   8.49946965078449E-23
      8.41613932162116E-09   8.41578189590923E-09  -4.67040645015456E-19  -4.05611952803254E-01  -4.05611952801208E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.04579582132947E-09   0.00000000000000E+00  -2.04579582132947E-09
      2.05074251873003E-18  -5.12047685757246E-03  -3.11350219791659E-03   0.00000000000000E+00   1.06176634141673E-12
      1.33012018742655E-22  -6.37104784092130E-09  -6.36998607457975E-09  -1.58370187371457E-18
      1.15078573231921E-08
      0.00000000000000E+00  -7.95246841585091E-12   0.00000000000000E+00  -5.95842374355427E-13   6.54394433655481E-23
      7.95310998837242E-09   7.95251414599813E-09  -4.51518841170477E-19  -4.12330122945849E-01  -4.12330122944305E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.54342646053551E-09   0.00000000000000E+00  -1.54342646053551E-09
      1.99234847243352E-18  -4.84574424645796E-03  -2.82644890417599E-03   0.00000000000000E+00   7.05060661817664E-13
      1.01865626726870E-22  -6.40979274612454E-09  -6.40908768546262E-09  -1.54082963126305E-18
      1.15578573231921E-08
      0.00000000000000E+00  -6.59886067888638E-12   0.00000000000000E+00  -1.33443405227682E-12   4.13465365819331E-23
      6.60022785493375E-09   6.59889342088152E-09  -4.53119303494686E-19  -4.12085622437342E-01  -4.12085622437234E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07801272317019E-10   0.00000000000000E+00  -1.07801272317019E-10
      1.98695840881767E-18  -4.62682602597920E-03  -2.58169283117184E-03   0.00000000000000E+00  -1.17882016475554E-13
      6.24766447861409E-23  -6.49097426654811E-09  -6.49109214856452E-09  -1.53383910532299E-18
      1.16078573231921E-08
      0.00000000000000E+00  -4.06596651617721E-12   0.00000000000000E+00  -2.52979830003867E-12   1.75459948712051E-23
      4.06852293048616E-09   4.06599313218614E-09  -4.97062760612669E-19  -3.94710241340450E-01  -3.94710241342907E-01
      0.00000000000000E+00   0.00000000000000E+00   2.45697628266148E-09   0.00000000000000E+00   2.45697628266148E-09
      2.10980722295075E-18  -4.59079794350607E-03  -2.53561572390967E-03   0.00000000000000E+00  -1.62219235476347E-12
      2.20255353482806E-23  -6.52134722249290E-09  -6.52296941484764E-09  -1.61274446233808E-18
      1.16578573231921E-08
      0.00000000000000E+00  -1.32201314736514E-12   0.00000000000000E+00  -2.74757019593646E-12  -1.07149864032043E-23
      1.32475310352112E-09   1.32200553332517E-09  -5.94476083018614E-19  -3.55806604078426E-01  -3.55806604083566E-01
      0.00000000000000E+00   0.00000000000000E+00   5.13981491093846E-09   0.00000000000000E+00   5.13981491093846E-09
      2.36679796849767E-18  -5.35954206076515E-03  -3.32363293076019E-03   0.00000000000000E+00  -4.25046584763661E-12
     -2.89995596997583E-23  -6.45756997841594E-09  -6.46182044426361E-09  -1.77232188547906E-18
      1.17078573231921E-08
      0.00000000000000E+00   3.38631546084151E-13   0.00000000000000E+00  -1.71919011822213E-12  -3.36698068165045E-23
     -3.36853558157881E-10  -3.38572748276137E-10  -7.30155000590401E-19  -2.99468917357710E-01  -2.99468917364222E-01
      0.00000000000000E+00   0.00000000000000E+00   6.51224511964082E-09   0.00000000000000E+00   6.51224511964082E-09
      2.69241022447971E-18  -1.00400906704512E-02  -8.09497086226072E-03   0.00000000000000E+00  -8.53553326771123E-12
     -6.92153311881291E-23  -6.16513683809689E-09  -6.17367237136467E-09  -1.96225522388931E-18
      1.17578573231921E-08
      0.00000000000000E+00   1.45096315840451E-12   0.00000000000000E+00  -1.21710126533188E-12  -4.13074776005378E-23
     -1.44977349954281E-09  -1.45099060080819E-09  -8.67378386789703E-19  -2.37366893052489E-01  -2.37366893059147E-01
      0.00000000000000E+00   0.00000000000000E+00   6.65784185064500E-09   0.00000000000000E+00   6.65784185064500E-09
      3.02530231701196E-18  -2.82725344666832E-02  -2.66320300259650E-02   0.00000000000000E+00  -1.58393213281077E-11
     -8.11055717192004E-23  -5.19101192850866E-09  -5.20685124983685E-09  -2.15792393022226E-18
      1.17828573231921E-08
      0.00000000000000E+00   1.87941885747762E-12   0.00000000000000E+00  -9.93082526094270E-13  -4.26077824625863E-23
     -1.87833431142055E-09  -1.87932739394669E-09  -9.31555779202383E-19  -2.06282988572306E-01  -2.06282988578716E-01
      0.00000000000000E+00   0.00000000000000E+00   6.41028670240577E-09   0.00000000000000E+00   6.41028670240577E-09
      3.18555948457211E-18  -4.18884077404924E-02  -4.04608509390524E-02   0.00000000000000E+00  -2.37529984561956E-11
     -8.51151293774131E-23  -4.50720631000281E-09  -4.53095930845909E-09  -2.25400370536972E-18
      1.18166073231921E-08
      0.00000000000000E+00   2.13474722691454E-12   0.00000000000000E+00  -5.40121708415916E-13  -4.37535145073598E-23
     -2.13419790109880E-09  -2.13473802280726E-09  -1.01096579093628E-18  -1.65976131628765E-01  -1.65976131634812E-01
      0.00000000000000E+00   0.00000000000000E+00   6.04677074491933E-09   0.00000000000000E+00   6.04677074491933E-09
      3.38963799721313E-18  -6.42458815832170E-02  -6.30133266583461E-02   0.00000000000000E+00  -3.24495602423563E-11
     -9.14914620275877E-23  -3.87958316186961E-09  -3.91203272211206E-09  -2.37867220627686E-18
      1.18393885731921E-08
      0.00000000000000E+00   2.12877731899606E-12   0.00000000000000E+00  -1.75297357159493E-13  -4.44983585211047E-23
     -2.12862251018308E-09  -2.12879780754029E-09  -1.06113677525408E-18  -1.39472211360391E-01  -1.39472211366078E-01
      0.00000000000000E+00   0.00000000000000E+00   5.68680968264818E-09   0.00000000000000E+00   5.68680968264818E-09
      3.51919063029596E-18  -8.03750949552231E-02  -7.92540771995171E-02   0.00000000000000E+00  -4.14426202919494E-11
     -9.59815049858418E-23  -3.51656925481581E-09  -3.55801187510785E-09  -2.45805385504188E-18
      1.18547659169421E-08
      0.00000000000000E+00   2.07155804771577E-12   0.00000000000000E+00  -1.74152763231819E-14  -4.50037149665549E-23
     -2.07155514538839E-09  -2.07157256066476E-09  -1.09327613152595E-18  -1.22050910916017E-01  -1.22050910921435E-01
      0.00000000000000E+00   0.00000000000000E+00   5.41872982949374E-09   0.00000000000000E+00   5.41872982949374E-09
      3.60251630157247E-18  -9.15397428469663E-02  -9.04851562949745E-02   0.00000000000000E+00  -4.78220425916596E-11
     -9.90318005444826E-23  -3.29933522623713E-09  -3.34715726882889E-09  -2.50924017004651E-18
      1.18755253310046E-08
      0.00000000000000E+00   1.96621213413873E-12   0.00000000000000E+00   4.33280187735679E-14  -4.56631026507359E-23
     -1.96620881415166E-09  -1.96616548613293E-09  -1.13358712771192E-18  -9.96899562457958E-02  -9.96899562508818E-02
      0.00000000000000E+00   0.00000000000000E+00   5.08601761617660E-09   0.00000000000000E+00   5.08601761617660E-09
      3.70809904719585E-18  -1.06752883279744E-01  -1.05769913041525E-01   0.00000000000000E+00  -5.31863706715689E-11
     -1.03124831808446E-22  -3.06666575937208E-09  -3.11985213004375E-09  -2.57451191948393E-18
      1.19035505399889E-08
      0.00000000000000E+00   1.76185759385199E-12   0.00000000000000E+00   1.52492426454096E-13  -4.64636481282840E-23
     -1.76203498625300E-09  -1.76188249382659E-09  -1.18153173533968E-18  -7.23349231890415E-02  -7.23349231936309E-02
      0.00000000000000E+00   0.00000000000000E+00   4.58943912928737E-09   0.00000000000000E+00   4.58943912928737E-09
      3.83671903791519E-18  -1.27298531261424E-01  -1.26407654247394E-01   0.00000000000000E+00  -5.90252173988462E-11
     -1.08575407034848E-22  -2.76853141806179E-09  -2.82755663546075E-09  -2.65518730257551E-18
      1.19413845721178E-08
      0.00000000000000E+00   1.33459587636257E-12   0.00000000000000E+00   3.82260931637579E-13  -4.72554492206414E-23
     -1.33495990732113E-09  -1.33457764638954E-09  -1.22966826713495E-18  -4.39960503186534E-02  -4.39960503223673E-02
      0.00000000000000E+00   0.00000000000000E+00   3.71385191785637E-09   0.00000000000000E+00   3.71385191785637E-09
      3.97722903069737E-18  -1.55148264737751E-01  -1.54398628016080E-01   0.00000000000000E+00  -6.19526585153564E-11
     -1.15441830096444E-22  -2.31732161295135E-09  -2.37927427146682E-09  -2.74756076356242E-18
      1.19913845721178E-08
      0.00000000000000E+00   7.23001771297651E-13   0.00000000000000E+00   5.07121378915510E-13  -4.77548266832745E-23
     -7.23471868742286E-10  -7.22964747363418E-10  -1.26263109403108E-18  -2.40283502573185E-02  -2.40283502597908E-02
      0.00000000000000E+00   0.00000000000000E+00   2.47230249761377E-09   0.00000000000000E+00   2.47230249761377E-09
      4.10084415557806E-18  -1.90523753741951E-01  -1.89972591045293E-01   0.00000000000000E+00  -5.61198494943751E-11
     -1.22766732190888E-22  -1.69321790075584E-09  -1.74933775025034E-09  -2.83821306154698E-18
      1.20413845721178E-08
      0.00000000000000E+00   3.48275243490941E-13   0.00000000000000E+00   3.31783531640721E-13  -4.79345412611718E-23
     -3.48624213319260E-10  -3.48292429787667E-10  -1.27691720465536E-18  -1.52669175228235E-02  -1.52669175243944E-02
      0.00000000000000E+00   0.00000000000000E+00   1.57085829260507E-09   0.00000000000000E+00   1.57085829260507E-09
      4.17938707020831E-18  -2.20111513307787E-01  -2.19726320467348E-01   0.00000000000000E+00  -4.52255166533674E-11
     -1.28124087665720E-22  -1.17734034616391E-09  -1.22256586281740E-09  -2.90246986555295E-18
      1.20913845721178E-08
      0.00000000000000E+00   2.00680750798446E-13   0.00000000000000E+00   1.32211487542906E-13  -4.79988589652880E-23
     -2.00835525856474E-10  -2.00703314368980E-10  -1.28388806264157E-18  -1.11074127190041E-02  -1.11074127200486E-02
      0.00000000000000E+00   0.00000000000000E+00   1.04445081862789E-09   0.00000000000000E+00   1.04445081862789E-09
      4.23160961113971E-18  -2.41443830591181E-01  -2.41177993144483E-01   0.00000000000000E+00  -3.25529507375135E-11
     -1.31736239019933E-22  -8.11194553521267E-10  -8.43747504258912E-10  -2.94772154849814E-18
      1.21413845721178E-08
      0.00000000000000E+00   1.44012547941402E-13   0.00000000000000E+00   5.15219671827574E-14  -4.80211523425464E-23
     -1.44091956576210E-10  -1.44040434609075E-10  -1.28808112320136E-18  -8.79391931938198E-03  -8.79391932010992E-03
      0.00000000000000E+00   0.00000000000000E+00   7.27937938019948E-10   0.00000000000000E+00   7.27937938019948E-10
      4.26800650804070E-18  -2.55507795014794E-01  -2.55323830013017E-01   0.00000000000000E+00  -2.12383954876927E-11
     -1.34002092960694E-22  -5.62659107923045E-10  -5.83897503410871E-10  -2.97992538483935E-18
      1.21913845721178E-08
      0.00000000000000E+00   1.17377574151219E-13   0.00000000000000E+00   2.58475231037973E-14  -4.80243291846943E-23
     -1.17370444701018E-10  -1.17344597177962E-10  -1.29098886134302E-18  -7.33766260112742E-03  -7.33766260168753E-03
      0.00000000000000E+00   0.00000000000000E+00   5.60114915845645E-10   0.00000000000000E+00   5.60114915845645E-10
      4.29601225383298E-18  -2.65425133564574E-01  -2.65285634564150E-01   0.00000000000000E+00  -1.44284394128186E-11
     -1.35502024312680E-22  -4.28341879254756E-10  -4.42770318667710E-10  -3.00502339248996E-18
      1.22163845721178E-08
      0.00000000000000E+00   1.06264360949108E-13   0.00000000000000E+00   2.29413836760034E-14  -4.80218060056107E-23
     -1.06285963045808E-10  -1.06263021662180E-10  -1.29217753421623E-18  -6.78362217179985E-03  -6.78362217229429E-03
      0.00000000000000E+00   0.00000000000000E+00   4.94440036431019E-10   0.00000000000000E+00   4.94440036431019E-10
      4.30837325474376E-18  -2.69583443267832E-01  -2.69461145391829E-01   0.00000000000000E+00  -1.16897389196109E-11
     -1.36100988592295E-22  -3.76487275849058E-10  -3.88177014768805E-10  -3.01619572052753E-18
      1.22501345721178E-08
      0.00000000000000E+00   9.84575582864687E-14   0.00000000000000E+00   1.34169765101617E-14  -4.80153977936677E-23
     -9.84618872243770E-11  -9.84484702479149E-11  -1.29353982559554E-18  -6.17901422984648E-03  -6.17901423030829E-03
      0.00000000000000E+00   0.00000000000000E+00   4.61810513984964E-10   0.00000000000000E+00   4.61810513984964E-10
      4.32395935959075E-18  -2.74765971854410E-01  -2.74651492652883E-01   0.00000000000000E+00  -1.05640127985080E-11
     -1.36820925339118E-22  -3.52798030938388E-10  -3.63362043737033E-10  -3.03041953399521E-18
      1.22729158221178E-08
      0.00000000000000E+00   9.36816319516773E-14   0.00000000000000E+00   1.28459831298557E-14  -4.80097142421982E-23
     -9.36924091889311E-11  -9.36795632058493E-11  -1.29436029720117E-18  -5.83168041530705E-03  -5.83168041574399E-03
      0.00000000000000E+00   0.00000000000000E+00   4.36938388205016E-10   0.00000000000000E+00   4.36938388205016E-10
      4.33391336224705E-18  -2.77998082176613E-01  -2.77889937079251E-01   0.00000000000000E+00  -9.54366215841911E-12
     -1.37255975231063E-22  -3.33715162840669E-10  -3.43258824999226E-10  -3.03955306504588E-18
      1.22882931658678E-08
      0.00000000000000E+00   9.03752214122063E-14   0.00000000000000E+00   1.34629418656621E-14  -4.80052166106915E-23
     -9.03994544783245E-11  -9.03859915365069E-11  -1.29486781647928E-18  -5.62449718506279E-03  -5.62449718548693E-03
      0.00000000000000E+00   0.00000000000000E+00   4.24136861445190E-10   0.00000000000000E+00   4.24136861445190E-10
      4.34043546056254E-18  -2.80105413977527E-01  -2.80000264631609E-01   0.00000000000000E+00  -9.09740758135778E-12
     -1.37533963971622E-22  -3.24653462327165E-10  -3.33750869908660E-10  -3.04556764408326E-18
      1.23090525799303E-08
      0.00000000000000E+00   8.65177424494902E-14   0.00000000000000E+00   1.24313570978523E-14  -4.79982006261837E-23
     -8.65641696158764E-11  -8.65517382588266E-11  -1.29548139757223E-18  -5.38227554303028E-03  -5.38227554344961E-03
      0.00000000000000E+00   0.00000000000000E+00   4.19320739412122E-10   0.00000000000000E+00   4.19320739412122E-10
      4.34914031341699E-18  -2.82984954476316E-01  -2.82880114488833E-01   0.00000000000000E+00  -9.19438649245258E-12
     -1.37909841768272E-22  -3.23574614660786E-10  -3.32769001153376E-10  -3.05365891584476E-18
      1.23370777889147E-08
      0.00000000000000E+00   8.20173503263214E-14   0.00000000000000E+00   1.18189604620192E-14  -4.79872534434220E-23
     -8.20022734676973E-11  -8.19904545072832E-11  -1.29619693596087E-18  -5.10934977652526E-03  -5.10934977694683E-03
      0.00000000000000E+00   0.00000000000000E+00   4.21562498911059E-10   0.00000000000000E+00   4.21562498911059E-10
      4.36095469054895E-18  -2.87085468630747E-01  -2.86978485141483E-01   0.00000000000000E+00  -9.80466227326405E-12
     -1.38445026291830E-22  -3.29767382130380E-10  -3.39572044403782E-10  -3.06475775458807E-18
      1.23749118210436E-08
      0.00000000000000E+00   7.46697713497193E-14   0.00000000000000E+00   1.41814990336343E-14  -4.79688289065324E-23
     -7.46818708193155E-11  -7.46676893203298E-11  -1.29691598685835E-18  -4.83780342605904E-03  -4.83780342651859E-03
      0.00000000000000E+00   0.00000000000000E+00   4.59548451769277E-10   0.00000000000000E+00   4.59548451769277E-10
      4.37834126143797E-18  -2.94033013626919E-01  -2.93911754264400E-01   0.00000000000000E+00  -1.29910145961801E-11
     -1.39386120799995E-22  -3.71889747852634E-10  -3.84880762448953E-10  -3.08142527457963E-18
      1.24249118210436E-08
      0.00000000000000E+00   6.47505397313064E-14   0.00000000000000E+00   1.55475560002238E-14  -4.79380516652096E-23
     -6.47925885355438E-11  -6.47770409795916E-11  -1.29743294464597E-18  -4.62171862838259E-03  -4.62171862892173E-03
      0.00000000000000E+00   0.00000000000000E+00   5.39144570271076E-10   0.00000000000000E+00   5.39144570271076E-10
      4.40529848995153E-18  -3.06767991694962E-01  -3.06618536914108E-01   0.00000000000000E+00  -1.93840792685579E-11
     -1.41201579553013E-22  -4.54983450022788E-10  -4.74367529291487E-10  -3.10786554530556E-18
      1.24749118210436E-08
      0.00000000000000E+00   5.50149975873085E-14   0.00000000000000E+00   1.65481543831254E-14  -4.79010066790385E-23
     -5.50356009174377E-11  -5.50190527631025E-11  -1.29752853650976E-18  -4.59317887099577E-03  -4.59317887156452E-03
      0.00000000000000E+00   0.00000000000000E+00   5.68749284759002E-10   0.00000000000000E+00   5.68749284759002E-10
      4.43373595418948E-18  -3.21234036415474E-01  -3.21072179332065E-01   0.00000000000000E+00  -2.29153357232982E-11
     -1.43293855259075E-22  -4.90814896272437E-10  -5.13730231995878E-10  -3.13620741767972E-18
      1.25249118210436E-08
      0.00000000000000E+00   2.52573027320699E-14   0.00000000000000E+00   4.07661658934806E-14  -4.78391106533194E-23
     -2.52772094411462E-11  -2.52364432753005E-11  -1.29620985789592E-18  -5.39866118563010E-03  -5.39866118614303E-03
      0.00000000000000E+00   0.00000000000000E+00   5.12923479422538E-10   0.00000000000000E+00   5.12923479422538E-10
      4.45938212816061E-18  -3.35574301807132E-01  -3.35420650610358E-01   0.00000000000000E+00  -2.19639353933846E-11
     -1.45250125435477E-22  -4.65723100753725E-10  -4.87687036147254E-10  -3.16317227026469E-18
      1.25749118210436E-08
      0.00000000000000E+00  -1.13703784662918E-13   0.00000000000000E+00   1.70526690534048E-13  -4.76530925652235E-23
      1.13585816560155E-10   1.13756343250641E-10  -1.28806815326512E-18  -1.02562973520793E-02  -1.02562973523430E-02
      0.00000000000000E+00   0.00000000000000E+00   2.63699778863776E-10   0.00000000000000E+00   2.63699778863776E-10
      4.47256711710379E-18  -3.49596534446047E-01  -3.49477615343000E-01   0.00000000000000E+00  -1.42621758174534E-11
     -1.46502536814182E-22  -3.63193946296811E-10  -3.77456122114411E-10  -3.18449896383867E-18
      1.26249118210436E-08
      0.00000000000000E+00  -5.96531568162886E-13   0.00000000000000E+00   5.80183187990870E-13  -4.70398955676980E-23
      5.95921403976605E-10   5.96501587164549E-10  -1.25624764374698E-18  -2.88782487155002E-02  -2.88782487149671E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.33124240242983E-10   0.00000000000000E+00  -5.33124240242983E-10
      4.44591090509165E-18  -3.64519271945880E-01  -3.64499314654485E-01   0.00000000000000E+00   1.00879340767471E-11
     -1.45662994147701E-22  -7.34652809981847E-11  -6.33773469215832E-11  -3.18966326134466E-18
      1.26499118210436E-08
      0.00000000000000E+00  -9.31121945809906E-13   0.00000000000000E+00   8.00916647203792E-13  -4.65935928533974E-23
      9.30384327883161E-10   9.31185244530318E-10  -1.23224677794161E-18  -4.26319211161966E-02  -4.26319211151290E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.06760642516212E-09   0.00000000000000E+00  -1.06760642516212E-09
      4.41922074446259E-18  -3.72253700856378E-01  -3.72296697502537E-01   0.00000000000000E+00   2.53320292784619E-11
     -1.44578991141360E-22   1.11089151353529E-10   1.36421180631846E-10  -3.18697396652099E-18
      1.26836618210436E-08
      0.00000000000000E+00  -1.19398158369785E-12   0.00000000000000E+00   5.40854461721696E-13  -4.58911790875528E-23
      1.19345540431540E-09   1.19399625877708E-09  -1.19205813269518E-18  -6.50731428970364E-02  -6.50731428955813E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.45513276594432E-09   0.00000000000000E+00  -1.45513276594432E-09
      4.37011001361197E-18  -3.82573829520406E-01  -3.82656123477171E-01   0.00000000000000E+00   3.48405205457786E-11
     -1.42509259526022E-22   2.26295986621607E-10   2.61136507167243E-10  -3.17805188091679E-18
      1.27064430710436E-08
      0.00000000000000E+00  -1.34873996589253E-12   0.00000000000000E+00   4.87789704952824E-13  -4.53967187422096E-23
      1.34821872410388E-09   1.34870651380878E-09  -1.16235221331535E-18  -8.12291496387826E-02  -8.12291496371380E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.64454455529063E-09   0.00000000000000E+00  -1.64454455529063E-09
      4.33264523296175E-18  -3.89311115587305E-01  -3.89404345328153E-01   0.00000000000000E+00   3.80074471241927E-11
     -1.40940025292990E-22   2.57830594357843E-10   2.95838041481894E-10  -3.17029301964641E-18
      1.27218204147936E-08
      0.00000000000000E+00  -1.44940179787198E-12   0.00000000000000E+00   4.70048279336117E-13  -4.50530229054233E-23
      1.44893727860183E-09   1.44940732688112E-09  -1.14141805589374E-18  -9.24026296155057E-02  -9.24026296137635E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.74225969415900E-09   0.00000000000000E+00  -1.74225969415900E-09
      4.30585390674290E-18  -3.93714072508683E-01  -3.93806363665928E-01   0.00000000000000E+00   3.90263726041157E-11
     -1.39826555684221E-22   2.53825994673823E-10   2.92852367277799E-10  -3.16443585084917E-18
      1.27425798288561E-08
      0.00000000000000E+00  -1.57495355363467E-12   0.00000000000000E+00   4.37910048055052E-13  -4.45430823208969E-23
      1.57450342454382E-09   1.57494133459183E-09  -1.11237636068931E-18  -1.07618675431115E-01  -1.07618675429298E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.81649577641200E-09   0.00000000000000E+00  -1.81649577641200E-09
      4.26814451877758E-18  -3.99323786879804E-01  -3.99399919990703E-01   0.00000000000000E+00   3.95303934499170E-11
     -1.38262396367758E-22   2.02024048370393E-10   2.41554441820172E-10  -3.15576815808828E-18
      1.27706050378405E-08
      0.00000000000000E+00  -1.81476016248352E-12   0.00000000000000E+00   5.50402242719678E-13  -4.35558871183970E-23
      1.81421031950479E-09   1.81476072174747E-09  -1.07216442262516E-18  -1.28166443419568E-01  -1.28166443417664E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.90393977265246E-09   0.00000000000000E+00  -1.90393977265246E-09
      4.21478620875534E-18  -4.06054289912049E-01  -4.06082424069743E-01   0.00000000000000E+00   4.00627390045645E-11
     -1.36035635586010E-22   4.91163119006015E-11   8.91790509050300E-11  -3.14262178613018E-18
      1.28084390699694E-08
      0.00000000000000E+00  -2.44003913339236E-12   0.00000000000000E+00   9.29580336866464E-13  -4.03425716586255E-23
      2.43912749149774E-09   2.44005707183457E-09  -1.01572750621819E-18  -1.56024445817228E-01  -1.56024445815151E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.07647892513603E-09   0.00000000000000E+00  -2.07647892513603E-09
      4.13622463838674E-18  -4.12614495803226E-01  -4.12500006191283E-01   0.00000000000000E+00   4.25225002470269E-11
     -1.32647475408724E-22  -4.06100646945431E-10  -3.63578146698536E-10  -3.12049713216855E-18
      1.28584390699694E-08
      0.00000000000000E+00  -4.19950876407695E-12   0.00000000000000E+00   1.82801071441085E-12  -2.61469429430126E-23
      4.19764897023829E-09   4.19947698095268E-09  -9.40807126933047E-19  -1.91319269533036E-01  -1.91319269530684E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.35210188593066E-09   0.00000000000000E+00  -2.35210188593066E-09
      4.01861954409021E-18  -4.11897178857776E-01  -4.11315259702791E-01   0.00000000000000E+00   4.84517983433680E-11
     -1.27040566647639E-22  -1.89582689336527E-09  -1.84737509502203E-09  -3.07781241715716E-18
      1.29084390699694E-08
      0.00000000000000E+00  -7.20420934182119E-12   0.00000000000000E+00   3.02695135676305E-12   7.22491784784035E-24
      7.20116063437021E-09   7.20418758572698E-09  -8.75605091306878E-19  -2.20723949759578E-01  -2.20723949756997E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.58069502622162E-09   0.00000000000000E+00  -2.58069502622162E-09
      3.88958479277913E-18  -3.93788617212431E-01  -3.92332122297430E-01   0.00000000000000E+00   5.42071518097858E-11
     -1.19985134027414E-22  -4.67769971131497E-09  -4.62349255950530E-09  -3.01397970147225E-18
      1.29584390699694E-08
      0.00000000000000E+00  -1.04212549519892E-11   0.00000000000000E+00   3.21211657410462E-12   4.63690335885970E-23
      1.04180678987783E-08   1.04212800153525E-08  -8.27943741495010E-19  -2.41861168508371E-01  -2.41861168505626E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.74508571686232E-09   0.00000000000000E+00  -2.74508571686232E-09
      3.75233050693601E-18  -3.54141457495063E-01  -3.51723202536486E-01   0.00000000000000E+00   5.64773553447985E-11
     -1.11963150789140E-22  -7.73267165383486E-09  -7.67619429849017E-09  -2.92438676544100E-18
      1.30084390699694E-08
      0.00000000000000E+00  -1.24234702231133E-11   0.00000000000000E+00   1.99790291642079E-12   7.24026210753257E-23
      1.24214819483610E-08   1.24234798512775E-08  -7.97411784083256E-19  -2.55785956141611E-01  -2.55785956138748E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86293647200635E-09   0.00000000000000E+00  -2.86293647200635E-09
      3.60918368333570E-18  -2.97372832856903E-01  -2.94360856011035E-01   0.00000000000000E+00   5.12375581531728E-11
     -1.04045489570782E-22  -9.61178093742423E-09  -9.56054337927116E-09  -2.81177189925244E-18
      1.30584390699694E-08
      0.00000000000000E+00  -1.32023135946331E-11   0.00000000000000E+00   7.82226276970085E-13   8.25158922448268E-23
      1.32015079431542E-08   1.32022901694312E-08  -7.77165027989096E-19  -2.65642528345863E-01  -2.65642528342960E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90291167882371E-09   0.00000000000000E+00  -2.90291167882371E-09
      3.46403809939451E-18  -2.35262654433724E-01  -2.32017837328650E-01   0.00000000000000E+00   3.91267161533366E-11
     -9.58959176921562E-23  -1.03385052067607E-08  -1.02993784906075E-08  -2.68687307140541E-18
      1.30834390699694E-08
      0.00000000000000E+00  -1.32681662712109E-11   0.00000000000000E+00   1.40625753845089E-13   8.34541746348278E-23
      1.32680256891348E-08   1.32681663148887E-08  -7.69103946160312E-19  -2.69781475267671E-01  -2.69781475264756E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.91533510383285E-09   0.00000000000000E+00  -2.91533510383285E-09
      3.39115472179869E-18  -2.04220329337642E-01  -2.00958639786729E-01   0.00000000000000E+00   3.09059995028326E-11
     -9.20051192281224E-23  -1.03837372105586E-08  -1.03528312110559E-08  -2.62205077563837E-18
      1.31171890699694E-08
      0.00000000000000E+00  -1.32723911291225E-11   0.00000000000000E+00   1.46068627731765E-14   8.22033868949416E-23
      1.32723989095281E-08   1.32724135163910E-08  -7.59445158370065E-19  -2.74946949343414E-01  -2.74946949340526E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.88807168237825E-09   0.00000000000000E+00  -2.88807168237825E-09
      3.29368230251842E-18  -1.63985013107053E-01  -1.60713362821234E-01   0.00000000000000E+00   2.49642408210085E-11
     -8.79553404497649E-23  -1.04093060748337E-08  -1.03843418340128E-08  -2.53423714414836E-18
      1.31399703199694E-08
      0.00000000000000E+00  -1.31615345313130E-11   0.00000000000000E+00  -2.32440814050327E-13   8.01975942429425E-23
      1.31617573238243E-08   1.31615248830103E-08  -7.53660905328489E-19  -2.78171911860296E-01  -2.78171911857420E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.87564157948314E-09   0.00000000000000E+00  -2.87564157948314E-09
      3.22817159278582E-18  -1.37546523254987E-01  -1.34305874289491E-01   0.00000000000000E+00   2.10670285977692E-11
     -8.56217289877329E-23  -1.03069503321248E-08  -1.02858833035271E-08  -2.47451068745733E-18
      1.31553476637194E-08
      0.00000000000000E+00  -1.30538006545686E-11   0.00000000000000E+00  -3.38595046150708E-13   7.85812785074226E-23
      1.30541132930017E-08   1.30537746979556E-08  -7.49973199995659E-19  -2.80276629797657E-01  -2.80276629794793E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86389053229114E-09   0.00000000000000E+00  -2.86389053229114E-09
      3.18413256360841E-18  -1.20181982104459E-01  -1.16971567340642E-01   0.00000000000000E+00   1.87359107357695E-11
     -8.39445018336103E-23  -1.02086200764001E-08  -1.01898841656645E-08  -2.43415936361275E-18
      1.31761070777819E-08
      0.00000000000000E+00  -1.29130945171666E-11   0.00000000000000E+00  -3.27330664818621E-13   7.67006732844601E-23
      1.29134316655958E-08   1.29131043349310E-08  -7.44942224816940E-19  -2.83156582670714E-01  -2.83156582667878E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.83579928987912E-09   0.00000000000000E+00  -2.83579928987912E-09
      3.12526303195167E-18  -9.79243871329391E-02  -9.47494285308383E-02   0.00000000000000E+00   1.64611158855373E-11
     -8.10846133712881E-23  -1.00937661609373E-08  -1.00773050450519E-08  -2.38032080713473E-18
      1.32041322867663E-08
      0.00000000000000E+00  -1.26320496213116E-11   0.00000000000000E+00  -4.86612434760060E-13   7.48427298020439E-23
      1.26325530125053E-08   1.26320664000706E-08  -7.37592541692068E-19  -2.87273474948330E-01  -2.87273474945543E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.78706601671786E-09   0.00000000000000E+00  -2.78706601671786E-09
      3.04715492437990E-18  -7.07990665392475E-02  -6.76972833634547E-02   0.00000000000000E+00   1.36396071807483E-11
     -7.27147976906975E-23  -9.85863999053342E-09  -9.84500038335275E-09  -2.30956238268783E-18
      1.32419663188952E-08
      0.00000000000000E+00  -1.19049148368396E-11   0.00000000000000E+00  -9.36203438939426E-13   7.62736625664797E-23
      1.19057936690999E-08   1.19048574656611E-08  -7.23709097859912E-19  -2.94290582780856E-01  -2.94290582778186E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.66990897970361E-09   0.00000000000000E+00  -2.66990897970361E-09
      2.94614150226054E-18  -4.29789572036390E-02  -4.00693640912139E-02   0.00000000000000E+00   1.00354726362517E-11
     -3.99223332994211E-23  -9.24498395859368E-09  -9.23494848595747E-09  -2.22243240440063E-18
      1.32919663188952E-08
      0.00000000000000E+00  -1.06477440739430E-11   0.00000000000000E+00  -1.22259050733119E-12   8.91663448013116E-23
      1.06489286649156E-08   1.06477060744083E-08  -6.95404908888568E-19  -3.07102884436968E-01  -3.07102884434516E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.45265798782585E-09   0.00000000000000E+00  -2.45265798782585E-09
      2.82350860286924E-18  -2.35800644023289E-02  -2.09980953415176E-02   0.00000000000000E+00   6.26832841384593E-12
      3.45550986677758E-23  -8.20131641499638E-09  -8.19504808658250E-09  -2.12810369398068E-18
      1.33419663188952E-08
      0.00000000000000E+00  -9.66656674635498E-12   0.00000000000000E+00  -9.48894204706152E-13   1.07221794563884E-22
      9.66748730002447E-09   9.66653840581988E-09  -6.62050467950938E-19  -3.21581918018223E-01  -3.21581918015953E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.27034859777113E-09   0.00000000000000E+00  -2.27034859777113E-09
      2.70999117298069E-18  -1.50682286807573E-02  -1.27379457382910E-02   0.00000000000000E+00   3.88739637363094E-12
      1.01987577662402E-22  -7.40007720442247E-09  -7.39618980804874E-09  -2.04794070502975E-18
      1.33919663188952E-08
      0.00000000000000E+00  -9.07471925978968E-12   0.00000000000000E+00  -5.66211073284719E-13   1.21819781159345E-22
      9.07532326692952E-09   9.07475705585636E-09  -6.28784989227541E-19  -3.35911022879920E-01  -3.35911022877766E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.15451530322649E-09   0.00000000000000E+00  -2.15451530322649E-09
      2.60226540781936E-18  -1.10034182241578E-02  -8.82308646516991E-03   0.00000000000000E+00   2.65234542998383E-12
      1.50101450182492E-22  -6.92289409805999E-09  -6.92024175262986E-09  -1.97348041859182E-18
      1.34419663188952E-08
      0.00000000000000E+00  -8.76005919011669E-12   0.00000000000000E+00  -2.94351547748696E-13   1.29513488649716E-22
      8.76036807385345E-09   8.76007372230583E-09  -5.96317159412745E-19  -3.49937515621622E-01  -3.49937515619494E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.12774766873637E-09   0.00000000000000E+00  -2.12774766873637E-09
      2.49587802438254E-18  -8.73088528396762E-03  -6.64126341190671E-03   0.00000000000000E+00   2.06323436564321E-12
      1.79139222072219E-22  -6.63438928793526E-09  -6.63232605356944E-09  -1.89956086496980E-18
      1.34919663188952E-08
      0.00000000000000E+00  -8.77998949809073E-12   0.00000000000000E+00   3.55375038337909E-14   1.31282393749264E-22
      8.77994584741866E-09   8.77998138492262E-09  -5.61690450420486E-19  -3.64890062554089E-01  -3.64890062551792E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.29665580471619E-09   0.00000000000000E+00  -2.29665580471619E-09
      2.38104523414674E-18  -7.29543661798998E-03  -5.25275769635897E-03   0.00000000000000E+00   1.83481343413272E-12
      1.93478048538942E-22  -6.48516039364078E-09  -6.48332558020645E-09  -1.81935478372625E-18
      1.35169663188952E-08
      0.00000000000000E+00  -8.84097440359653E-12   0.00000000000000E+00   1.36145689553250E-13   1.29123959458693E-22
      8.84088440113264E-09   8.84102054682232E-09  -5.43712944347905E-19  -3.72627275343016E-01  -3.72627275340599E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.41646640888992E-09   0.00000000000000E+00  -2.41646640888992E-09
      2.32063357392449E-18  -6.74754299904413E-03  -4.72338000209217E-03   0.00000000000000E+00   1.74178389460741E-12
      1.94300523580248E-22  -6.42629592182721E-09  -6.42455413793241E-09  -1.77692062957658E-18
      1.35507163188952E-08
      0.00000000000000E+00  -8.83261653251064E-12   0.00000000000000E+00   3.07334541060867E-15   1.21749254120964E-22
      8.83266010505735E-09   8.83266317840288E-09  -5.19773223153542E-19  -3.82933544493231E-01  -3.82933544490797E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.43406137335854E-09   0.00000000000000E+00  -2.43406137335854E-09
      2.23848400257364E-18  -6.14966345436574E-03  -4.13367584847040E-03   0.00000000000000E+00   1.56643699560211E-12
      1.86944381149235E-22  -6.40016824204015E-09  -6.39860180504437E-09  -1.71871077942009E-18
      1.35734975688952E-08
      0.00000000000000E+00  -8.77668308755126E-12   0.00000000000000E+00  -1.06851265322802E-13   1.13829943208115E-22
      8.77682215259901E-09   8.77671530133381E-09  -5.04152416604824E-19  -3.89655692006132E-01  -3.89655692003733E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.39909986737166E-09   0.00000000000000E+00  -2.39909986737166E-09
      2.18382950872008E-18  -5.80638942940892E-03  -3.79701307493422E-03   0.00000000000000E+00   1.45614312578988E-12
      1.76395085171329E-22  -6.37907157708807E-09  -6.37761543396211E-09  -1.67967709211525E-18
      1.35888749126452E-08
      0.00000000000000E+00  -8.71771876626403E-12   0.00000000000000E+00  -1.75766308814149E-13   1.07290322138357E-22
      8.71788860829614E-09   8.71771284198743E-09  -4.93947466417948E-19  -3.94045894266236E-01  -3.94045894263886E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.35050963329586E-09   0.00000000000000E+00  -2.35050963329586E-09
      2.14768491410120E-18  -5.60167015170065E-03  -3.59557378215937E-03   0.00000000000000E+00   1.35884028204388E-12
      1.66986912923102E-22  -6.36856204897382E-09  -6.36720320869161E-09  -1.65373744768325E-18
      1.36096343267077E-08
      0.00000000000000E+00  -8.60603556581967E-12   0.00000000000000E+00  -2.52949942005074E-13   9.74320839045256E-23
      8.60626679905492E-09   8.60601384911301E-09  -4.80955798620783E-19  -3.99633220055097E-01  -3.99633220052856E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.24079832286613E-09   0.00000000000000E+00  -2.24079832286613E-09
      2.10116725388627E-18  -5.36239823406842E-03  -3.35692740403041E-03   0.00000000000000E+00   1.22371017586723E-12
      1.52228873268775E-22  -6.36643923642287E-09  -6.36521552624685E-09  -1.62021145526548E-18
      1.36376595356921E-08
      0.00000000000000E+00  -8.38808800442621E-12   0.00000000000000E+00  -3.72667895163616E-13   8.30848770007942E-23
      8.38848054743864E-09   8.38810787954356E-09  -4.65407249984266E-19  -4.06319865083540E-01  -4.06319865081523E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.01681548480030E-09   0.00000000000000E+00  -2.01681548480030E-09
      2.04464557844181E-18  -5.09322778814784E-03  -3.08584145523491E-03   0.00000000000000E+00   1.03813844164007E-12
      1.29987253041410E-22  -6.37233053318501E-09  -6.37129239474324E-09  -1.57923832845755E-18
      1.36754935678210E-08
      0.00000000000000E+00  -7.90140274196353E-12   0.00000000000000E+00  -6.26683358411546E-13   6.36204029469050E-23
      7.90203489520490E-09   7.90140821184656E-09  -4.50524927931442E-19  -4.12768123556044E-01  -4.12768123554557E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48699040553144E-09   0.00000000000000E+00  -1.48699040553144E-09
      1.98838673566356E-18  -4.82640344141469E-03  -2.80542866939478E-03   0.00000000000000E+00   6.67235914999622E-13
      9.89189494771350E-23  -6.41508504223024E-09  -6.41441780631514E-09  -1.53786180773212E-18
      1.37254935678210E-08
      0.00000000000000E+00  -6.47725824682362E-12   0.00000000000000E+00  -1.40467106817302E-12   3.97153773362140E-23
      6.47862438213674E-09   6.47721971106861E-09  -4.54094281529660E-19  -4.11716788676519E-01  -4.11716788676537E-01
      0.00000000000000E+00   0.00000000000000E+00   1.84123025867715E-11   0.00000000000000E+00   1.84123025867715E-11
      1.98930735079290E-18  -4.61464073237430E-03  -2.56807712914778E-03   0.00000000000000E+00  -1.86403680554262E-13
      5.97745629626356E-23  -6.49544560997484E-09  -6.49563201365533E-09  -1.53521306926324E-18
      1.37754935678210E-08
      0.00000000000000E+00  -3.88879801810389E-12   0.00000000000000E+00  -2.59063792970944E-12   1.58786230729316E-23
      3.89139031069550E-09   3.88879967276580E-09  -5.01140733436646E-19  -3.93095485736159E-01  -3.93095485738793E-01
      0.00000000000000E+00   0.00000000000000E+00   2.63358949914670E-09   0.00000000000000E+00   2.63358949914670E-09
      2.12098682575024E-18  -4.59850316894851E-03  -2.54350226362811E-03   0.00000000000000E+00  -1.73764048038541E-12
      1.91077001690840E-23  -6.52065153143215E-09  -6.52238917191252E-09  -1.61984609231359E-18
      1.38254935678210E-08
      0.00000000000000E+00  -1.18415419681664E-12   0.00000000000000E+00  -2.71089860316181E-12  -1.25009013362213E-23
      1.18680849243313E-09   1.18409759382996E-09  -6.01605861930515E-19  -3.52933820640526E-01  -3.52933820645797E-01
      0.00000000000000E+00   0.00000000000000E+00   5.27006538099334E-09   0.00000000000000E+00   5.27006538099334E-09
      2.38449009479990E-18  -5.46479895335396E-03  -3.43130258437712E-03   0.00000000000000E+00  -4.45047053776784E-12
     -3.22064765936318E-23  -6.44971250428555E-09  -6.45416297482334E-09  -1.78288423286939E-18
      1.38754935678210E-08
      0.00000000000000E+00   4.07698788464211E-13   0.00000000000000E+00  -1.65384462236526E-12  -3.45001407095767E-23
     -4.05990443624955E-10  -4.07644288247355E-10  -7.38481880648820E-19  -2.95875312354377E-01  -2.95875312360926E-01
      0.00000000000000E+00   0.00000000000000E+00   6.54811867019686E-09   0.00000000000000E+00   6.54811867019686E-09
      2.71189602830974E-18  -1.06144294853613E-02  -8.67976948362853E-03   0.00000000000000E+00  -8.86063819418568E-12
     -7.05168094917947E-23  -6.13161374375520E-09  -6.14047438194946E-09  -1.97341414766093E-18
      1.39254935678210E-08
      0.00000000000000E+00   1.51461156128932E-12   0.00000000000000E+00  -1.21365632148120E-12  -4.14972258096938E-23
     -1.51337562542607E-09  -1.51458928174760E-09  -8.74949658556603E-19  -2.33767094020832E-01  -2.33767094027479E-01
      0.00000000000000E+00   0.00000000000000E+00   6.64718601183734E-09   0.00000000000000E+00   6.64718601183734E-09
      3.04425532890161E-18  -2.98488192961596E-02  -2.82317099377326E-02   0.00000000000000E+00  -1.64075671843178E-11
     -8.15430840178689E-23  -5.11618916290536E-09  -5.13259673008975E-09  -2.16930567034501E-18
      1.39504935678210E-08
      0.00000000000000E+00   1.91661597604667E-12   0.00000000000000E+00  -9.43316992569416E-13  -4.27175341977376E-23
     -1.91567800395645E-09  -1.91662132094906E-09  -9.38667739608600E-19  -2.02755219208349E-01  -2.02755219214733E-01
      0.00000000000000E+00   0.00000000000000E+00   6.38384284397007E-09   0.00000000000000E+00   6.38384284397007E-09
      3.20385140000086E-18  -4.38144302703888E-02  -4.24069549295105E-02   0.00000000000000E+00  -2.45632944887210E-11
     -8.56461307172979E-23  -4.44265822853225E-09  -4.46722152302106E-09  -2.26518366039227E-18
      1.39842435678210E-08
      0.00000000000000E+00   2.14181927167952E-12   0.00000000000000E+00  -4.97972778283968E-13  -4.38476736708325E-23
     -2.14129261118254E-09  -2.14179058396087E-09  -1.01750250387410E-18  -1.62570933373130E-01  -1.62570933379138E-01
      0.00000000000000E+00   0.00000000000000E+00   6.00802740524672E-09   0.00000000000000E+00   6.00802740524672E-09
      3.40662232492794E-18  -6.63822496137937E-02  -6.51641232761996E-02   0.00000000000000E+00  -3.33524122394754E-11
     -9.20733644390844E-23  -3.83288440904627E-09  -3.86623682128584E-09  -2.38911982105384E-18
      1.40070248178210E-08
      0.00000000000000E+00   2.12326663476360E-12   0.00000000000000E+00  -1.49894246853165E-13  -4.45933367151697E-23
     -2.12309517330865E-09  -2.12324506755555E-09  -1.06726504090977E-18  -1.36179432692415E-01  -1.36179432698058E-01
      0.00000000000000E+00   0.00000000000000E+00   5.64319759526227E-09   0.00000000000000E+00   5.64319759526227E-09
      3.53518142014501E-18  -8.25780721857670E-02  -8.14690454910746E-02   0.00000000000000E+00  -4.23994138857614E-11
     -9.65661441814228E-23  -3.47755311382095E-09  -3.51995252770681E-09  -2.46791637923524E-18
      1.40224021615710E-08
      0.00000000000000E+00   2.05980192135320E-12   0.00000000000000E+00   9.10344907344950E-16  -4.50977269568781E-23
     -2.05980773024334E-09  -2.05980681989848E-09  -1.09910455778842E-18  -1.18855763552799E-01  -1.18855763558172E-01
      0.00000000000000E+00   0.00000000000000E+00   5.37245250408930E-09   0.00000000000000E+00   5.37245250408930E-09
      3.61779546908094E-18  -9.37642828298288E-02  -9.27205695883975E-02   0.00000000000000E+00  -4.87650554715875E-11
     -9.96161942785805E-23  -3.26388062871910E-09  -3.31264568419079E-09  -2.51869091129252E-18
      1.40431615756335E-08
      0.00000000000000E+00   1.94793503143444E-12   0.00000000000000E+00   5.77398600443077E-14  -4.57522258457492E-23
     -1.94798740647941E-09  -1.94792966661942E-09  -1.13895276766729E-18  -9.66730652356070E-02  -9.66730652406425E-02
      0.00000000000000E+00   0.00000000000000E+00   5.03548957147661E-09   0.00000000000000E+00   5.03548957147661E-09
      3.72232928210262E-18  -1.08984103722466E-01  -1.08011307606518E-01   0.00000000000000E+00  -5.40440754254838E-11
     -1.03708217056776E-22  -3.03351582943164E-09  -3.08755990485723E-09  -2.58337651443534E-18
      1.40711867846178E-08
      0.00000000000000E+00   1.73329388058044E-12   0.00000000000000E+00   1.71528414657145E-13  -4.65390143709146E-23
     -1.73346266570334E-09  -1.73329113728873E-09  -1.18605132803593E-18  -6.97157352528974E-02  -6.97157352574241E-02
      0.00000000000000E+00   0.00000000000000E+00   4.52670183223261E-09   0.00000000000000E+00   4.52670183223261E-09
      3.84919104696090E-18  -1.29535800732423E-01  -1.28655681945908E-01   0.00000000000000E+00  -5.96433636791280E-11
     -1.09147932627079E-22  -2.73376733126463E-09  -2.79341069494387E-09  -2.66313971892496E-18
      1.41090208167468E-08
      0.00000000000000E+00   1.29179622882386E-12   0.00000000000000E+00   4.05204252692738E-13  -4.73013447743655E-23
     -1.29219525846060E-09  -1.29179005420795E-09  -1.23255687197936E-18  -4.22690789066523E-02  -4.22690789102819E-02
      0.00000000000000E+00   0.00000000000000E+00   3.62954707734966E-09   0.00000000000000E+00   3.62954707734966E-09
      3.98651144769872E-18  -1.57406585931144E-01  -1.56670029940377E-01   0.00000000000000E+00  -6.19615550906612E-11
     -1.15951902484763E-22  -2.27579546805091E-09  -2.33775702314169E-09  -2.75395457571936E-18
      1.41590208167468E-08
      0.00000000000000E+00   6.90029510640148E-13   0.00000000000000E+00   5.02236296883051E-13  -4.77719103709381E-23
     -6.90546571425212E-10  -6.90044335128377E-10  -1.26387538830859E-18  -2.32689765408970E-02  -2.32689765432986E-02
      0.00000000000000E+00   0.00000000000000E+00   2.40167268543503E-09   0.00000000000000E+00   2.40167268543503E-09
      4.10659508197047E-18  -1.92567716225953E-01  -1.92028434571655E-01   0.00000000000000E+00  -5.55602345146765E-11
     -1.23153247530630E-22  -1.65606811579187E-09  -1.71162835030667E-09  -2.84271969366188E-18
      1.42090208167468E-08
      0.00000000000000E+00   3.34498532909812E-13   0.00000000000000E+00   3.15180047410042E-13  -4.79405972202087E-23
     -3.34827785137795E-10  -3.34512605090433E-10  -1.27747610169592E-18  -1.49303617213031E-02  -1.49303617228331E-02
      0.00000000000000E+00   0.00000000000000E+00   1.53003337320220E-09   0.00000000000000E+00   1.53003337320220E-09
      4.18309675063058E-18  -2.21678624125312E-01  -2.21301952421140E-01   0.00000000000000E+00  -4.44719472599845E-11
     -1.28395454450490E-22  -1.15104882085161E-09  -1.19552076811172E-09  -2.90562064893466E-18
      1.42590208167468E-08
      0.00000000000000E+00   1.95721134989240E-13   0.00000000000000E+00   1.24345050653086E-13  -4.80011742878915E-23
     -1.95846876571374E-10  -1.95722531520769E-10  -1.28420107568877E-18  -1.09314192379117E-02  -1.09314192389320E-02
      0.00000000000000E+00   0.00000000000000E+00   1.02029377199721E-09   0.00000000000000E+00   1.02029377199721E-09
      4.23411143923044E-18  -2.42506485205282E-01  -2.42246689714279E-01   0.00000000000000E+00  -3.17915768977238E-11
     -1.31912146002961E-22  -7.92779663578580E-10  -8.24571240476436E-10  -2.94991036354167E-18
      1.43090208167468E-08
      0.00000000000000E+00   1.41900118985629E-13   0.00000000000000E+00   4.89945777415472E-14  -4.80219383451842E-23
     -1.41994174965839E-10  -1.41945180388145E-10  -1.28829200423380E-18  -8.68750057701979E-03  -8.68750057773360E-03
      0.00000000000000E+00   0.00000000000000E+00   7.13818492292045E-10   0.00000000000000E+00   7.13818492292045E-10
      4.26980236384504E-18  -2.56213732242516E-01  -2.56033555787906E-01   0.00000000000000E+00  -2.06705557948554E-11
     -1.34113343502586E-22  -5.51202756108907E-10  -5.71873311903897E-10  -2.98151035961124E-18
      1.43590208167468E-08
      0.00000000000000E+00   1.16183592567521E-13   0.00000000000000E+00   2.50669488763181E-14  -4.80243082446560E-23
     -1.16226299543241E-10  -1.16201232594413E-10  -1.29114500886642E-18  -7.26658682118344E-03  -7.26658682173705E-03
      0.00000000000000E+00   0.00000000000000E+00   5.53618099475023E-10   0.00000000000000E+00   5.53618099475023E-10
      4.29748326881879E-18  -2.65977012114537E-01  -2.65839199870204E-01   0.00000000000000E+00  -1.41690582342926E-11
     -1.35584065764730E-22  -4.23247808646211E-10  -4.37416866880640E-10  -3.00633825995237E-18
      1.43840208167468E-08
      0.00000000000000E+00   1.05529603051448E-13   0.00000000000000E+00   2.21742434767965E-14  -4.80215705855198E-23
     -1.05574237639487E-10  -1.05552063396058E-10  -1.29231709127372E-18  -6.72294569447108E-03  -6.72294569496143E-03
      0.00000000000000E+00   0.00000000000000E+00   4.90352286058841E-10   0.00000000000000E+00   4.90352286058841E-10
      4.30974207597027E-18  -2.70086050476948E-01  -2.69964816558714E-01   0.00000000000000E+00  -1.15238803046132E-11
     -1.36173753967571E-22  -3.73276342358015E-10  -3.84800222662765E-10  -3.01742498469654E-18
      1.44177708167468E-08
      0.00000000000000E+00   9.78146451260160E-14   0.00000000000000E+00   1.33343665919808E-14  -4.80149001282229E-23
     -9.78547378004397E-11  -9.78414034338957E-11  -1.29366046037322E-18  -6.12976285242383E-03  -6.12976285288273E-03
      0.00000000000000E+00   0.00000000000000E+00   4.58899580136149E-10   0.00000000000000E+00   4.58899580136149E-10
      4.32522993679986E-18  -2.75225117780992E-01  -2.75111364481523E-01   0.00000000000000E+00  -1.04520051569830E-11
     -1.36885178293892E-22  -3.50606171545096E-10  -3.61058176702216E-10  -3.03156947642665E-18
      1.44405520667468E-08
      0.00000000000000E+00   9.31305635284321E-14   0.00000000000000E+00   1.28233763696622E-14  -4.80090526642668E-23
     -9.31256505612787E-11  -9.31128271849570E-11  -1.29446907483986E-18  -5.78932078168647E-03  -5.78932078212128E-03
      0.00000000000000E+00   0.00000000000000E+00   4.34803445574776E-10   0.00000000000000E+00   4.34803445574776E-10
      4.33513530279436E-18  -2.78439228018212E-01  -2.78331577031916E-01   0.00000000000000E+00  -9.47113875833186E-12
     -1.37316401858403E-22  -3.32219479631381E-10  -3.41690618389850E-10  -3.04066622795450E-18
      1.44559294104968E-08
      0.00000000000000E+00   8.98241529889612E-14   0.00000000000000E+00   1.34077250129796E-14  -4.80044540392784E-23
     -8.98684880630605E-11  -8.98550803380955E-11  -1.29496914333924E-18  -5.58631515680599E-03  -5.58631515722858E-03
      0.00000000000000E+00   0.00000000000000E+00   4.22590419037433E-10   0.00000000000000E+00   4.22590419037433E-10
      4.34163362093336E-18  -2.80540184517513E-01  -2.80435355145794E-01   0.00000000000000E+00  -9.05677189356868E-12
     -1.37592807453304E-22  -3.23678566805596E-10  -3.32735338699302E-10  -3.04666447759412E-18
      1.44766888245593E-08
      0.00000000000000E+00   8.60585187634526E-14   0.00000000000000E+00   1.24158890441841E-14  -4.79973101086408E-23
     -8.60630819757752E-11  -8.60506660867790E-11  -1.29557329741861E-18  -5.34909694830619E-03  -5.34909694872472E-03
      0.00000000000000E+00   0.00000000000000E+00   4.18532817217650E-10   0.00000000000000E+00   4.18532817217650E-10
      4.35032211698472E-18  -2.83421656010015E-01  -2.83316906403635E-01   0.00000000000000E+00  -9.19796723762077E-12
     -1.37968356914052E-22  -3.23284183893135E-10  -3.32482151130894E-10  -3.05474881956611E-18
      1.45047140335436E-08
      0.00000000000000E+00   8.14662819030762E-14   0.00000000000000E+00   1.19670689575628E-14  -4.79861592959287E-23
     -8.14537389258165E-11  -8.14417718569069E-11  -1.29627484996584E-18  -5.08256936316445E-03  -5.08256936358723E-03
      0.00000000000000E+00   0.00000000000000E+00   4.22788563420132E-10   0.00000000000000E+00   4.22788563420132E-10
      4.36217085483078E-18  -2.87567703131805E-01  -2.87460160454246E-01   0.00000000000000E+00  -9.94041229474210E-12
     -1.38510150221629E-22  -3.31406379268289E-10  -3.41346791563169E-10  -3.06589600486494E-18
      1.45425480656725E-08
      0.00000000000000E+00   7.40268581892666E-14   0.00000000000000E+00   1.44338771536253E-14  -4.79673713624895E-23
     -7.40057262205049E-11  -7.39912923433993E-11  -1.29697052970713E-18  -4.81904356659480E-03  -4.81904356705983E-03
      0.00000000000000E+00   0.00000000000000E+00   4.65026808283663E-10   0.00000000000000E+00   4.65026808283663E-10
      4.37976469403618E-18  -2.94700617490362E-01  -2.94577418886174E-01   0.00000000000000E+00  -1.34191845477488E-11
     -1.39480666829104E-22  -3.77616331392393E-10  -3.91035515940281E-10  -3.08279416432906E-18
      1.45925480656725E-08
      0.00000000000000E+00   6.41994713080612E-14   0.00000000000000E+00   1.54710053871440E-14  -4.79362596554745E-23
     -6.42562019500583E-11  -6.42407309447191E-11  -1.29746409111144E-18  -4.61037221056468E-03  -4.61037221110832E-03
      0.00000000000000E+00   0.00000000000000E+00   5.43636670476502E-10   0.00000000000000E+00   5.43636670476502E-10
      4.40694652756001E-18  -3.07635478354206E-01  -3.07484439226500E-01   0.00000000000000E+00  -1.97649745467880E-11
     -1.41328927558035E-22  -4.59630964984855E-10  -4.79395939531784E-10  -3.10948243644857E-18
      1.46425480656725E-08
      0.00000000000000E+00   5.40965502152333E-14   0.00000000000000E+00   1.69971765062435E-14  -4.78985599377229E-23
     -5.41643617789925E-11  -5.41473646025342E-11  -1.29751979137922E-18  -4.60385572923141E-03  -4.60385572979948E-03
      0.00000000000000E+00   0.00000000000000E+00   5.68061842989887E-10   0.00000000000000E+00   5.68061842989887E-10
      4.43534961970950E-18  -3.22133344321025E-01  -3.21971429194908E-01   0.00000000000000E+00  -2.29862241321888E-11
     -1.43424308883310E-22  -4.90928254255035E-10  -5.13914478387367E-10  -3.13782982833028E-18
      1.46925480656725E-08
      0.00000000000000E+00   2.14916685065613E-14   0.00000000000000E+00   4.41565549376082E-14  -4.78334027410255E-23
     -2.15670399484991E-11  -2.15228833936093E-11  -1.29602024746861E-18  -5.51728296190749E-03  -5.51728296241313E-03
      0.00000000000000E+00   0.00000000000000E+00   5.05644136903397E-10   0.00000000000000E+00   5.05644136903397E-10
      4.46063182655467E-18  -3.36444135892347E-01  -3.36291608221506E-01   0.00000000000000E+00  -2.17534919142324E-11
     -1.45359098421478E-22  -4.62367761595396E-10  -4.84121253509774E-10  -3.16461157908606E-18
      1.47425480656725E-08
      0.00000000000000E+00  -1.31521663681178E-13   0.00000000000000E+00   1.87155668318489E-13  -4.76314365780448E-23
      1.31316396988834E-10   1.31503552657105E-10  -1.28700377259739E-18  -1.08915966204086E-02  -1.08915966206421E-02
      0.00000000000000E+00   0.00000000000000E+00   2.33503438488492E-10   0.00000000000000E+00   2.33503438488492E-10
      4.47230699847910E-18  -3.50479986060779E-01  -3.50364989494002E-01   0.00000000000000E+00  -1.33225328800891E-11
     -1.46529541229854E-22  -3.51684458265349E-10  -3.65006991145585E-10  -3.18530322588171E-18
      1.47925480656725E-08
      0.00000000000000E+00  -6.34922668315632E-13   0.00000000000000E+00   6.05568842703700E-13  -4.69853812816236E-23
      6.34279802061402E-10   6.34885370904058E-10  -1.25331859241912E-18  -3.05729915549647E-02  -3.05729915543696E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.95099447903936E-10   0.00000000000000E+00  -5.95099447903936E-10
      4.44255202608390E-18  -3.65480983181333E-01  -3.65468459246879E-01   0.00000000000000E+00   1.19271639523839E-11
     -1.45531756278984E-22  -5.17130869523574E-11  -3.97859230001191E-11  -3.18923343366478E-18
      1.48175480656725E-08
      0.00000000000000E+00  -9.61155174876767E-13   0.00000000000000E+00   7.86866921498052E-13  -4.65287224830467E-23
      9.60401106090894E-10   9.61187973012346E-10  -1.22861937297374E-18  -4.46898695905545E-02  -4.46898695894404E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.11405130467325E-09   0.00000000000000E+00  -1.11405130467325E-09
      4.41470074346707E-18  -3.73221830176849E-01  -3.73270007564681E-01   0.00000000000000E+00   2.65466193261250E-11
     -1.44392554241277E-22   1.26316712334923E-10   1.52863331660904E-10  -3.18608137049334E-18
      1.48512980656725E-08
      0.00000000000000E+00  -1.21363635746026E-12   0.00000000000000E+00   5.25706744107090E-13  -4.58216015866913E-23
      1.21314256427053E-09   1.21366827101460E-09  -1.18792305193609E-18  -6.73466134611160E-02  -6.73466134596354E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.48051274520875E-09   0.00000000000000E+00  -1.48051274520875E-09
      4.36473343831627E-18  -3.83504345845364E-01  -3.83588438512982E-01   0.00000000000000E+00   3.53317689877833E-11
     -1.42286647464438E-22   2.31512705206470E-10   2.66844474194111E-10  -3.17681038638018E-18
      1.48740793156725E-08
      0.00000000000000E+00  -1.36609862122475E-12   0.00000000000000E+00   4.81968800874420E-13  -4.53083136569282E-23
      1.36565813320479E-09   1.36614010200562E-09  -1.15799822991995E-18  -8.35699445247520E-02  -8.35699445230908E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.66121903587711E-09   0.00000000000000E+00  -1.66121903587711E-09
      4.32688879215520E-18  -3.90201025151048E-01  -3.90294016123831E-01   0.00000000000000E+00   3.81984118070590E-11
     -1.40703131269892E-22   2.56880522064509E-10   2.95078933871428E-10  -3.16889056223525E-18
      1.49048340031725E-08
      0.00000000000000E+00  -1.54032808770743E-12   0.00000000000000E+00   4.21228898863640E-13  -4.45856075040865E-23
      1.53993622493321E-09   1.54035745383203E-09  -1.11566050324140E-18  -1.05909727711822E-01  -1.05909727710041E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.78088488354434E-09   0.00000000000000E+00  -1.78088488354434E-09
      4.27211823408832E-18  -3.98573691520879E-01  -3.98649500600504E-01   0.00000000000000E+00   3.93127969515283E-11
     -1.38419510124897E-22   2.01214632760934E-10   2.40527429712324E-10  -3.15645773084692E-18
      1.49463528312975E-08
      0.00000000000000E+00  -1.92479015765814E-12   0.00000000000000E+00   5.81792809757631E-13  -4.29431692853654E-23
      1.92416430938286E-09   1.92474610219257E-09  -1.05637190228561E-18  -1.36059836325524E-01  -1.36059836323613E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.91150538399571E-09   0.00000000000000E+00  -1.91150538399571E-09
      4.19275477059019E-18  -4.07917515714232E-01  -4.07913386194736E-01   0.00000000000000E+00   4.03068572697138E-11
     -1.35069297799659E-22  -5.35475754664250E-11  -1.32407181968463E-11  -3.13638286830458E-18
      1.49963528312975E-08
      0.00000000000000E+00  -3.05218430688053E-12   0.00000000000000E+00   1.21801059193930E-12  -3.59683771513361E-23
      3.05100767908162E-09   3.05222568967353E-09  -9.81530250626042E-19  -1.72335213896482E-01  -1.72335213894307E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.17415251197685E-09   0.00000000000000E+00  -2.17415251197685E-09
      4.08404714499134E-18  -4.13297410329258E-01  -4.13020844779336E-01   0.00000000000000E+00   4.47116685962425E-11
     -1.30188944185674E-22  -9.22784846292822E-10  -8.78073177696709E-10  -3.10251689436530E-18
      1.50000000000000E-08
      0.00000000000000E+00  -3.22861804705619E-12   0.00000000000000E+00   2.46530445493604E-12  -3.50338250302356E-23
      3.22617993178859E-09   3.22864523624349E-09  -9.75906738984331E-19  -1.74995049288951E-01  -1.74995049286688E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.26258721673291E-09   0.00000000000000E+00  -2.26258721673291E-09
      4.07579510770790E-18  -4.13643883619799E-01  -4.13339599902648E-01   0.00000000000000E+00   4.29338198962706E-11
     -1.29827847631388E-22  -1.00899183940668E-09  -9.66058019510542E-10  -3.09988836872357E-18
}
